/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.jobflow.builder;

import java.util.ArrayList;
import java.util.List;
import org.frameworkset.tran.jobflow.JobFlow;
import org.frameworkset.tran.jobflow.builder.JobFlowNodeBuilder;
import org.frameworkset.tran.jobflow.listener.JobFlowListener;
import org.frameworkset.tran.jobflow.schedule.JobFlowScheduleConfig;

public class JobFlowBuilder {
    private String jobFlowId;
    private String jobFlowName;
    private JobFlowScheduleConfig jobFlowScheduleConfig;
    private JobFlowNodeBuilder headerJobFlowNodeBuilder;
    private JobFlowNodeBuilder currentJobFlowNodeBuilder;
    private boolean externalTimer;
    private List<JobFlowListener> jobFlowListeners;

    public JobFlowBuilder setJobFlowId(String jobFlowId) {
        this.jobFlowId = jobFlowId;
        return this;
    }

    public JobFlowBuilder addJobFlowListener(JobFlowListener jobFlowListener) {
        if (this.jobFlowListeners == null) {
            this.jobFlowListeners = new ArrayList<JobFlowListener>();
        }
        this.jobFlowListeners.add(jobFlowListener);
        return this;
    }

    public JobFlowBuilder setJobFlowName(String jobFlowName) {
        this.jobFlowName = jobFlowName;
        return this;
    }

    public JobFlowBuilder addJobFlowNode(JobFlowNodeBuilder jobFlowNodeBuilder) {
        if (this.headerJobFlowNodeBuilder == null) {
            this.headerJobFlowNodeBuilder = jobFlowNodeBuilder;
        }
        if (this.currentJobFlowNodeBuilder != null) {
            this.currentJobFlowNodeBuilder.setNextJobFlowNodeBuilder(jobFlowNodeBuilder);
        }
        this.currentJobFlowNodeBuilder = jobFlowNodeBuilder;
        return this;
    }

    public JobFlow build() {
        JobFlow jobFlow = new JobFlow();
        jobFlow.setJobFlowName(this.jobFlowName);
        jobFlow.setJobFlowId(this.jobFlowId);
        jobFlow.setJobFlowListeners(this.jobFlowListeners);
        if (!this.isExternalTimer()) {
            jobFlow.setJobScheduleConfig(this.jobFlowScheduleConfig);
        } else {
            jobFlow.setExternalTimer(this.isExternalTimer());
        }
        jobFlow.initJobInfo();
        jobFlow.setStartJobFlowNode(this.headerJobFlowNodeBuilder.build(jobFlow));
        return jobFlow;
    }

    public boolean isExternalTimer() {
        return this.externalTimer;
    }

    public JobFlowBuilder setExternalTimer(boolean externalTimer) {
        this.externalTimer = externalTimer;
        return this;
    }

    public void setJobFlowScheduleConfig(JobFlowScheduleConfig jobFlowScheduleConfig) {
        this.jobFlowScheduleConfig = jobFlowScheduleConfig;
    }
}

