/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.jobflow.script;

import com.frameworkset.util.SimpleStringUtil;
import groovy.lang.GroovyClassLoader;
import org.apache.commons.lang3.StringUtils;
import org.frameworkset.tran.jobflow.JobFlow;
import org.frameworkset.tran.jobflow.NodeTrigger;
import org.frameworkset.tran.jobflow.script.TriggerScriptAPI;
import org.frameworkset.tran.script.CodeStruction;
import org.frameworkset.tran.script.GroovyScriptException;
import org.frameworkset.tran.script.GroovyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerScriptUtil {
    private static Logger logger = LoggerFactory.getLogger(TriggerScriptUtil.class);

    public static TriggerScriptAPI evalTriggerScript(JobFlow jobFlow, NodeTrigger nodeTrigger) {
        String script = null;
        try {
            GroovyClassLoader groovyClassLoader = jobFlow.getGroovyClassLoader();
            CodeStruction codeStruction = GroovyUtil.parseCode(nodeTrigger.getTriggerScript());
            StringBuilder code = new StringBuilder();
            if (StringUtils.isNotEmpty((CharSequence)codeStruction.getImports())) {
                code.append(codeStruction.getImports());
            }
            code.append("import org.frameworkset.tran.jobflow.JobFlow;\n");
            code.append("import org.frameworkset.tran.jobflow.JobFlowNode;\n");
            code.append("import org.frameworkset.tran.jobflow.context.NodeTriggerContext;\n");
            code.append("import org.frameworkset.tran.jobflow.context.StaticContext;\n");
            code.append("import org.frameworkset.tran.jobflow.context.JobFlowExecuteContext;\n");
            code.append("import org.frameworkset.tran.jobflow.script.TriggerScriptAPI;\n");
            code.append("\n");
            String apiName = "TriggerScriptAPIImpl_" + SimpleStringUtil.getUUID32();
            code.append("public class " + apiName + " implements TriggerScriptAPI {\r\n");
            code.append("boolean needTrigger(NodeTriggerContext nodeTriggerContext) throws Exception {\r\n").append(codeStruction.getCode()).append("\r\n}\r\n}");
            script = code.toString();
            if (logger.isDebugEnabled()) {
                logger.debug("apiName {},evalTriggerScript: {} ", (Object)apiName, (Object)nodeTrigger.getTriggerScript());
            }
            return GroovyUtil.defineAPI(groovyClassLoader, script, TriggerScriptAPI.class);
        }
        catch (Exception e) {
            throw new GroovyScriptException(script, e);
        }
    }
}

