/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.script;

import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyShell;
import org.frameworkset.tran.script.CodeStruction;
import org.frameworkset.tran.script.GroovyEvalException;
import org.frameworkset.tran.script.GroovyScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyUtil {
    private static final Logger log = LoggerFactory.getLogger(GroovyUtil.class);

    public static Object evaluate(Binding binding, String script) throws GroovyEvalException {
        GroovyShell groovyShell = null;
        try {
            Object value;
            groovyShell = new GroovyShell(binding);
            Object object = value = groovyShell.evaluate(script);
            return object;
        }
        catch (Exception evalError) {
            throw new GroovyEvalException(script, evalError);
        }
        finally {
            groovyShell.resetLoadedClasses();
            groovyShell = null;
        }
    }

    public static CodeStruction parseCode(String code) {
        CodeStruction codeStruction = new CodeStruction();
        if (code == null || code.equals("")) {
            codeStruction.setCode("");
            return codeStruction;
        }
        code = code.trim();
        String imports = null;
        if (code.startsWith("[import]")) {
            StringBuilder builder = new StringBuilder();
            int start = "[import]".length();
            if (code.length() > start) {
                block6: {
                    do {
                        char c;
                        if ((c = code.charAt(start)) == '[') {
                            if ((start += "[/import]".length()) > code.length()) {
                                throw new GroovyScriptException("code import define error\uff0cimport\u5305\u7684\u683c\u5f0f\u4e3a[import]import\u7c7b\u6e05\u5355[/import]\uff0c\u4f8b\u5982\uff1a[import]import java.sql.SQLException;import java.util.Date;[/import]\r\n" + code);
                            }
                            break block6;
                        }
                        builder.append(code.charAt(start));
                    } while (++start <= code.length());
                    throw new GroovyScriptException("code import define error\uff0cimport\u5305\u7684\u683c\u5f0f\u4e3a[import]import\u7c7b\u6e05\u5355[/import]\uff0c\u4f8b\u5982\uff1a[import]import java.sql.SQLException;import java.util.Date;[/import]\r\n" + code);
                }
                code = code.substring(start);
                imports = builder.toString();
                codeStruction.setImports(imports);
            }
        }
        codeStruction.setCode(code);
        return codeStruction;
    }

    public static void main(String[] args) {
    }

    public static <T> T defineAPI(GroovyClassLoader groovyClassLoader, String apiCode, Class<T> apiType) {
        try {
            Class filenameGeneratorAPIClass = groovyClassLoader.parseClass(apiCode);
            log.info("DefineAPI impl class:" + filenameGeneratorAPIClass.getCanonicalName());
            Object api = filenameGeneratorAPIClass.newInstance();
            return api;
        }
        catch (Exception exception) {
            throw new GroovyScriptException("Define " + apiType.getCanonicalName() + " failed:" + apiCode, exception);
        }
    }
}

