/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.metrics.job;

import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.frameworkset.tran.metrics.entity.KeyMetric;
import org.frameworkset.tran.metrics.job.BaseMetrics;
import org.frameworkset.tran.metrics.job.FlushCallback;
import org.frameworkset.tran.metrics.job.MetricsException;
import org.frameworkset.util.concurrent.ThreadPoolFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyMetricsPersistent {
    private static Logger logger = LoggerFactory.getLogger(KeyMetricsPersistent.class);
    private ExecutorService executor;
    private int persistentWorkThreads = 10;
    private int persistentWorkThreadQueue = 100;
    private int persistentBlockedWaitTimeout = 0;
    private int persistentWarnMultsRejects = 100;
    private boolean stoped;
    private BaseMetrics persistent;
    private String persistentName;
    private Object stopLock = new Object();

    public KeyMetricsPersistent() {
        this.persistentName = "KeyMetrics";
    }

    public KeyMetricsPersistent(String persistentName) {
        this.persistentName = persistentName;
    }

    public void setPersistent(BaseMetrics persistent) {
        this.persistent = persistent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.stopLock;
        synchronized (object) {
            if (this.stoped) {
                return;
            }
            this.stoped = true;
        }
        logger.info("{}-Persistent begin......", (Object)this.persistentName);
        if (this.executor != null) {
            ThreadPoolFactory.shutdownExecutor((ExecutorService)this.executor);
        }
        logger.info("{}-Persistent completed.", (Object)this.persistentName);
    }

    public void init() {
        this.executor = ThreadPoolFactory.buildThreadPool((String)(this.persistentName + "Persistent"), (String)(this.persistentName + " Persistent"), (int)this.persistentWorkThreads, (int)this.persistentWorkThreadQueue, (long)this.persistentBlockedWaitTimeout, (int)this.persistentWarnMultsRejects);
    }

    public Future persistent(Collection<KeyMetric> persistentMetrics) {
        return this.persistent(persistentMetrics, null);
    }

    public Future persistent(final Collection<KeyMetric> persistentMetrics, final FlushCallback flushCallback) {
        if (this.stoped) {
            throw new MetricsException("metrics persistent has stopped.");
        }
        return this.executor.submit(new Runnable(){

            @Override
            public void run() {
                KeyMetricsPersistent.this.persistent.persistent(persistentMetrics);
                if (flushCallback != null) {
                    try {
                        flushCallback.callback();
                    }
                    catch (Exception e) {
                        logger.error("flushCallback failed:", (Throwable)e);
                    }
                }
            }
        });
    }
}

