/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.metrics.job;

import com.frameworkset.util.SimpleStringUtil;
import java.lang.invoke.LambdaMetafactory;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import org.frameworkset.tran.metrics.entity.KeyMetric;
import org.frameworkset.tran.metrics.entity.MapData;
import org.frameworkset.tran.metrics.entity.MetricKey;
import org.frameworkset.tran.metrics.entity.TimeMetric;
import org.frameworkset.tran.metrics.job.BaseMetrics;
import org.frameworkset.tran.metrics.job.FlushOlder;
import org.frameworkset.tran.metrics.job.KeyMetricBuilder;
import org.frameworkset.tran.metrics.job.KeyMetricsPersistent;
import org.frameworkset.tran.metrics.job.KeyTimeScanTask;
import org.frameworkset.tran.metrics.job.MetricUtil;
import org.frameworkset.tran.metrics.job.MetricsConfig;
import org.frameworkset.tran.metrics.job.PersistentDataHolder;
import org.frameworkset.util.TimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KeyTimeMetrics
implements BaseMetrics {
    private String metricsName = "KeyTimeMetrics";
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private Lock read = this.lock.readLock();
    private Lock write = this.lock.writeLock();
    private FlushOlder flushOlder;
    private int segmentBoundSize = 10000000;
    private Map<String, Map<String, TimeMetric>> timeMetrics0;
    private Map<String, Map<String, TimeMetric>> timeMetrics1;
    private int persistentDataHolderSize = 5000;
    private static Logger logger = LoggerFactory.getLogger(KeyTimeMetrics.class);
    private KeyTimeScanTask metricsThread;
    private MetricsConfig metricsConfig;
    private KeyMetricsPersistent metricsPersistent;
    private int timeWindowType = 2;
    private long scanInterval = 5000L;
    private int timeWindows = 60;
    private boolean stoped;
    private Object stopLock = new Object();

    public void setSegmentBoundSize(int segmentBoundSize) {
        this.segmentBoundSize = segmentBoundSize;
    }

    public int getSegmentBoundSize() {
        return this.segmentBoundSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, TimeMetric> getTimeKeyMetrics(String metricsKey) {
        Map<String, TimeMetric> metric = this.timeMetrics1.get(metricsKey);
        if (metric == null) {
            metric = this.timeMetrics0.get(metricsKey);
        }
        if (metric != null) {
            return metric;
        }
        Map<String, Map<String, TimeMetric>> timeMetrics0Temp = null;
        this.write.lock();
        try {
            metric = this.timeMetrics1.get(metricsKey);
            if (metric == null) {
                metric = this.timeMetrics0.get(metricsKey);
            }
            if (metric == null) {
                if (this.timeMetrics0.size() >= this.segmentBoundSize) {
                    if (this.timeMetrics1.isEmpty()) {
                        timeMetrics0Temp = this.timeMetrics0;
                        this.timeMetrics0 = this.timeMetrics1;
                        this.timeMetrics1 = timeMetrics0Temp;
                        timeMetrics0Temp = null;
                    } else {
                        timeMetrics0Temp = this.timeMetrics1;
                        this.timeMetrics1 = this.timeMetrics0;
                        this.timeMetrics0 = new HashMap<String, Map<String, TimeMetric>>();
                    }
                }
                metric = new LinkedHashMap<String, TimeMetric>();
                this.timeMetrics0.put(metricsKey, metric);
            }
        }
        finally {
            this.write.unlock();
        }
        if (timeMetrics0Temp != null && timeMetrics0Temp.size() > 0) {
            logger.info("timeMetrics0 and timeMetrics1 is full, force flush timeMetrics1");
            this.flushOlder.add(timeMetrics0Temp);
        }
        return metric;
    }

    public void setPersistentDataHolderSize(int persistentDataHolderSize) {
        this.persistentDataHolderSize = persistentDataHolderSize;
    }

    public void persistentOlder(Map<String, Map<String, TimeMetric>> timeMetricsOlder) {
        PersistentDataHolder persistentDataHolder = new PersistentDataHolder();
        persistentDataHolder.init();
        timeMetricsOlder.entrySet().forEach(entry -> {
            Map metricMap;
            Map map = metricMap = (Map)entry.getValue();
            synchronized (map) {
                for (Map.Entry minutesMetric : metricMap.entrySet()) {
                    TimeMetric metric = (TimeMetric)minutesMetric.getValue();
                    persistentDataHolder.addKeyMetric(metric);
                    if (persistentDataHolder.size() < this.persistentDataHolderSize) continue;
                    this.metricsPersistent.persistent(persistentDataHolder.getPersistentData());
                    persistentDataHolder.init();
                }
                metricMap.clear();
            }
        });
        timeMetricsOlder.clear();
        if (persistentDataHolder.size() > 0) {
            this.metricsPersistent.persistent(persistentDataHolder.getPersistentData());
            persistentDataHolder.clear();
        }
    }

    private boolean needPersistent(Date slot, TimeMetric metric) {
        return metric.getSlotTime().before(slot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<KeyMetric> scanPersistentMetrics() {
        if (logger.isDebugEnabled()) {
            logger.debug("Scan persistent keytime metrics begin.....");
        }
        long start = System.currentTimeMillis();
        Date slot = TimeUtil.addDateSeconds((Date)new Date(), (int)this.metricsConfig.getTimeWindows());
        ArrayList<KeyMetric> persistentData = new ArrayList<KeyMetric>();
        this.read.lock();
        try {
            if (this.timeMetrics0.size() > 0) {
                this._scanPersistentMetrics(persistentData, slot, this.timeMetrics0);
            }
            if (this.timeMetrics1.size() > 0) {
                this._scanPersistentMetrics(persistentData, slot, this.timeMetrics1);
            }
        }
        finally {
            this.read.unlock();
        }
        if (logger.isDebugEnabled()) {
            long end = System.currentTimeMillis();
            if (persistentData != null) {
                logger.debug("Scan persistent keytime metrics complete,persistent metrics:{},take times:{} ms", (Object)persistentData.size(), (Object)(end - start));
            } else {
                logger.debug("Scan persistent keytime metrics complete,persistent metrics:0,take times:{} ms", (Object)(end - start));
            }
        }
        return persistentData;
    }

    private void _scanPersistentMetrics(List<KeyMetric> persistentData, Date slot, Map<String, Map<String, TimeMetric>> timeMetrics) {
        timeMetrics.entrySet().forEach(entry -> {
            Map metricMap;
            Map map = metricMap = (Map)entry.getValue();
            synchronized (map) {
                Map.Entry minutesMetric;
                TimeMetric metric;
                ArrayList<String> metricKeys = new ArrayList<String>();
                Iterator iterator = metricMap.entrySet().iterator();
                while (iterator.hasNext() && this.needPersistent(slot, metric = (TimeMetric)(minutesMetric = iterator.next()).getValue())) {
                    metricKeys.add((String)minutesMetric.getKey());
                    persistentData.add(metric);
                }
                if (metricKeys.size() > 0) {
                    for (String key : metricKeys) {
                        metricMap.remove(key);
                    }
                }
            }
        });
    }

    public DateFormat getMetricsTimeKeyFormat(MapData data) {
        return MetricUtil.getMetricsTimeKeyFormat(this.timeWindowType, data);
    }

    @Override
    public TimeMetric metric(String metricsKey, MapData data, KeyMetricBuilder metricBuilder) {
        return this.metric(new MetricKey(metricsKey), data, metricBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TimeMetric metric(MetricKey metricsKey, MapData data, KeyMetricBuilder metricBuilder) {
        DateFormat dateFormat;
        if (!metricBuilder.validateData(data)) {
            if (logger.isDebugEnabled()) {
                logger.debug("data validate failed:{}", (Object)SimpleStringUtil.object2json(data.getData()));
            }
            return null;
        }
        Map<String, TimeMetric> metrics = this.getTimeKeyMetrics(metricsKey.getMetricKey());
        Date time = data.metricsDataTime(metricsKey);
        DateFormat metricTimeDateFormat = dateFormat = this.getMetricsTimeKeyFormat(data);
        String metricsTime = dateFormat.format(time);
        TimeMetric metric = null;
        Map<String, TimeMetric> map = metrics;
        synchronized (map) {
            metric = metrics.get(metricsTime);
            if (metric == null) {
                metric = (TimeMetric)metricBuilder.build();
                metric.setMetricsLogAPI(this.getMetricsLogAPI());
                MetricUtil.buildMetricTimeField(metric, data, time);
                metric.setMetric(metricsKey.getMetricKey());
                try {
                    metric.setDataTime(metricTimeDateFormat.parse(metricsTime));
                }
                catch (Exception e) {
                    logger.error("\u8bbe\u7f6e\u6307\u6807\u65f6\u95f4\u5f02\u5e38", (Throwable)e);
                }
                metric.setSlotTime(new Date());
                metric.setMetricTimeKey(metricsTime);
                metric.init(data);
                metrics.put(metricsTime, metric);
            }
            metric.increment(data);
        }
        return metric;
    }

    public int getTimeWindowType() {
        return this.timeWindowType;
    }

    public void setTimeWindowType(int timeWindowType) {
        this.timeWindowType = timeWindowType;
    }

    public void setTimeWindows(int timeWindows) {
        this.timeWindows = timeWindows;
    }

    public void setScanInterval(long scanInterval) {
        this.scanInterval = scanInterval;
    }

    @Override
    public void init() {
        this.timeMetrics0 = new HashMap<String, Map<String, TimeMetric>>();
        this.timeMetrics1 = new HashMap<String, Map<String, TimeMetric>>();
        MetricsConfig metricsConfig = new MetricsConfig();
        metricsConfig.setScanInterval(this.scanInterval);
        if (this.timeWindows > 0) {
            metricsConfig.setTimeWindows(0 - this.timeWindows);
        } else if (this.timeWindows < 0) {
            metricsConfig.setTimeWindows(this.timeWindows);
        } else {
            metricsConfig.setTimeWindows(-300);
        }
        this.metricsConfig = metricsConfig;
        KeyMetricsPersistent metricsPersistent = new KeyMetricsPersistent();
        metricsPersistent.setPersistent(this);
        metricsPersistent.init();
        this.metricsPersistent = metricsPersistent;
        KeyTimeScanTask scanTask = new KeyTimeScanTask("KeyTimeScanTask-" + this.metricsName);
        scanTask.setMetricsConfig(metricsConfig);
        scanTask.setMetricsPersistent(metricsPersistent);
        scanTask.setMetrics(this);
        scanTask.start();
        this.metricsThread = scanTask;
        this.flushOlder = new FlushOlder();
        this.flushOlder.setKeyTimeMetrics(this);
        this.flushOlder.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopMetrics() {
        if (this.stoped) {
            return;
        }
        Object object = this.stopLock;
        synchronized (object) {
            if (this.stoped) {
                return;
            }
            this.stoped = true;
        }
        if (this.metricsThread != null) {
            this.metricsThread.stopScan();
            this.flushOlder.stopFlush();
            this.forceFlush(true, true);
        }
        if (this.metricsPersistent != null) {
            this.metricsPersistent.stop();
        }
    }

    public List<KeyMetric> getAll() {
        ArrayList<KeyMetric> persistentData = new ArrayList<KeyMetric>();
        this.read.lock();
        try {
            this.timeMetrics0.entrySet().forEach(entry -> {
                Map metricMap;
                Map map = metricMap = (Map)entry.getValue();
                synchronized (map) {
                    for (Map.Entry minutesMetric : metricMap.entrySet()) {
                        TimeMetric metric = (TimeMetric)minutesMetric.getValue();
                        persistentData.add(metric);
                    }
                    metricMap.clear();
                }
            });
            this.timeMetrics1.entrySet().forEach(entry -> {
                Map metricMap;
                Map map = metricMap = (Map)entry.getValue();
                synchronized (map) {
                    for (Map.Entry minutesMetric : metricMap.entrySet()) {
                        TimeMetric metric = (TimeMetric)minutesMetric.getValue();
                        persistentData.add(metric);
                    }
                    metricMap.clear();
                }
            });
        }
        finally {
            this.read.unlock();
        }
        return persistentData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void forceFlush(boolean cleanMetricsKey, boolean waitComplete) {
        KeyTimeMetrics.logger.info("Force Flush timemetrics start.waitComplete:{},cleanMetricsKey:{}", (Object)waitComplete, (Object)cleanMetricsKey);
        s = System.currentTimeMillis();
        persistentData = new PersistentDataHolder();
        persistentData.init();
        futures = new ArrayList<Future>();
        if (!cleanMetricsKey) {
            this.read.lock();
            try {
                this.timeMetrics0.entrySet().forEach((Consumer<Map.Entry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$forceFlush$4(org.frameworkset.tran.metrics.job.PersistentDataHolder boolean java.util.List java.util.Map$Entry ), (Ljava/util/Map$Entry;)V)((KeyTimeMetrics)this, (PersistentDataHolder)persistentData, (boolean)waitComplete, futures));
                this.timeMetrics1.entrySet().forEach((Consumer<Map.Entry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$forceFlush$5(org.frameworkset.tran.metrics.job.PersistentDataHolder boolean java.util.List java.util.Map$Entry ), (Ljava/util/Map$Entry;)V)((KeyTimeMetrics)this, (PersistentDataHolder)persistentData, (boolean)waitComplete, futures));
                if (persistentData.size() <= 0) ** GOTO lbl37
                future = this.metricsPersistent.persistent(persistentData.getPersistentData());
                if (waitComplete) {
                    futures.add(future);
                }
                persistentData.clear();
            }
            finally {
                this.read.unlock();
            }
        } else {
            this.write.lock();
            try {
                this.timeMetrics0.entrySet().forEach((Consumer<Map.Entry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$forceFlush$6(org.frameworkset.tran.metrics.job.PersistentDataHolder boolean java.util.List java.util.Map$Entry ), (Ljava/util/Map$Entry;)V)((KeyTimeMetrics)this, (PersistentDataHolder)persistentData, (boolean)waitComplete, futures));
                this.timeMetrics1.entrySet().forEach((Consumer<Map.Entry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$forceFlush$7(org.frameworkset.tran.metrics.job.PersistentDataHolder boolean java.util.List java.util.Map$Entry ), (Ljava/util/Map$Entry;)V)((KeyTimeMetrics)this, (PersistentDataHolder)persistentData, (boolean)waitComplete, futures));
                if (persistentData.size() > 0) {
                    future = this.metricsPersistent.persistent(persistentData.getPersistentData());
                    if (waitComplete) {
                        futures.add(future);
                    }
                    persistentData.clear();
                }
                this.timeMetrics0.clear();
                this.timeMetrics1.clear();
            }
            finally {
                this.write.unlock();
            }
        }
        if (waitComplete && futures.size() > 0) {
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (InterruptedException var9_11) {
                }
                catch (ExecutionException e) {
                    KeyTimeMetrics.logger.error("", (Throwable)e);
                }
            }
        }
        KeyTimeMetrics.logger.info("Force Flush keytimemetrics complete elapse:{} ms.", (Object)(System.currentTimeMillis() - s));
    }

    public String getMetricsName() {
        return this.metricsName;
    }

    @Override
    public void setMetricsName(String metricsName) {
        this.metricsName = metricsName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$forceFlush$7(PersistentDataHolder persistentData, boolean waitComplete, List futures, Map.Entry entry) {
        Map metricMap;
        Map map = metricMap = (Map)entry.getValue();
        synchronized (map) {
            for (Map.Entry minutesMetric : metricMap.entrySet()) {
                TimeMetric metric = (TimeMetric)minutesMetric.getValue();
                persistentData.addKeyMetric(metric);
                if (persistentData.size() < this.persistentDataHolderSize) continue;
                Future future = this.metricsPersistent.persistent(persistentData.getPersistentData());
                if (waitComplete) {
                    futures.add(future);
                }
                persistentData.init();
            }
            metricMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$forceFlush$6(PersistentDataHolder persistentData, boolean waitComplete, List futures, Map.Entry entry) {
        Map metricMap;
        Map map = metricMap = (Map)entry.getValue();
        synchronized (map) {
            for (Map.Entry minutesMetric : metricMap.entrySet()) {
                TimeMetric metric = (TimeMetric)minutesMetric.getValue();
                persistentData.addKeyMetric(metric);
                if (persistentData.size() < this.persistentDataHolderSize) continue;
                Future future = this.metricsPersistent.persistent(persistentData.getPersistentData());
                if (waitComplete) {
                    futures.add(future);
                }
                persistentData.init();
            }
            metricMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$forceFlush$5(PersistentDataHolder persistentData, boolean waitComplete, List futures, Map.Entry entry) {
        Map metricMap;
        Map map = metricMap = (Map)entry.getValue();
        synchronized (map) {
            for (Map.Entry minutesMetric : metricMap.entrySet()) {
                TimeMetric metric = (TimeMetric)minutesMetric.getValue();
                persistentData.addKeyMetric(metric);
                if (persistentData.size() < this.persistentDataHolderSize) continue;
                Future future = this.metricsPersistent.persistent(persistentData.getPersistentData());
                if (waitComplete) {
                    futures.add(future);
                }
                persistentData.init();
            }
            metricMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$forceFlush$4(PersistentDataHolder persistentData, boolean waitComplete, List futures, Map.Entry entry) {
        Map metricMap;
        Map map = metricMap = (Map)entry.getValue();
        synchronized (map) {
            for (Map.Entry minutesMetric : metricMap.entrySet()) {
                TimeMetric metric = (TimeMetric)minutesMetric.getValue();
                persistentData.addKeyMetric(metric);
                if (persistentData.size() < this.persistentDataHolderSize) continue;
                Future future = this.metricsPersistent.persistent(persistentData.getPersistentData());
                if (waitComplete) {
                    futures.add(future);
                }
                persistentData.init();
            }
            metricMap.clear();
        }
    }
}

