/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.metrics.job;

import java.util.List;
import org.frameworkset.tran.metrics.entity.KeyMetric;
import org.frameworkset.tran.metrics.job.KeyMetricsPersistent;
import org.frameworkset.tran.metrics.job.MetricsConfig;
import org.frameworkset.tran.metrics.job.MetricsThread;
import org.frameworkset.tran.metrics.job.TimeMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanTask
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(ScanTask.class);
    private MetricsConfig metricsConfig;
    private KeyMetricsPersistent metricsPersistent;
    private TimeMetrics metrics;
    private boolean stoped;
    private MetricsThread metricsThread;
    private Object stopScanLock = new Object();

    public void setMetricsThread(MetricsThread metricsThread) {
        this.metricsThread = metricsThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopScan() {
        Object object = this.stopScanLock;
        synchronized (object) {
            if (this.stoped) {
                return;
            }
            this.stoped = true;
        }
        this.metricsThread.interrupt();
        try {
            this.metricsThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        while (!this.stoped) {
            block3: {
                try {
                    Thread.sleep(this.metricsConfig.getScanInterval());
                }
                catch (InterruptedException e) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug("ScanTask is Interrupted:", (Throwable)e);
                }
            }
            if (this.stoped) break;
            List<KeyMetric> persistentMetrics = this.metrics.scanPersistentMetrics();
            if (persistentMetrics.size() <= 0) continue;
            this.metricsPersistent.persistent(persistentMetrics);
        }
    }

    public void setMetricsConfig(MetricsConfig metricsConfig) {
        this.metricsConfig = metricsConfig;
    }

    public void setMetricsPersistent(KeyMetricsPersistent metricsPersistent) {
        this.metricsPersistent = metricsPersistent;
    }

    public void setMetrics(TimeMetrics metrics) {
        this.metrics = metrics;
    }
}

