/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.tran.metrics.job;

import com.frameworkset.util.SimpleStringUtil;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.frameworkset.tran.metrics.entity.KeyMetric;
import org.frameworkset.tran.metrics.entity.MapData;
import org.frameworkset.tran.metrics.entity.MetricKey;
import org.frameworkset.tran.metrics.entity.TimeMetric;
import org.frameworkset.tran.metrics.job.BaseMetrics;
import org.frameworkset.tran.metrics.job.KeyMetricBuilder;
import org.frameworkset.tran.metrics.job.KeyMetricsPersistent;
import org.frameworkset.tran.metrics.job.MetricUtil;
import org.frameworkset.tran.metrics.job.MetricsConfig;
import org.frameworkset.tran.metrics.job.MetricsThread;
import org.frameworkset.tran.metrics.job.PersistentDataHolder;
import org.frameworkset.tran.metrics.job.ScanTask;
import org.frameworkset.util.TimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TimeMetrics
implements BaseMetrics {
    private String metricsName = "TimeMetrics";
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private Lock read = this.lock.readLock();
    private Lock write = this.lock.writeLock();
    private Map<String, Map<String, TimeMetric>> timeMetrics = new HashMap<String, Map<String, TimeMetric>>();
    private static Logger logger = LoggerFactory.getLogger(TimeMetrics.class);
    private MetricsThread metricsThread;
    private KeyMetricsPersistent metricsPersistent;
    private MetricsConfig metricsConfig;
    private int timeWindowType = 2;
    private long scanInterval = 5000L;
    private int timeWindows = 60;
    private int persistentDataHolderSize = 5000;
    private boolean stoped;
    private Object stopLock = new Object();

    public String getMetricsName() {
        return this.metricsName;
    }

    @Override
    public void setMetricsName(String metricsName) {
        this.metricsName = metricsName;
    }

    public Map<String, TimeMetric> getTimeKeyMetrics(String metricsKey) {
        Map<String, TimeMetric> metric = this.timeMetrics.get(metricsKey);
        if (metric != null) {
            return metric;
        }
        this.write.lock();
        try {
            metric = this.timeMetrics.get(metricsKey);
            if (metric == null) {
                metric = new LinkedHashMap<String, TimeMetric>();
                this.timeMetrics.put(metricsKey, metric);
            }
        }
        finally {
            this.write.unlock();
        }
        return metric;
    }

    private boolean needPersistent(Date slot, TimeMetric metric) {
        return metric.getSlotTime().before(slot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<KeyMetric> scanPersistentMetrics() {
        if (logger.isDebugEnabled()) {
            logger.debug("Scan persistent time metrics begin.....");
        }
        long start = System.currentTimeMillis();
        Date slot = TimeUtil.addDateSeconds((Date)new Date(), (int)this.metricsConfig.getTimeWindows());
        ArrayList<KeyMetric> persistentData = new ArrayList<KeyMetric>();
        this.read.lock();
        try {
            this.timeMetrics.entrySet().forEach(entry -> {
                Map metricMap;
                String metricsKey = (String)entry.getKey();
                Map map = metricMap = (Map)entry.getValue();
                synchronized (map) {
                    Map.Entry minutesMetric;
                    TimeMetric metric;
                    ArrayList<String> metricKeys = new ArrayList<String>();
                    Iterator iterator = metricMap.entrySet().iterator();
                    while (iterator.hasNext() && this.needPersistent(slot, metric = (TimeMetric)(minutesMetric = iterator.next()).getValue())) {
                        metricKeys.add((String)minutesMetric.getKey());
                        persistentData.add(metric);
                    }
                    if (metricKeys.size() > 0) {
                        for (String key : metricKeys) {
                            metricMap.remove(key);
                        }
                    }
                }
            });
        }
        finally {
            this.read.unlock();
        }
        if (logger.isDebugEnabled()) {
            long end = System.currentTimeMillis();
            if (persistentData != null) {
                logger.debug("Scan persistent time metrics complete,persistent metrics:{},take times:{} ms", (Object)persistentData.size(), (Object)(end - start));
            } else {
                logger.debug("Scan persistent time metrics complete,persistent metrics:0,take times:{} ms", (Object)(end - start));
            }
        }
        return persistentData;
    }

    public DateFormat getMetricsTimeKeyFormat(MapData data) {
        return MetricUtil.getMetricsTimeKeyFormat(this.timeWindowType, data);
    }

    @Override
    public TimeMetric metric(String metricsKey, MapData data, KeyMetricBuilder metricBuilder) {
        return this.metric(new MetricKey(metricsKey), data, metricBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TimeMetric metric(MetricKey metricsKey, MapData data, KeyMetricBuilder metricBuilder) {
        DateFormat dateFormat;
        if (!metricBuilder.validateData(data)) {
            if (logger.isDebugEnabled()) {
                logger.debug("data validate failed:{}", (Object)SimpleStringUtil.object2json(data.getData()));
            }
            return null;
        }
        Map<String, TimeMetric> metrics = this.getTimeKeyMetrics(metricsKey.getMetricKey());
        Date time = data.metricsDataTime(metricsKey);
        DateFormat metricTimeDateFormat = dateFormat = this.getMetricsTimeKeyFormat(data);
        String metricsTime = dateFormat.format(time);
        TimeMetric metric = null;
        Map<String, TimeMetric> map = metrics;
        synchronized (map) {
            metric = metrics.get(metricsTime);
            if (metric == null) {
                metric = (TimeMetric)metricBuilder.build();
                metric.setMetricsLogAPI(this.getMetricsLogAPI());
                MetricUtil.buildMetricTimeField(metric, data, time);
                metric.setMetric(metricsKey.getMetricKey());
                metric.setSlotTime(new Date());
                metric.setMetricTimeKey(metricsTime);
                try {
                    metric.setDataTime(metricTimeDateFormat.parse(metricsTime));
                }
                catch (Exception e) {
                    logger.error("\u8bbe\u7f6e\u6307\u6807\u65f6\u95f4\u5f02\u5e38", (Throwable)e);
                }
                metric.init(data);
                metrics.put(metricsTime, metric);
            }
            metric.increment(data);
        }
        return metric;
    }

    public int getTimeWindowType() {
        return this.timeWindowType;
    }

    public void setTimeWindowType(int timeWindowType) {
        this.timeWindowType = timeWindowType;
    }

    public void setTimeWindows(int timeWindows) {
        this.timeWindows = timeWindows;
    }

    public void setScanInterval(long scanInterval) {
        this.scanInterval = scanInterval;
    }

    public void setPersistentDataHolderSize(int persistentDataHolderSize) {
        this.persistentDataHolderSize = persistentDataHolderSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceFlush(boolean cleanMetricsKey, boolean waitComplete) {
        PersistentDataHolder persistentDataHolder = new PersistentDataHolder();
        persistentDataHolder.init();
        ArrayList<Future> futures = new ArrayList<Future>();
        long s = System.currentTimeMillis();
        if (!cleanMetricsKey) {
            this.read.lock();
            try {
                this.timeMetrics.entrySet().forEach(entry -> {
                    Map metricMap;
                    Map map = metricMap = (Map)entry.getValue();
                    synchronized (map) {
                        for (Map.Entry minutesMetric : metricMap.entrySet()) {
                            TimeMetric metric = (TimeMetric)minutesMetric.getValue();
                            persistentDataHolder.addKeyMetric(metric);
                            if (persistentDataHolder.size() < this.persistentDataHolderSize) continue;
                            Future future = this.metricsPersistent.persistent(persistentDataHolder.getPersistentData());
                            if (waitComplete) {
                                futures.add(future);
                            }
                            persistentDataHolder.init();
                        }
                        metricMap.clear();
                    }
                });
            }
            finally {
                this.read.unlock();
            }
        }
        this.write.lock();
        try {
            this.timeMetrics.entrySet().forEach(entry -> {
                Map metricMap;
                Map map = metricMap = (Map)entry.getValue();
                synchronized (map) {
                    for (Map.Entry minutesMetric : metricMap.entrySet()) {
                        TimeMetric metric = (TimeMetric)minutesMetric.getValue();
                        persistentDataHolder.addKeyMetric(metric);
                        if (persistentDataHolder.size() < this.persistentDataHolderSize) continue;
                        Future future = this.metricsPersistent.persistent(persistentDataHolder.getPersistentData());
                        if (waitComplete) {
                            futures.add(future);
                        }
                        persistentDataHolder.init();
                    }
                    metricMap.clear();
                }
            });
            this.timeMetrics.clear();
        }
        finally {
            this.write.unlock();
        }
        if (persistentDataHolder.size() > 0) {
            Future future = this.metricsPersistent.persistent(persistentDataHolder.getPersistentData());
            if (waitComplete) {
                futures.add(future);
            }
        }
        if (waitComplete && futures.size() > 0) {
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException e) {
                    logger.error("", (Throwable)e);
                }
            }
        }
        logger.info("Force Flush timemetrics complete elapse:{} ms.", (Object)(System.currentTimeMillis() - s));
    }

    @Override
    public void init() {
        MetricsConfig metricsConfig = new MetricsConfig();
        metricsConfig.setScanInterval(this.scanInterval);
        if (this.timeWindows > 0) {
            metricsConfig.setTimeWindows(0 - this.timeWindows);
        } else if (this.timeWindows < 0) {
            metricsConfig.setTimeWindows(this.timeWindows);
        } else {
            metricsConfig.setTimeWindows(-300);
        }
        this.metricsConfig = metricsConfig;
        KeyMetricsPersistent metricsPersistent = new KeyMetricsPersistent();
        metricsPersistent.setPersistent(this);
        metricsPersistent.init();
        this.metricsPersistent = metricsPersistent;
        ScanTask scanTask = new ScanTask();
        scanTask.setMetricsConfig(metricsConfig);
        scanTask.setMetricsPersistent(metricsPersistent);
        scanTask.setMetrics(this);
        this.metricsThread = new MetricsThread(scanTask, "ScanTask-" + this.metricsName);
        this.metricsThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopMetrics() {
        if (this.stoped) {
            return;
        }
        Object object = this.stopLock;
        synchronized (object) {
            if (this.stoped) {
                return;
            }
            this.stoped = true;
        }
        if (this.metricsThread != null) {
            this.metricsThread.stopScan();
            this.forceFlush(true, true);
        }
        if (this.metricsPersistent != null) {
            this.metricsPersistent.stop();
        }
    }
}

