/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.bulk;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.frameworkset.elasticsearch.bulk.BulkCommand;
import org.frameworkset.elasticsearch.bulk.BulkConfig;
import org.frameworkset.elasticsearch.bulk.BulkData;
import org.frameworkset.elasticsearch.bulk.BulkInterceptor;
import org.frameworkset.elasticsearch.bulk.BulkProcessor;
import org.frameworkset.elasticsearch.bulk.BulkRetryHandler;
import org.frameworkset.elasticsearch.client.ClientInterface;
import org.frameworkset.elasticsearch.client.ResultUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseBulkCommand
implements BulkCommand {
    private static Logger logger = LoggerFactory.getLogger(BaseBulkCommand.class);
    protected BulkProcessor bulkProcessor;
    protected ClientInterface clientInterface;
    protected Date bulkCommandStartTime;
    protected Date bulkCommandCompleteTime;
    protected List<BulkData> batchBulkDatas;

    @Override
    public Date getBulkCommandStartTime() {
        return this.bulkCommandStartTime;
    }

    @Override
    public List<BulkData> getBatchBulkDatas() {
        return this.batchBulkDatas;
    }

    @Override
    public void setBulkCommandStartTime(Date bulkCommandStartTime) {
        this.bulkCommandStartTime = bulkCommandStartTime;
    }

    @Override
    public Date getBulkCommandCompleteTime() {
        return this.bulkCommandCompleteTime;
    }

    @Override
    public long getElapsed() {
        if (this.bulkCommandCompleteTime != null && this.bulkCommandStartTime != null) {
            return this.bulkCommandCompleteTime.getTime() - this.bulkCommandStartTime.getTime();
        }
        return 0L;
    }

    @Override
    public void setBulkCommandCompleteTime(Date bulkCommandCompleteTime) {
        this.bulkCommandCompleteTime = bulkCommandCompleteTime;
    }

    public BaseBulkCommand(BulkProcessor bulkProcessor) {
        this.bulkProcessor = bulkProcessor;
        this.clientInterface = bulkProcessor.getClientInterface();
        this.batchBulkDatas = new ArrayList<BulkData>(bulkProcessor.getBulkSizes());
    }

    @Override
    public String getRefreshOption() {
        return this.bulkProcessor.getRefreshOption();
    }

    @Override
    public String getFilterPath() {
        return this.bulkProcessor.getBulkConfig().getFilterPath();
    }

    private void directRun(List<BulkInterceptor> bulkInterceptors) {
        String result = this.clientInterface.executeBulk(this);
        this.bulkProcessor.increamentTotalsize(this.getBulkDataRecords());
        boolean hasError = ResultUtil.bulkResponseError(result);
        if (!hasError) {
            for (int i = 0; bulkInterceptors != null && i < bulkInterceptors.size(); ++i) {
                BulkInterceptor bulkInterceptor = bulkInterceptors.get(i);
                try {
                    bulkInterceptor.afterBulk(this, result);
                    continue;
                }
                catch (Exception e) {
                    if (!logger.isErrorEnabled()) continue;
                    logger.error("bulkInterceptor.afterBulk", (Throwable)e);
                }
            }
        } else {
            for (int i = 0; bulkInterceptors != null && i < bulkInterceptors.size(); ++i) {
                BulkInterceptor bulkInterceptor = bulkInterceptors.get(i);
                try {
                    bulkInterceptor.errorBulk(this, result);
                    continue;
                }
                catch (Exception e) {
                    if (!logger.isErrorEnabled()) continue;
                    logger.error("bulkInterceptor.errorBulk", (Throwable)e);
                }
            }
        }
        result = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        BulkConfig bulkConfig = this.bulkProcessor.getBulkConfig();
        List<BulkInterceptor> bulkInterceptors = bulkConfig.getBulkInterceptors();
        for (int i = 0; bulkInterceptors != null && i < bulkInterceptors.size(); ++i) {
            BulkInterceptor bulkInterceptor = bulkInterceptors.get(i);
            try {
                bulkInterceptor.beforeBulk(this);
                continue;
            }
            catch (Exception e) {
                if (!logger.isErrorEnabled()) continue;
                logger.error("bulkInterceptor.beforeBulk", (Throwable)e);
            }
        }
        BulkRetryHandler bulkRetryHandler = bulkConfig.getBulkRetryHandler();
        int retryTimes = bulkConfig.getRetryTimes();
        if (bulkRetryHandler == null || retryTimes <= 0) {
            try {
                this.setBulkCommandStartTime(new Date());
                this.directRun(bulkInterceptors);
                this.setBulkCommandCompleteTime(new Date());
            }
            catch (Throwable throwable) {
                this.setBulkCommandCompleteTime(new Date());
                this.bulkProcessor.increamentFailedSize(this.getBulkDataRecords());
                for (int i = 0; bulkInterceptors != null && i < bulkInterceptors.size(); ++i) {
                    BulkInterceptor bulkInterceptor = bulkInterceptors.get(i);
                    try {
                        bulkInterceptor.exceptionBulk(this, throwable);
                        continue;
                    }
                    catch (Exception e) {
                        logger.error("bulkInterceptor.errorBulk", (Throwable)e);
                    }
                }
            }
            finally {
                this.clear();
            }
        } else {
            try {
                this.setBulkCommandStartTime(new Date());
                Exception exception = null;
                int count = 0;
                long retryInterval = bulkConfig.getRetryInterval();
                while (true) {
                    if (count > 0 && logger.isInfoEnabled()) {
                        logger.info("Retry bulkprocess {} times.", (Object)count);
                    }
                    try {
                        this.directRun(bulkInterceptors);
                        exception = null;
                    }
                    catch (Exception e) {
                        exception = e;
                        if (!bulkRetryHandler.neadRetry(e, this) || count == retryTimes) break;
                        if (logger.isErrorEnabled()) {
                            logger.error("Exception occur and  Retry process will be take.", (Throwable)e);
                        }
                        ++count;
                        if (retryInterval <= 0L) continue;
                        try {
                            Thread.sleep(retryInterval);
                        }
                        catch (Exception interupt) {
                            break;
                        }
                    }
                }
                this.setBulkCommandCompleteTime(new Date());
                if (exception != null) {
                    throw exception;
                }
            }
            catch (Throwable throwable) {
                this.setBulkCommandCompleteTime(new Date());
                this.bulkProcessor.increamentFailedSize(this.getBulkDataRecords());
                for (int i = 0; bulkInterceptors != null && i < bulkInterceptors.size(); ++i) {
                    BulkInterceptor bulkInterceptor = bulkInterceptors.get(i);
                    try {
                        bulkInterceptor.exceptionBulk(this, throwable);
                        continue;
                    }
                    catch (Exception e) {
                        logger.error("bulkInterceptor.errorBulk", (Throwable)e);
                    }
                }
            }
            finally {
                this.clear();
            }
        }
    }

    @Override
    public void addBulkData(BulkData bulkData) {
        this.batchBulkDatas.add(bulkData);
    }

    protected abstract void clear();

    protected void clearDatas() {
        if (this.batchBulkDatas != null) {
            this.batchBulkDatas.clear();
            this.batchBulkDatas = null;
        }
    }

    @Override
    public long getTotalSize() {
        return this.bulkProcessor.getTotalSize();
    }

    @Override
    public long getAppendRecords() {
        return this.bulkProcessor.getAppendRecords();
    }

    @Override
    public long getTotalFailedSize() {
        return this.bulkProcessor.getFailedSize();
    }

    @Override
    public BulkProcessor getBulkProcessor() {
        return this.bulkProcessor;
    }
}

