/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.bulk;

import java.io.IOException;
import java.io.Writer;
import org.frameworkset.elasticsearch.ElasticSearchException;
import org.frameworkset.elasticsearch.bulk.BaseBulkCommand;
import org.frameworkset.elasticsearch.bulk.BulkConfig;
import org.frameworkset.elasticsearch.bulk.BulkData;
import org.frameworkset.elasticsearch.bulk.BulkProcessor;
import org.frameworkset.elasticsearch.client.BuildTool;
import org.frameworkset.soa.BBossStringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkCommandImpl
extends BaseBulkCommand {
    private static Logger logger = LoggerFactory.getLogger(BulkCommandImpl.class);

    public BulkCommandImpl(BulkProcessor bulkProcessor) {
        super(bulkProcessor);
    }

    @Override
    protected void clear() {
        super.clearDatas();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDataString() {
        if (this.batchBulkDatas == null || this.batchBulkDatas.size() == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        BBossStringWriter writer = null;
        try {
            writer = new BBossStringWriter(builder);
            for (BulkData bulkData : this.batchBulkDatas) {
                try {
                    BuildTool.evalBuilk((Writer)writer, bulkData, this.clientInterface.isUpper7());
                }
                catch (IOException e) {
                    throw new ElasticSearchException(e);
                }
            }
            writer.flush();
            String string = builder.toString();
            return string;
        }
        finally {
            builder.setLength(0);
            builder = null;
            writer = null;
        }
    }

    @Override
    public int getBulkDataRecords() {
        if (this.batchBulkDatas != null) {
            return this.batchBulkDatas.size();
        }
        return 0;
    }

    @Override
    public boolean touchBatchSize(BulkConfig bulkConfig) {
        return this.getBulkDataRecords() >= bulkConfig.getBulkSizes();
    }
}

