/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.elasticsearch.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.frameworkset.elasticsearch.client.ESAddress;
import org.frameworkset.spi.remote.http.HttpRequestUtil;
import org.frameworkset.spi.remote.http.ResponseUtil;
import org.frameworkset.util.shutdown.ShutdownUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthCheck
implements Runnable {
    private final List<ESAddress> esAddresses;
    private static final Logger logger = LoggerFactory.getLogger(HealthCheck.class);
    private long checkInterval = 5000L;
    private List<HCRunable> checkThreads;
    private final String elasticsearch;
    private final String healthHttpPool;

    public HealthCheck(String elasticsearch, String healthHttpPool, List<ESAddress> esAddresses, long checkInterval) {
        this.esAddresses = esAddresses;
        this.checkInterval = checkInterval;
        this.healthHttpPool = healthHttpPool;
        this.elasticsearch = elasticsearch;
    }

    public void stopCheck() {
        HCRunable t = null;
        for (int i = 0; i < this.checkThreads.size(); ++i) {
            t = this.checkThreads.get(i);
            t.stopRun();
        }
    }

    public void checkNewAddresses(List<ESAddress> addresses) {
        HCRunable t = null;
        for (int i = 0; i < addresses.size(); ++i) {
            ESAddress address = addresses.get(i);
            t = new HCRunable(address);
            t.start();
            this.checkThreads.add(t);
        }
    }

    @Override
    public void run() {
        Iterator<ESAddress> iterable = this.esAddresses.iterator();
        this.checkThreads = new ArrayList<HCRunable>();
        HCRunable t = null;
        ESAddress address = null;
        while (iterable.hasNext()) {
            address = iterable.next();
            t = new HCRunable(address);
            t.start();
            this.checkThreads.add(t);
        }
        ShutdownUtil.addShutdownHook((Runnable)new Runnable(){

            @Override
            public void run() {
                HealthCheck.this.stopCheck();
            }
        });
    }

    public void addNewAddress(List<ESAddress> addresses) {
        Iterator<ESAddress> iterable = addresses.iterator();
        HCRunable t = null;
        ESAddress address = null;
        while (iterable.hasNext()) {
            address = iterable.next();
            t = new HCRunable(address);
            t.start();
            this.checkThreads.add(t);
        }
    }

    class HCRunable
    extends Thread {
        ESAddress address;
        boolean stop;
        private Object stopLock;

        public HCRunable(ESAddress address) {
            super("Elasticsearch[" + HealthCheck.this.elasticsearch + "]-Server[" + address.toString() + "]-HealthCheck");
            this.stop = false;
            this.stopLock = new Object();
            address.setHealthCheck(this);
            this.address = address;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopRun() {
            if (this.stop) {
                return;
            }
            Object object = this.stopLock;
            synchronized (object) {
                if (this.stop) {
                    return;
                }
                this.stop = true;
            }
            this.interrupt();
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.stop) {
                HCRunable e4;
                if (this.address.failedCheck()) {
                    try {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Check downed elasticsearch [" + HealthCheck.this.elasticsearch + "] server[" + this.address.toString() + "] status.");
                        }
                        HttpRequestUtil.httpGet((String)HealthCheck.this.healthHttpPool, (String)this.address.getHealthPath(), null, (ResponseHandler)new ResponseHandler<Void>(){

                            public Void handleResponse(HttpResponse response) throws IOException {
                                int status = response.getStatusLine().getStatusCode();
                                if (ResponseUtil.isHttpStatusOK((int)status)) {
                                    if (logger.isInfoEnabled()) {
                                        logger.info("Downed elasticsearch[" + HealthCheck.this.elasticsearch + "] server[" + HCRunable.this.address.toString() + "] recovered to normal server.");
                                    }
                                    HCRunable.this.address.onlySetStatus(0);
                                } else {
                                    HCRunable.this.address.onlySetStatus(1);
                                }
                                return null;
                            }
                        });
                    }
                    catch (Exception e2) {
                        if (logger.isDebugEnabled()) {
                            logger.warn("Down elasticsearch[" + HealthCheck.this.elasticsearch + "] node health check use [" + this.address.getHealthPath() + "] failed:" + " Elasticsearch server[" + this.address.toString() + "] is down.");
                        }
                        this.address.onlySetStatus(1);
                    }
                    if (this.stop) break;
                    if (this.address.failedCheck()) {
                        try {
                            HCRunable.sleep(HealthCheck.this.checkInterval);
                            continue;
                        }
                        catch (InterruptedException e3) {
                            break;
                        }
                    }
                    try {
                        e4 = this;
                        synchronized (e4) {
                            this.wait();
                            continue;
                        }
                    }
                    catch (InterruptedException e4) {
                        break;
                    }
                }
                try {
                    e4 = this;
                    synchronized (e4) {
                        this.wait();
                    }
                }
                catch (InterruptedException e5) {
                    break;
                }
            }
        }
    }
}

