/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.AssertingRandom;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.SeedDecorator;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.SeedUtils;
import java.util.Random;

public final class Randomness {
    private final long seed;
    private final AssertingRandom random;
    private SeedDecorator[] decorators;

    public Randomness(Thread thread, long l, SeedDecorator ... seedDecoratorArray) {
        this.seed = l;
        this.decorators = seedDecoratorArray;
        this.random = new AssertingRandom(thread, new Random(Randomness.decorate(l, seedDecoratorArray)));
    }

    public Randomness(long l, SeedDecorator ... seedDecoratorArray) {
        this(Thread.currentThread(), l, seedDecoratorArray);
    }

    Randomness clone(Thread thread) {
        return new Randomness(thread, this.seed, this.decorators);
    }

    public String toString() {
        return "[Randomness, seed=" + SeedUtils.formatSeedChain(this) + "]";
    }

    void destroy() {
        this.random.destroy();
    }

    long getSeed() {
        return this.seed;
    }

    private static long decorate(long l, SeedDecorator[] seedDecoratorArray) {
        for (SeedDecorator seedDecorator : seedDecoratorArray) {
            l = seedDecorator.decorate(l);
        }
        return l;
    }
}

