/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc.internal;

import com.clickhouse.client.api.data_formats.internal.BinaryStreamReader;
import com.clickhouse.data.ClickHouseDataType;
import com.clickhouse.jdbc.types.Array;
import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JdbcUtils {
    public static final Map<ClickHouseDataType, SQLType> CLICKHOUSE_TO_SQL_TYPE_MAP = JdbcUtils.generateTypeMap();
    public static final Map<String, SQLType> CLICKHOUSE_TYPE_NAME_TO_SQL_TYPE_MAP = Collections.unmodifiableMap(JdbcUtils.generateTypeMap().entrySet().stream().collect(HashMap::new, (map, entry) -> map.put(((ClickHouseDataType)((Object)((Object)entry.getKey()))).name(), (SQLType)entry.getValue()), HashMap::putAll));
    public static final Map<SQLType, Class<?>> SQL_TYPE_TO_CLASS_MAP = JdbcUtils.generateClassMap();
    public static final Map<ClickHouseDataType, Class<?>> DATA_TYPE_CLASS_MAP = JdbcUtils.getDataTypeClassMap();
    public static final String NULL = "NULL";
    private static final Pattern REPLACE_Q_MARK_PATTERN = Pattern.compile("(\"[^\"]*\"|`[^`]*`|'[^']*')|(\\?)");

    private static Map<ClickHouseDataType, SQLType> generateTypeMap() {
        TreeMap<ClickHouseDataType, JDBCType> map = new TreeMap<ClickHouseDataType, JDBCType>();
        map.put(ClickHouseDataType.Int8, JDBCType.TINYINT);
        map.put(ClickHouseDataType.Int16, JDBCType.SMALLINT);
        map.put(ClickHouseDataType.Int32, JDBCType.INTEGER);
        map.put(ClickHouseDataType.Int64, JDBCType.BIGINT);
        map.put(ClickHouseDataType.Float32, JDBCType.FLOAT);
        map.put(ClickHouseDataType.Float64, JDBCType.DOUBLE);
        map.put(ClickHouseDataType.Bool, JDBCType.BOOLEAN);
        map.put(ClickHouseDataType.Decimal, JDBCType.DECIMAL);
        map.put(ClickHouseDataType.Decimal32, JDBCType.DECIMAL);
        map.put(ClickHouseDataType.Decimal64, JDBCType.DECIMAL);
        map.put(ClickHouseDataType.Decimal128, JDBCType.DECIMAL);
        map.put(ClickHouseDataType.String, JDBCType.VARCHAR);
        map.put(ClickHouseDataType.FixedString, JDBCType.VARCHAR);
        map.put(ClickHouseDataType.Enum, JDBCType.VARCHAR);
        map.put(ClickHouseDataType.Enum8, JDBCType.VARCHAR);
        map.put(ClickHouseDataType.Enum16, JDBCType.VARCHAR);
        map.put(ClickHouseDataType.Date, JDBCType.DATE);
        map.put(ClickHouseDataType.Date32, JDBCType.DATE);
        map.put(ClickHouseDataType.DateTime, JDBCType.TIMESTAMP);
        map.put(ClickHouseDataType.DateTime32, JDBCType.TIMESTAMP);
        map.put(ClickHouseDataType.DateTime64, JDBCType.TIMESTAMP);
        map.put(ClickHouseDataType.Array, JDBCType.ARRAY);
        map.put(ClickHouseDataType.Nested, JDBCType.ARRAY);
        map.put(ClickHouseDataType.Map, JDBCType.JAVA_OBJECT);
        map.put(ClickHouseDataType.Point, JDBCType.OTHER);
        map.put(ClickHouseDataType.Ring, JDBCType.OTHER);
        map.put(ClickHouseDataType.Polygon, JDBCType.OTHER);
        map.put(ClickHouseDataType.LineString, JDBCType.OTHER);
        map.put(ClickHouseDataType.MultiPolygon, JDBCType.OTHER);
        map.put(ClickHouseDataType.MultiLineString, JDBCType.OTHER);
        return ImmutableMap.copyOf(map);
    }

    private static Map<SQLType, Class<?>> generateClassMap() {
        HashMap<JDBCType, Class<SQLXML>> map = new HashMap<JDBCType, Class<SQLXML>>();
        map.put(JDBCType.CHAR, String.class);
        map.put(JDBCType.VARCHAR, String.class);
        map.put(JDBCType.LONGVARCHAR, String.class);
        map.put(JDBCType.NUMERIC, BigDecimal.class);
        map.put(JDBCType.DECIMAL, BigDecimal.class);
        map.put(JDBCType.BIT, Boolean.class);
        map.put(JDBCType.BOOLEAN, Boolean.class);
        map.put(JDBCType.TINYINT, Integer.class);
        map.put(JDBCType.SMALLINT, Integer.class);
        map.put(JDBCType.INTEGER, Integer.class);
        map.put(JDBCType.BIGINT, Long.class);
        map.put(JDBCType.REAL, Float.class);
        map.put(JDBCType.FLOAT, Double.class);
        map.put(JDBCType.DOUBLE, Double.class);
        map.put(JDBCType.BINARY, byte[].class);
        map.put(JDBCType.VARBINARY, byte[].class);
        map.put(JDBCType.LONGVARBINARY, byte[].class);
        map.put(JDBCType.DATE, Date.class);
        map.put(JDBCType.TIME, Time.class);
        map.put(JDBCType.TIMESTAMP, Timestamp.class);
        map.put(JDBCType.TIME_WITH_TIMEZONE, Time.class);
        map.put(JDBCType.TIMESTAMP_WITH_TIMEZONE, Timestamp.class);
        map.put(JDBCType.CLOB, Clob.class);
        map.put(JDBCType.BLOB, Blob.class);
        map.put(JDBCType.ARRAY, java.sql.Array.class);
        map.put(JDBCType.STRUCT, Struct.class);
        map.put(JDBCType.REF, Ref.class);
        map.put(JDBCType.DATALINK, URL.class);
        map.put(JDBCType.ROWID, RowId.class);
        map.put(JDBCType.NCHAR, String.class);
        map.put(JDBCType.NVARCHAR, String.class);
        map.put(JDBCType.LONGNVARCHAR, String.class);
        map.put(JDBCType.NCLOB, NClob.class);
        map.put(JDBCType.SQLXML, SQLXML.class);
        return ImmutableMap.copyOf(map);
    }

    private static Map<ClickHouseDataType, Class<?>> getDataTypeClassMap() {
        HashMap map = new HashMap();
        for (Map.Entry<ClickHouseDataType, SQLType> e : CLICKHOUSE_TO_SQL_TYPE_MAP.entrySet()) {
            map.put(e.getKey(), SQL_TYPE_TO_CLASS_MAP.get(e.getValue()));
        }
        return map;
    }

    public static SQLType convertToSqlType(ClickHouseDataType clickhouseType) {
        if (clickhouseType == null) {
            return JDBCType.NULL;
        }
        return CLICKHOUSE_TO_SQL_TYPE_MAP.getOrDefault((Object)clickhouseType, JDBCType.OTHER);
    }

    public static Class<?> convertToJavaClass(ClickHouseDataType clickhouseType) {
        return DATA_TYPE_CLASS_MAP.get((Object)clickhouseType);
    }

    public static List<String> tokenizeSQL(String sql) {
        ArrayList<String> tokens = new ArrayList<String>();
        String withoutComments = sql.replaceAll("--.*?$", "").replaceAll("/\\*.*?\\*/", "");
        StringBuilder currentToken = new StringBuilder();
        boolean insideQuotes = false;
        for (int i = 0; i < withoutComments.length(); ++i) {
            char c = withoutComments.charAt(i);
            if (c == '\"') {
                insideQuotes = !insideQuotes;
                currentToken.append(c);
                continue;
            }
            if (Character.isWhitespace(c) && !insideQuotes) {
                if (currentToken.length() <= 0) continue;
                tokens.add(currentToken.toString());
                currentToken.setLength(0);
                continue;
            }
            currentToken.append(c);
        }
        if (currentToken.length() > 0) {
            tokens.add(currentToken.toString());
        }
        return tokens;
    }

    public static boolean isBlank(String str) {
        return str == null || str.isEmpty() || str.trim().isEmpty();
    }

    public static boolean containsIgnoresCase(List<String> list, String str) {
        if (list == null || list.isEmpty() || JdbcUtils.isBlank(str)) {
            return false;
        }
        for (String s : list) {
            if (!s.equalsIgnoreCase(str)) continue;
            return true;
        }
        return false;
    }

    public static int indexOfIgnoresCase(List<String> list, String str) {
        if (list == null || list.isEmpty() || JdbcUtils.isBlank(str)) {
            return -1;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).equalsIgnoreCase(str)) continue;
            return i;
        }
        return -1;
    }

    public static String generateSqlTypeSizes(String columnName) {
        StringBuilder sql = new StringBuilder("multiIf(");
        sql.append("character_octet_length IS NOT NULL, character_octet_length, ");
        for (ClickHouseDataType type : ClickHouseDataType.values()) {
            if (type.getByteLength() <= 0) continue;
            sql.append(columnName).append(" == '").append(type.name()).append("', ").append(type.getByteLength()).append(", ");
        }
        sql.append("numeric_precision IS NOT NULL, numeric_precision, ");
        sql.append("0)");
        return sql.toString();
    }

    public static Object convert(Object value, Class<?> type) throws SQLException {
        if (value == null || type == null) {
            return value;
        }
        try {
            if (type.isInstance(value)) {
                return value;
            }
            if (type == String.class) {
                return value.toString();
            }
            if (type == Boolean.class || type == Boolean.TYPE) {
                return Boolean.parseBoolean(value.toString());
            }
            if (type == Byte.class || type == Byte.TYPE) {
                return Byte.parseByte(value.toString());
            }
            if (type == Short.class || type == Short.TYPE) {
                return Short.parseShort(value.toString());
            }
            if (type == Integer.class || type == Integer.TYPE) {
                return Integer.parseInt(value.toString());
            }
            if (type == Long.class || type == Long.TYPE) {
                return Long.parseLong(value.toString());
            }
            if (type == Float.class || type == Float.TYPE) {
                return Float.valueOf(Float.parseFloat(value.toString()));
            }
            if (type == Double.class || type == Double.TYPE) {
                return Double.parseDouble(value.toString());
            }
            if (type == BigDecimal.class) {
                return new BigDecimal(value.toString());
            }
            if (type == byte[].class) {
                return value.toString().getBytes();
            }
            if (type == LocalDate.class && value instanceof TemporalAccessor) {
                return LocalDate.from((TemporalAccessor)value);
            }
            if (type == LocalDateTime.class && value instanceof TemporalAccessor) {
                return LocalDateTime.from((TemporalAccessor)value);
            }
            if (type == OffsetDateTime.class && value instanceof TemporalAccessor) {
                return OffsetDateTime.from((TemporalAccessor)value);
            }
            if (type == ZonedDateTime.class && value instanceof TemporalAccessor) {
                return ZonedDateTime.from((TemporalAccessor)value);
            }
            if (type == Date.class && value instanceof TemporalAccessor) {
                return Date.valueOf(LocalDate.from((TemporalAccessor)value));
            }
            if (type == Timestamp.class && value instanceof TemporalAccessor) {
                return Timestamp.valueOf(LocalDateTime.from((TemporalAccessor)value));
            }
            if (type == Time.class && value instanceof TemporalAccessor) {
                return Time.valueOf(LocalTime.from((TemporalAccessor)value));
            }
            if (type == java.sql.Array.class && value instanceof BinaryStreamReader.ArrayValue) {
                return new Array(((BinaryStreamReader.ArrayValue)value).asList(), "Object", JDBCType.JAVA_OBJECT.getVendorTypeNumber());
            }
            if (type == Inet4Address.class && value instanceof Inet6Address) {
                return Inet4Address.getByName(value.toString());
            }
            if (type == Inet6Address.class && value instanceof Inet4Address) {
                return Inet6Address.getByName(value.toString());
            }
        }
        catch (Exception e) {
            throw new SQLException("Failed to convert " + value + " to " + type.getName(), "22000");
        }
        throw new SQLException("Unsupported conversion from " + value.getClass().getName() + " to " + type.getName(), "22000");
    }

    public static String escapeQuotes(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return str.replace("'", "\\'").replace("\"", "\\\"");
    }

    public static String replaceQuestionMarks(String sql, String replacement) {
        Matcher matcher = REPLACE_Q_MARK_PATTERN.matcher(sql);
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            if (matcher.group(1) != null) {
                matcher.appendReplacement(result, Matcher.quoteReplacement(matcher.group(1)));
                continue;
            }
            if (matcher.group(2) == null) continue;
            matcher.appendReplacement(result, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(result);
        return result.toString();
    }
}

