/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.error.analysis.network;

import com.contentsquare.android.error.analysis.ErrorAnalysis;
import com.contentsquare.android.error.analysis.network.ErrorAnalysisOkHttpClientKt;
import com.contentsquare.android.internal.features.logging.Logger;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0015\b\u0011\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/contentsquare/android/error/analysis/network/ErrorAnalysisInterceptor;", "Lokhttp3/Interceptor;", "()V", "errorAnalysis", "Lkotlin/Function0;", "Lcom/contentsquare/android/error/analysis/ErrorAnalysis;", "(Lkotlin/jvm/functions/Function0;)V", "logger", "Lcom/contentsquare/android/internal/features/logging/Logger;", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "error-analysis_release"})
public final class ErrorAnalysisInterceptor
implements Interceptor {
    private final Function0<ErrorAnalysis> errorAnalysis;
    private final Logger logger;

    public ErrorAnalysisInterceptor() {
        this.logger = new Logger("ErrorAnalysisInterceptor");
        this.errorAnalysis = new Function0<ErrorAnalysis>(ErrorAnalysis.Companion){

            public final Object invoke() {
                return ((ErrorAnalysis.Companion)this.receiver).getInstance();
            }
        };
    }

    public ErrorAnalysisInterceptor(Function0<ErrorAnalysis> function0) {
        Logger logger;
        Intrinsics.checkNotNullParameter(function0, (String)"errorAnalysis");
        ErrorAnalysisInterceptor errorAnalysisInterceptor = logger;
        logger = new Logger("ErrorAnalysisInterceptor");
        v1.logger = errorAnalysisInterceptor;
        v1.errorAnalysis = function0;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response intercept(Interceptor.Chain chain) {
        long l;
        long l2;
        Interceptor.Chain chain2 = chain;
        Intrinsics.checkNotNullParameter((Object)chain2, (String)"chain");
        Request request = chain2.request();
        long l3 = System.currentTimeMillis();
        this.logger.d("Sending request " + request.url());
        try {
            chain = chain2.proceed(request);
        }
        catch (IOException iOException) {
            this.logger.d("Exception received = " + iOException);
            throw iOException;
        }
        {
            l2 = System.currentTimeMillis();
            l = l2 - l3;
        }
        {
            if (chain.code() >= 400) {
                ErrorAnalysisInterceptor errorAnalysisInterceptor = this;
                Interceptor.Chain chain3 = chain;
                int n = chain3.code();
                errorAnalysisInterceptor.logger.d("API Error received " + chain.request().url() + "\nHttp code = " + n + "\nMessage = " + chain3.message());
                ErrorAnalysisOkHttpClientKt.sendNetworkMetric((ErrorAnalysis)errorAnalysisInterceptor.errorAnalysis.invoke(), (Response)chain, l3, l2);
            } else {
                this.logger.d("Successful response for " + chain.request().url() + "\nHttp code = " + chain.code());
            }
            this.logger.d("Full response received in " + l + " = " + (Response)chain);
            return chain;
        }
    }
}

