/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.error.analysis.network;

import com.contentsquare.android.error.analysis.network.NetworkEventBuilder;
import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\nH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\nH\u0016J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\nH\u0016J\b\u0010\u0016\u001a\u00020\fH\u0016J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/contentsquare/android/error/analysis/network/InstrHttpInputStream;", "Ljava/io/InputStream;", "inputStream", "builder", "Lcom/contentsquare/android/error/analysis/network/NetworkEventBuilder;", "(Ljava/io/InputStream;Lcom/contentsquare/android/error/analysis/network/NetworkEventBuilder;)V", "timeToResponseInitiated", "", "timeToResponseLastRead", "available", "", "close", "", "mark", "readlimit", "markSupported", "", "read", "buffer", "", "byteOffset", "byteCount", "reset", "skip", "error-analysis_release"})
public final class InstrHttpInputStream
extends InputStream {
    private final InputStream inputStream;
    private final NetworkEventBuilder builder;
    private long timeToResponseInitiated;
    private long timeToResponseLastRead;

    public InstrHttpInputStream(InputStream inputStream, NetworkEventBuilder networkEventBuilder) {
        InstrHttpInputStream instrHttpInputStream = this;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)networkEventBuilder, (String)"builder");
        this.inputStream = inputStream;
        this.builder = networkEventBuilder;
        instrHttpInputStream.timeToResponseInitiated = networkEventBuilder.getTimeToResponseInitiatedMillis();
        instrHttpInputStream.timeToResponseLastRead = -1L;
    }

    @Override
    public int available() {
        try {
            return this.inputStream.available();
        }
        catch (IOException iOException) {
            InstrHttpInputStream instrHttpInputStream = this;
            instrHttpInputStream.builder.setTimeToResponseCompletedMillis(System.currentTimeMillis());
            instrHttpInputStream.builder.build();
            throw iOException;
        }
    }

    @Override
    public void close() {
        block6: {
            long l = System.currentTimeMillis();
            if (this.timeToResponseLastRead == -1L) {
                this.timeToResponseLastRead = l;
            }
            try {
                InstrHttpInputStream instrHttpInputStream = this;
                instrHttpInputStream.inputStream.close();
                l = instrHttpInputStream.timeToResponseInitiated;
                if (l == -1L) break block6;
            }
            catch (IOException iOException) {
                InstrHttpInputStream instrHttpInputStream = this;
                instrHttpInputStream.builder.setTimeToResponseCompletedMillis(System.currentTimeMillis());
                instrHttpInputStream.builder.build();
                throw iOException;
            }
            this.builder.setTimeToResponseInitiatedMillis(l);
        }
        InstrHttpInputStream instrHttpInputStream = this;
        InstrHttpInputStream instrHttpInputStream2 = instrHttpInputStream;
        instrHttpInputStream.builder.setTimeToResponseCompletedMillis(this.timeToResponseLastRead);
        instrHttpInputStream2.builder.build();
    }

    @Override
    public void mark(int n) {
        this.inputStream.mark(n);
    }

    @Override
    public boolean markSupported() {
        return this.inputStream.markSupported();
    }

    @Override
    public int read() {
        int n;
        block10: {
            long l;
            block9: {
                InstrHttpInputStream instrHttpInputStream;
                try {
                    InstrHttpInputStream instrHttpInputStream2 = this;
                    instrHttpInputStream = instrHttpInputStream2;
                    n = instrHttpInputStream2.inputStream.read();
                }
                catch (IOException iOException) {
                    InstrHttpInputStream instrHttpInputStream3 = this;
                    instrHttpInputStream3.builder.setTimeToResponseCompletedMillis(System.currentTimeMillis());
                    instrHttpInputStream3.builder.build();
                    throw iOException;
                }
                l = System.currentTimeMillis();
                if (instrHttpInputStream.timeToResponseInitiated != -1L) break block9;
                this.timeToResponseInitiated = l;
            }
            if (n == -1) {
                if (this.timeToResponseLastRead != -1L) break block10;
                InstrHttpInputStream instrHttpInputStream = this;
                InstrHttpInputStream instrHttpInputStream4 = instrHttpInputStream;
                instrHttpInputStream.timeToResponseLastRead = l;
                instrHttpInputStream.builder.setTimeToResponseCompletedMillis(l);
                instrHttpInputStream4.builder.build();
            }
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        int n3;
        block10: {
            long l;
            block9: {
                InstrHttpInputStream instrHttpInputStream = this;
                Intrinsics.checkNotNullParameter((Object)byArray, (String)"buffer");
                try {
                    n3 = instrHttpInputStream.inputStream.read(byArray, n, n2);
                }
                catch (IOException iOException) {
                    InstrHttpInputStream instrHttpInputStream2 = this;
                    instrHttpInputStream2.builder.setTimeToResponseCompletedMillis(System.currentTimeMillis());
                    instrHttpInputStream2.builder.build();
                    throw iOException;
                }
                l = System.currentTimeMillis();
                if (instrHttpInputStream.timeToResponseInitiated != -1L) break block9;
                this.timeToResponseInitiated = l;
            }
            if (n3 == -1) {
                if (this.timeToResponseLastRead != -1L) break block10;
                InstrHttpInputStream instrHttpInputStream = this;
                InstrHttpInputStream instrHttpInputStream3 = instrHttpInputStream;
                instrHttpInputStream.timeToResponseLastRead = l;
                instrHttpInputStream.builder.setTimeToResponseCompletedMillis(l);
                instrHttpInputStream3.builder.build();
            }
        }
        return n3;
    }

    @Override
    public int read(byte[] byArray) {
        int n;
        block10: {
            long l;
            block9: {
                InstrHttpInputStream instrHttpInputStream = this;
                Intrinsics.checkNotNullParameter((Object)byArray, (String)"buffer");
                try {
                    n = instrHttpInputStream.inputStream.read(byArray);
                }
                catch (IOException iOException) {
                    InstrHttpInputStream instrHttpInputStream2 = this;
                    instrHttpInputStream2.builder.setTimeToResponseCompletedMillis(System.currentTimeMillis());
                    instrHttpInputStream2.builder.build();
                    throw iOException;
                }
                l = System.currentTimeMillis();
                if (instrHttpInputStream.timeToResponseInitiated != -1L) break block9;
                this.timeToResponseInitiated = l;
            }
            if (n == -1) {
                if (this.timeToResponseLastRead != -1L) break block10;
                InstrHttpInputStream instrHttpInputStream = this;
                InstrHttpInputStream instrHttpInputStream3 = instrHttpInputStream;
                instrHttpInputStream.timeToResponseLastRead = l;
                instrHttpInputStream.builder.setTimeToResponseCompletedMillis(l);
                instrHttpInputStream3.builder.build();
            }
        }
        return n;
    }

    @Override
    public void reset() {
        try {
            this.inputStream.reset();
            return;
        }
        catch (IOException iOException) {
            InstrHttpInputStream instrHttpInputStream = this;
            instrHttpInputStream.builder.setTimeToResponseCompletedMillis(System.currentTimeMillis());
            instrHttpInputStream.builder.build();
            throw iOException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long skip(long l) {
        try {
            InstrHttpInputStream instrHttpInputStream = this;
            l = instrHttpInputStream.inputStream.skip(l);
            long l2 = System.currentTimeMillis();
            if (instrHttpInputStream.timeToResponseInitiated == -1L) {
                this.timeToResponseInitiated = l2;
            }
            if (this.timeToResponseLastRead != -1L) return l;
            this.timeToResponseLastRead = l2;
            this.builder.setTimeToResponseCompletedMillis(l2);
            return l;
        }
        catch (IOException iOException) {
            InstrHttpInputStream instrHttpInputStream = this;
            instrHttpInputStream.builder.setTimeToResponseCompletedMillis(System.currentTimeMillis());
            instrHttpInputStream.builder.build();
            throw iOException;
        }
    }
}

