/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.error.analysis.network;

import com.contentsquare.android.error.analysis.network.NetworkEventBuilder;
import java.io.IOException;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/contentsquare/android/error/analysis/network/InstrHttpOutputStream;", "Ljava/io/OutputStream;", "outputStream", "builder", "Lcom/contentsquare/android/error/analysis/network/NetworkEventBuilder;", "(Ljava/io/OutputStream;Lcom/contentsquare/android/error/analysis/network/NetworkEventBuilder;)V", "bytesWritten", "", "close", "", "flush", "write", "bytes", "", "off", "", "len", "byt", "error-analysis_release"})
public final class InstrHttpOutputStream
extends OutputStream {
    private final OutputStream outputStream;
    private NetworkEventBuilder builder;
    private long bytesWritten;

    public InstrHttpOutputStream(OutputStream outputStream, NetworkEventBuilder networkEventBuilder) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Intrinsics.checkNotNullParameter((Object)networkEventBuilder, (String)"builder");
        this.outputStream = outputStream;
        this.builder = networkEventBuilder;
        this.bytesWritten = -1L;
    }

    @Override
    public void close() {
        InstrHttpOutputStream instrHttpOutputStream = this;
        instrHttpOutputStream.builder.setTimeToRequestCompletedMillis(System.currentTimeMillis());
        try {
            instrHttpOutputStream.outputStream.close();
            return;
        }
        catch (IOException iOException) {
            InstrHttpOutputStream instrHttpOutputStream2 = this;
            instrHttpOutputStream2.builder.setTimeToResponseCompletedMillis(System.currentTimeMillis());
            instrHttpOutputStream2.builder.build();
            throw iOException;
        }
    }

    @Override
    public void flush() {
        try {
            this.outputStream.flush();
            return;
        }
        catch (IOException iOException) {
            InstrHttpOutputStream instrHttpOutputStream = this;
            instrHttpOutputStream.builder.setTimeToResponseCompletedMillis(System.currentTimeMillis());
            instrHttpOutputStream.builder.build();
            throw iOException;
        }
    }

    @Override
    public void write(int n) {
        long l;
        try {
            InstrHttpOutputStream instrHttpOutputStream = this;
            InstrHttpOutputStream instrHttpOutputStream2 = instrHttpOutputStream;
            instrHttpOutputStream.outputStream.write(n);
            l = instrHttpOutputStream.bytesWritten;
        }
        catch (IOException iOException) {
            InstrHttpOutputStream instrHttpOutputStream = this;
            instrHttpOutputStream.builder.setTimeToResponseCompletedMillis(System.currentTimeMillis());
            instrHttpOutputStream.builder.build();
            throw iOException;
        }
        instrHttpOutputStream2.bytesWritten = l + 1L;
    }

    @Override
    public void write(byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"bytes");
        try {
            this.outputStream.write(byArray);
            this.bytesWritten += (long)byArray.length;
            return;
        }
        catch (IOException iOException) {
            InstrHttpOutputStream instrHttpOutputStream = this;
            instrHttpOutputStream.builder.setTimeToResponseCompletedMillis(System.currentTimeMillis());
            instrHttpOutputStream.builder.build();
            throw iOException;
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"bytes");
        try {
            this.outputStream.write(byArray, n, n2);
            this.bytesWritten += (long)n2;
            return;
        }
        catch (IOException iOException) {
            InstrHttpOutputStream instrHttpOutputStream = this;
            instrHttpOutputStream.builder.setTimeToResponseCompletedMillis(System.currentTimeMillis());
            instrHttpOutputStream.builder.build();
            throw iOException;
        }
    }
}

