/*
 * Decompiled with CFR 0.152.
 */
package com.contentsquare.android.error.analysis.crash;

import com.contentsquare.android.error.analysis.ErrorAnalysis;
import com.contentsquare.android.error.analysis.crash.ApplicationData;
import com.contentsquare.android.error.analysis.internal.crash.AndroidThreadReport;
import com.contentsquare.android.error.analysis.internal.crash.ErrorStackTrace;
import com.contentsquare.android.error.analysis.internal.crash.ExceptionData;
import com.contentsquare.android.error.analysis.internal.crash.Frame;
import com.contentsquare.android.error.analysis.internal.crash.ThreadData;
import com.contentsquare.android.internal.features.logging.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 *2\u00020\u0001:\u0001*B+\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004\u00a2\u0006\u0002\u0010\bJ*\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u001d\u0010\u001a\u001a\u00020\u00162\b\u0010\u001b\u001a\u0004\u0018\u00010\u00122\b\b\u0002\u0010\u001c\u001a\u00020\u0016H\u0082\u0010J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00182\f\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u0018H\u0002J!\u0010\"\u001a\b\u0012\u0004\u0012\u00020 0\u00182\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0002\u00a2\u0006\u0002\u0010&J\u0010\u0010'\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001c\u0010(\u001a\b\u0012\u0004\u0012\u00020 0\u00182\f\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u0018H\u0002J\u0018\u0010)\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0012H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/contentsquare/android/error/analysis/crash/ErrorAnalysisCrashHandler;", "Ljava/lang/Thread$UncaughtExceptionHandler;", "chainedHandler", "errorAnalysisProvider", "Lkotlin/Function0;", "Lcom/contentsquare/android/error/analysis/ErrorAnalysis;", "appDataProvider", "Lcom/contentsquare/android/error/analysis/crash/ApplicationData;", "(Ljava/lang/Thread$UncaughtExceptionHandler;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "getChainedHandler", "()Ljava/lang/Thread$UncaughtExceptionHandler;", "logger", "Lcom/contentsquare/android/internal/features/logging/Logger;", "buildErrorStackTrace", "Lcom/contentsquare/android/error/analysis/internal/crash/ErrorStackTrace;", "thread", "Ljava/lang/Thread;", "throwable", "", "appPackage", "", "causeDepth", "", "gatherThreads", "", "Lcom/contentsquare/android/error/analysis/internal/crash/ThreadData;", "getCauseDepth", "error", "result", "handleException", "", "removeAndCountRepeatedFrames", "Lcom/contentsquare/android/error/analysis/internal/crash/Frame;", "list", "stackTraceToFrames", "stackTrace", "", "Ljava/lang/StackTraceElement;", "([Ljava/lang/StackTraceElement;)Ljava/util/List;", "threadToThreadData", "trimFrames", "uncaughtException", "Companion", "error-analysis_release"})
public final class ErrorAnalysisCrashHandler
implements Thread.UncaughtExceptionHandler {
    public static final Companion Companion = new Companion(null);
    private static final int MAX_CAUSE_DEPTH = 8;
    private static final int MAX_THREADS_TO_KEEP = 64;
    private static final int MAX_FRAMES_TO_KEEP_FROM_TOP = 15;
    private static final int MAX_FRAMES_TO_KEEP_FROM_BOTTOM = 15;
    private static final int MAX_FRAMES = 30;
    private final Thread.UncaughtExceptionHandler chainedHandler;
    private final Function0<ErrorAnalysis> errorAnalysisProvider;
    private final Function0<ApplicationData> appDataProvider;
    private final Logger logger;

    public ErrorAnalysisCrashHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler, Function0<ErrorAnalysis> function0, Function0<ApplicationData> function02) {
        Logger logger;
        Intrinsics.checkNotNullParameter(function0, (String)"errorAnalysisProvider");
        Intrinsics.checkNotNullParameter(function02, (String)"appDataProvider");
        errorAnalysisCrashHandler.chainedHandler = uncaughtExceptionHandler;
        errorAnalysisCrashHandler.errorAnalysisProvider = function0;
        errorAnalysisCrashHandler.appDataProvider = function02;
        ErrorAnalysisCrashHandler errorAnalysisCrashHandler = logger;
        logger = new Logger("ErrorAnalysisCrashHandler");
        v1.logger = errorAnalysisCrashHandler;
    }

    private final void handleException(Thread object, Throwable throwable) {
        AndroidThreadReport androidThreadReport;
        ErrorAnalysisCrashHandler errorAnalysisCrashHandler = this;
        ErrorAnalysisCrashHandler errorAnalysisCrashHandler2 = errorAnalysisCrashHandler;
        Object object2 = (ApplicationData)errorAnalysisCrashHandler.appDataProvider.invoke();
        AndroidThreadReport androidThreadReport2 = androidThreadReport;
        ApplicationData applicationData = object2;
        ErrorAnalysisCrashHandler errorAnalysisCrashHandler3 = this;
        ErrorAnalysisCrashHandler errorAnalysisCrashHandler4 = errorAnalysisCrashHandler3;
        ErrorAnalysisCrashHandler errorAnalysisCrashHandler5 = errorAnalysisCrashHandler3;
        Thread thread = object;
        ApplicationData applicationData2 = object2;
        ApplicationData applicationData3 = applicationData2;
        ApplicationData applicationData4 = applicationData2;
        object = applicationData2.getPackageName();
        object2 = applicationData4.getVersionName();
        throwable = ErrorAnalysisCrashHandler.buildErrorStackTrace$default(errorAnalysisCrashHandler4, thread, throwable, applicationData3.getPackageName(), 0, 8, null);
        List<ThreadData> list = errorAnalysisCrashHandler5.gatherThreads();
        String string = applicationData.getMappingVersion();
        try {
            androidThreadReport = new AndroidThreadReport((String)object, (String)object2, (ErrorStackTrace)throwable, list, string);
            ((ErrorAnalysis)errorAnalysisCrashHandler2.errorAnalysisProvider.invoke()).saveCrashEvent(androidThreadReport2);
        }
        catch (Throwable throwable2) {
            this.logger.e(throwable2, "Failed to deal with crash", new Object[0]);
        }
    }

    private final ErrorStackTrace buildErrorStackTrace(Thread thread, Throwable throwable, String string, int n) {
        Throwable throwable2;
        string = n < 8 && (throwable2 = throwable.getCause()) != null ? ((ErrorAnalysisCrashHandler)((Object)list)).buildErrorStackTrace(thread, throwable2, string, ++n) : null;
        n = string == null && throwable.getCause() != null ? ErrorAnalysisCrashHandler.getCauseDepth$default((ErrorAnalysisCrashHandler)((Object)list), throwable, 0, 2, null) : 0;
        Thread thread2 = thread;
        long l = thread2.getId();
        String string2 = throwable.getMessage();
        if (string2 == null) {
            string2 = "";
        }
        Thread thread3 = thread;
        ErrorAnalysisCrashHandler errorAnalysisCrashHandler = list;
        List<Frame> list = throwable.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"throwable.javaClass.name");
        ExceptionData exceptionData = new ExceptionData(string2, (String)((Object)list));
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"throwable.stackTrace");
        list = errorAnalysisCrashHandler.stackTraceToFrames(stackTraceElementArray);
        thread3(l, n, exceptionData, (ErrorStackTrace)string, list);
        return thread3;
    }

    public static /* synthetic */ ErrorStackTrace buildErrorStackTrace$default(ErrorAnalysisCrashHandler errorAnalysisCrashHandler, Thread thread, Throwable throwable, String string, int n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = 0;
        }
        return errorAnalysisCrashHandler.buildErrorStackTrace(thread, throwable, string, n);
    }

    private final List<Frame> stackTraceToFrames(StackTraceElement[] stackTraceElementArray) {
        ArrayList<Frame> arrayList;
        ArrayList<Frame> arrayList2 = arrayList;
        arrayList = new ArrayList<Frame>(stackTraceElementArray.length);
        int n = 0;
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            Frame frame;
            int n2 = n + 1;
            String string = stackTraceElement.getFileName();
            if (string == null) {
                string = "";
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stackTraceElement.fileName ?: \"\"");
            }
            String string2 = stackTraceElement.getClassName();
            if (string2 == null) {
                string2 = "";
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"stackTraceElement.className ?: \"\"");
            }
            String string3 = stackTraceElement.getMethodName();
            if (string3 == null) {
                string3 = "";
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"stackTraceElement.methodName ?: \"\"");
            }
            Frame frame2 = frame;
            int n3 = stackTraceElement.getLineNumber();
            frame2(string, string2, string3, n3);
            frame2.setFrameId(n);
            arrayList2.add(frame);
            n = n2;
        }
        ErrorAnalysisCrashHandler errorAnalysisCrashHandler = this;
        return errorAnalysisCrashHandler.trimFrames(errorAnalysisCrashHandler.removeAndCountRepeatedFrames(arrayList2));
    }

    private final List<Frame> trimFrames(List<Frame> list) {
        if (list.size() <= 30) {
            return list;
        }
        return CollectionsKt.plus((Collection)CollectionsKt.take(list, (int)15), (Iterable)CollectionsKt.takeLast(list, (int)15));
    }

    private final List<ThreadData> gatherThreads() {
        ArrayList arrayList;
        ArrayList arrayList2;
        LinkedHashMap linkedHashMap;
        Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getAllStackTraces()");
        Iterator iterator = linkedHashMap;
        linkedHashMap = new LinkedHashMap();
        for (Map.Entry<Thread, StackTraceElement[]> entry : map.entrySet()) {
            StackTraceElement[] stackTraceElementArray = entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"stackTrace.value");
            boolean bl = ((Object[])stackTraceElementArray).length == 0;
            if (!(bl ^ true)) continue;
            Map.Entry<Thread, StackTraceElement[]> entry2 = entry;
            Thread thread = entry2.getKey();
            iterator.put(thread, entry2.getValue());
        }
        Object object = arrayList2;
        arrayList2 = new ArrayList(iterator.size());
        iterator = iterator.entrySet().iterator();
        while (iterator.hasNext()) {
            object.add((Thread)((Map.Entry)iterator.next()).getKey());
        }
        iterator = CollectionsKt.take((Iterable)object, (int)64);
        object = arrayList;
        arrayList = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator), (int)10));
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Thread thread = (Thread)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)thread, (String)"it");
            object.add(this.threadToThreadData(thread));
        }
        return object;
    }

    private final ThreadData threadToThreadData(Thread thread) {
        Thread thread2 = thread;
        long l = thread2.getId();
        String string = thread2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"thread.name");
        Object object = thread2.getStackTrace();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"thread.stackTrace");
        object = this.stackTraceToFrames((StackTraceElement[])object);
        return new ThreadData(l, string, (List)object);
    }

    private final List<Frame> removeAndCountRepeatedFrames(List<Frame> list) {
        ArrayList arrayList;
        if (list.size() <= 1) {
            return list;
        }
        List<Frame> list2 = list;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        Frame frame = list2.get(0);
        int n = list2.size();
        for (int i = 1; i < n; ++i) {
            Frame frame2 = list.get(i);
            if (Intrinsics.areEqual((Object)frame, (Object)frame2)) {
                Frame frame3 = frame;
                frame3.setRepeatedCount(frame3.getRepeatedCount() + 1);
                continue;
            }
            arrayList2.add(frame);
            frame = frame2;
        }
        ArrayList arrayList3 = arrayList2;
        arrayList3.add(frame);
        return arrayList3;
    }

    private final int getCauseDepth(Throwable throwable, int n) {
        while ((throwable != null ? throwable.getCause() : null) != null) {
            throwable = throwable.getCause();
            ++n;
        }
        return n;
    }

    public static /* synthetic */ int getCauseDepth$default(ErrorAnalysisCrashHandler errorAnalysisCrashHandler, Throwable throwable, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return errorAnalysisCrashHandler.getCauseDepth(throwable, n);
    }

    public final Thread.UncaughtExceptionHandler getChainedHandler() {
        return this.chainedHandler;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        ErrorAnalysisCrashHandler errorAnalysisCrashHandler = uncaughtExceptionHandler;
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"error");
        errorAnalysisCrashHandler.handleException(thread, throwable);
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = errorAnalysisCrashHandler.chainedHandler;
        if (uncaughtExceptionHandler != null) {
            uncaughtExceptionHandler.uncaughtException(thread, throwable);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/contentsquare/android/error/analysis/crash/ErrorAnalysisCrashHandler$Companion;", "", "()V", "MAX_CAUSE_DEPTH", "", "MAX_FRAMES", "MAX_FRAMES_TO_KEEP_FROM_BOTTOM", "MAX_FRAMES_TO_KEEP_FROM_TOP", "MAX_THREADS_TO_KEEP", "error-analysis_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

