/*
 * Decompiled with CFR 0.152.
 */
package com.coreos.jetcd.internal.impl;

import com.coreos.jetcd.data.ByteSequence;
import com.coreos.jetcd.exception.ErrorCode;
import com.coreos.jetcd.exception.EtcdExceptionFactory;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.ByteString;
import io.grpc.Status;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Logger;

final class Util {
    private static final Logger logger = Logger.getLogger(Util.class.getName());

    private Util() {
    }

    static ByteString byteStringFromByteSequence(ByteSequence byteSequence) {
        return ByteString.copyFrom((byte[])byteSequence.getBytes());
    }

    static ByteSequence byteSequenceFromByteString(ByteString byteString) {
        return ByteSequence.fromBytes(byteString.toByteArray());
    }

    static <S, T> CompletableFuture<T> toCompletableFuture(final ListenableFuture<S> sourceFuture, Function<S, T> resultConvert, Executor executor) {
        CompletableFuture targetFuture = new CompletableFuture<T>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                super.cancel(mayInterruptIfRunning);
                return sourceFuture.cancel(mayInterruptIfRunning);
            }
        };
        sourceFuture.addListener(() -> {
            try {
                targetFuture.complete(resultConvert.apply(sourceFuture.get()));
            }
            catch (Exception e) {
                targetFuture.completeExceptionally(EtcdExceptionFactory.toEtcdException(e));
            }
        }, executor);
        return targetFuture;
    }

    static <S, T> CompletableFuture<T> toCompletableFutureWithRetry(Supplier<ListenableFuture<S>> newSourceFuture, Function<S, T> resultConvert, Function<Exception, Boolean> doRetry, Executor executor) {
        final AtomicReference sourceFutureRef = new AtomicReference();
        sourceFutureRef.lazySet(newSourceFuture.get());
        CompletableFuture targetFuture = new CompletableFuture<T>(){

            @Override
            public synchronized boolean cancel(boolean mayInterruptIfRunning) {
                boolean cancelled = super.cancel(mayInterruptIfRunning);
                ListenableFuture sourceFuture = (ListenableFuture)sourceFutureRef.get();
                if (sourceFuture != null) {
                    cancelled = sourceFuture.cancel(true);
                }
                return cancelled;
            }
        };
        executor.execute(() -> {
            int retryLimit = 3;
            while (retryLimit-- > 0) {
                try {
                    ListenableFuture f = (ListenableFuture)sourceFutureRef.get();
                    targetFuture.complete(resultConvert.apply(f.get()));
                    return;
                }
                catch (Exception e) {
                    if (((Boolean)doRetry.apply(e)).booleanValue()) {
                        CompletableFuture completableFuture = targetFuture;
                        synchronized (completableFuture) {
                            if (targetFuture.isCancelled()) {
                                return;
                            }
                            sourceFutureRef.set((ListenableFuture)newSourceFuture.get());
                        }
                        try {
                            Thread.sleep(500L);
                            continue;
                        }
                        catch (InterruptedException e1) {
                            targetFuture.completeExceptionally(EtcdExceptionFactory.handleInterrupt(e1));
                            return;
                        }
                    }
                    targetFuture.completeExceptionally(e);
                    return;
                }
            }
            targetFuture.completeExceptionally(EtcdExceptionFactory.newEtcdException(ErrorCode.ABORTED, "maximum number of auto retries reached"));
        });
        return targetFuture;
    }

    static boolean isRetriable(Exception e) {
        return Util.isInvalidTokenError(Status.fromThrowable((Throwable)e));
    }

    static boolean isInvalidTokenError(Status status) {
        return status.getCode() == Status.Code.UNAUTHENTICATED && "etcdserver: invalid auth token".equals(status.getDescription());
    }
}

