/*
 * Decompiled with CFR 0.152.
 */
package com.coreos.jetcd.resolver;

import com.coreos.jetcd.exception.ErrorCode;
import com.coreos.jetcd.exception.EtcdExceptionFactory;
import com.coreos.jetcd.resolver.URIResolver;
import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.SharedResourceHolder;
import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutorService;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartNameResolver
extends NameResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmartNameResolver.class);
    private final Object lock = new Object();
    private final String authority;
    private final List<URI> uris;
    private final List<URIResolver> resolvers;
    private volatile boolean shutdown;
    private volatile boolean resolving;
    @GuardedBy(value="lock")
    private ExecutorService executor;
    @GuardedBy(value="lock")
    private NameResolver.Listener listener;

    public SmartNameResolver(List<URI> uris) {
        this.authority = "etcd";
        this.uris = uris;
        this.resolvers = new ArrayList<URIResolver>();
        Iterator<URIResolver> it = ServiceLoader.load(URIResolver.class).iterator();
        while (it.hasNext()) {
            this.resolvers.add(it.next());
        }
        this.resolvers.sort(Comparator.comparingInt(r -> r.priority()));
    }

    public String getServiceAuthority() {
        return this.authority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(NameResolver.Listener listener) {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((this.listener == null ? 1 : 0) != 0, (Object)"already started");
            this.executor = (ExecutorService)SharedResourceHolder.get((SharedResourceHolder.Resource)GrpcUtil.SHARED_CHANNEL_EXECUTOR);
            this.listener = (NameResolver.Listener)Preconditions.checkNotNull((Object)listener, (Object)"listener");
            this.resolve();
        }
    }

    public final synchronized void refresh() {
        this.resolve();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        Object object = this.lock;
        synchronized (object) {
            if (this.executor != null) {
                this.executor = (ExecutorService)SharedResourceHolder.release((SharedResourceHolder.Resource)GrpcUtil.SHARED_CHANNEL_EXECUTOR, (Object)this.executor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolve() {
        if (this.resolving || this.shutdown) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.executor.execute(this::doResolve);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doResolve() {
        NameResolver.Listener savedListener;
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            this.resolving = true;
            savedListener = this.listener;
        }
        try {
            ArrayList groups = new ArrayList();
            for (URI uri : this.uris) {
                this.resolvers.stream().filter(r -> r.supports(uri)).limit(1L).flatMap(r -> r.resolve(uri).stream()).forEach(groups::add);
            }
            if (groups.isEmpty()) {
                throw EtcdExceptionFactory.newEtcdException(ErrorCode.INVALID_ARGUMENT, "Unable to resolve endpoints " + this.uris);
            }
            savedListener.onAddresses(groups, Attributes.EMPTY);
        }
        catch (Exception e) {
            LOGGER.warn("Error wile getting list of servers", (Throwable)e);
            savedListener.onError(Status.NOT_FOUND);
        }
        finally {
            this.resolving = false;
        }
    }
}

