/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.core.config.AlternateAddress;
import com.couchbase.client.core.config.BucketCapabilities;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.ClusterConfig;
import com.couchbase.client.core.config.ConfigurationException;
import com.couchbase.client.core.config.ConfigurationProvider;
import com.couchbase.client.core.config.CouchbaseBucketConfig;
import com.couchbase.client.core.config.DefaultClusterConfig;
import com.couchbase.client.core.config.LoaderType;
import com.couchbase.client.core.config.NodeInfo;
import com.couchbase.client.core.config.ProposedBucketConfigContext;
import com.couchbase.client.core.config.loader.CarrierLoader;
import com.couchbase.client.core.config.loader.HttpLoader;
import com.couchbase.client.core.config.loader.Loader;
import com.couchbase.client.core.config.parser.BucketConfigParser;
import com.couchbase.client.core.config.refresher.CarrierRefresher;
import com.couchbase.client.core.config.refresher.HttpRefresher;
import com.couchbase.client.core.config.refresher.Refresher;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.env.NetworkResolution;
import com.couchbase.client.core.event.EventBus;
import com.couchbase.client.core.event.system.BucketClosedEvent;
import com.couchbase.client.core.event.system.BucketOpenedEvent;
import com.couchbase.client.core.lang.Tuple2;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.utils.DefaultObjectMapper;
import com.couchbase.client.deps.com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action1;
import rx.functions.Func1;
import rx.subjects.PublishSubject;
import rx.subjects.Subject;

public class DefaultConfigurationProvider
implements ConfigurationProvider {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(ConfigurationProvider.class);
    private final Subject<ClusterConfig, ClusterConfig> configObservable;
    private final List<Loader> loaderChain;
    private final Map<LoaderType, Refresher> refreshers;
    private final CoreEnvironment environment;
    private final EventBus eventBus;
    private volatile boolean terminated;
    private volatile boolean bootstrapped;
    private volatile ClusterConfig currentConfig;
    private volatile Set<String> seedHosts;
    private volatile String externalNetwork;

    public DefaultConfigurationProvider(final ClusterFacade cluster, final CoreEnvironment environment) {
        this(cluster, environment, Arrays.asList(new CarrierLoader(cluster, environment), new HttpLoader(cluster, environment)), (Map<LoaderType, Refresher>)new HashMap<LoaderType, Refresher>(){
            {
                this.put(LoaderType.Carrier, new CarrierRefresher(environment, cluster));
                this.put(LoaderType.HTTP, new HttpRefresher(environment, cluster));
            }
        });
    }

    public DefaultConfigurationProvider(ClusterFacade cluster, CoreEnvironment environment, List<Loader> loaderChain, Map<LoaderType, Refresher> refreshers) {
        if (cluster == null) {
            throw new IllegalArgumentException("A cluster reference needs to be provided");
        }
        if (loaderChain == null || loaderChain.isEmpty()) {
            throw new IllegalArgumentException("At least one config loader needs to be provided");
        }
        this.loaderChain = loaderChain;
        this.refreshers = refreshers;
        this.environment = environment;
        this.eventBus = environment.eventBus();
        this.configObservable = PublishSubject.create().toSerialized();
        this.seedHosts = null;
        this.bootstrapped = false;
        this.terminated = false;
        this.currentConfig = new DefaultClusterConfig();
        Observable.from(refreshers.values()).doOnNext((Action1)new Action1<Refresher>(){

            public void call(Refresher refresher) {
                refresher.provider(DefaultConfigurationProvider.this);
            }
        }).flatMap((Func1)new Func1<Refresher, Observable<ProposedBucketConfigContext>>(){

            public Observable<ProposedBucketConfigContext> call(Refresher refresher) {
                return refresher.configs();
            }
        }).subscribe((Action1)new Action1<ProposedBucketConfigContext>(){

            public void call(ProposedBucketConfigContext ctx) {
                DefaultConfigurationProvider.this.proposeBucketConfig(ctx);
            }
        });
    }

    @Override
    public Observable<ClusterConfig> configs() {
        return this.configObservable;
    }

    @Override
    public ClusterConfig config() {
        return this.currentConfig;
    }

    @Override
    public boolean seedHosts(Set<String> hosts, boolean shuffle) {
        LOGGER.debug("Setting seed hosts to {}", (Object)hosts);
        if (shuffle) {
            ArrayList<String> hostsList = new ArrayList<String>(hosts);
            Collections.shuffle(hostsList);
            this.seedHosts = new LinkedHashSet<String>(hostsList);
        } else {
            this.seedHosts = new LinkedHashSet<String>(hosts);
        }
        return true;
    }

    @Override
    public Observable<ClusterConfig> openBucket(String bucket, String password) {
        return this.openBucket(bucket, bucket, password);
    }

    @Override
    public Observable<ClusterConfig> openBucket(final String bucket, final String username, final String password) {
        LOGGER.debug("Got instructed to open bucket {}", (Object)bucket);
        if (this.currentConfig != null && this.currentConfig.hasBucket(bucket)) {
            LOGGER.debug("Bucket {} already opened.", (Object)bucket);
            return Observable.just((Object)this.currentConfig);
        }
        if (this.seedHosts == null || this.seedHosts.isEmpty()) {
            return Observable.error((Throwable)new ConfigurationException("Seed node list not provided or empty."));
        }
        Observable observable = Observable.mergeDelayError((Observable)Observable.from(this.seedHosts).map((Func1)new Func1<String, Observable<Tuple2<LoaderType, BucketConfig>>>(){

            public Observable<Tuple2<LoaderType, BucketConfig>> call(String seedHost) {
                Observable node = ((Loader)DefaultConfigurationProvider.this.loaderChain.get(0)).loadConfig(seedHost, bucket, username, password);
                for (int i = 1; i < DefaultConfigurationProvider.this.loaderChain.size(); ++i) {
                    node = node.onErrorResumeNext(((Loader)DefaultConfigurationProvider.this.loaderChain.get(i)).loadConfig(seedHost, bucket, username, password));
                }
                return node;
            }
        })).take(1);
        return observable.doOnNext((Action1)new Action1<Tuple2<LoaderType, BucketConfig>>(){

            public void call(Tuple2<LoaderType, BucketConfig> tuple) {
                DefaultConfigurationProvider.registerBucketForRefresh(DefaultConfigurationProvider.this.refreshers, tuple.value1(), tuple.value2());
            }
        }).map((Func1)new Func1<Tuple2<LoaderType, BucketConfig>, ClusterConfig>(){

            public ClusterConfig call(Tuple2<LoaderType, BucketConfig> tuple) {
                DefaultConfigurationProvider.this.upsertBucketConfig(tuple.value2());
                return DefaultConfigurationProvider.this.currentConfig;
            }
        }).doOnNext((Action1)new Action1<ClusterConfig>(){

            public void call(ClusterConfig clusterConfig) {
                LOGGER.info("Opened bucket {}", (Object)RedactableArgument.meta(bucket));
                if (DefaultConfigurationProvider.this.eventBus != null && DefaultConfigurationProvider.this.eventBus.hasSubscribers()) {
                    DefaultConfigurationProvider.this.eventBus.publish(new BucketOpenedEvent(bucket));
                }
                DefaultConfigurationProvider.this.bootstrapped = true;
            }
        }).doOnError((Action1)new Action1<Throwable>(){

            public void call(Throwable throwable) {
                LOGGER.debug("Explicitly closing bucket {} after failed open attempt to clean resources.", (Object)bucket);
                DefaultConfigurationProvider.this.removeBucketConfig(bucket);
            }
        }).onErrorResumeNext((Func1)new Func1<Throwable, Observable<ClusterConfig>>(){

            public Observable<ClusterConfig> call(Throwable throwable) {
                return Observable.error((Throwable)new ConfigurationException("Could not open bucket.", throwable));
            }
        });
    }

    @Override
    public Observable<ClusterConfig> closeBucket(String name) {
        LOGGER.debug("Closing bucket {}", (Object)name);
        return Observable.just((Object)name).map((Func1)new Func1<String, ClusterConfig>(){

            public ClusterConfig call(String bucket) {
                DefaultConfigurationProvider.this.removeBucketConfig(bucket);
                LOGGER.info("Closed bucket {}", (Object)RedactableArgument.meta(bucket));
                if (DefaultConfigurationProvider.this.eventBus != null && DefaultConfigurationProvider.this.eventBus.hasSubscribers()) {
                    DefaultConfigurationProvider.this.eventBus.publish(new BucketClosedEvent(bucket));
                }
                return DefaultConfigurationProvider.this.currentConfig;
            }
        });
    }

    @Override
    public Observable<Boolean> closeBuckets() {
        LOGGER.debug("Closing all open buckets");
        if (this.currentConfig == null || this.currentConfig.bucketConfigs().isEmpty()) {
            return Observable.just((Object)true);
        }
        HashSet<String> configs = new HashSet<String>(this.currentConfig.bucketConfigs().keySet());
        return Observable.from(configs).observeOn(this.environment.scheduler()).flatMap((Func1)new Func1<String, Observable<? extends ClusterConfig>>(){

            public Observable<? extends ClusterConfig> call(String bucketName) {
                return DefaultConfigurationProvider.this.closeBucket(bucketName);
            }
        }).last().map((Func1)new Func1<ClusterConfig, Boolean>(){

            public Boolean call(ClusterConfig clusterConfig) {
                return true;
            }
        });
    }

    @Override
    public void proposeBucketConfig(ProposedBucketConfigContext ctx) {
        try {
            LOGGER.debug("New Bucket {} config proposed.", (Object)ctx.bucketName());
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Proposed raw config is {}", (Object)ctx.config());
            }
            JsonNode configNodes = DefaultObjectMapper.readTree(ctx.config());
            String bucketName = ctx.bucketName() == null ? configNodes.get("name").textValue() : ctx.bucketName();
            JsonNode revNode = configNodes.get("rev");
            long newRev = revNode == null ? 0L : revNode.asLong();
            BucketConfig oldConfig = this.currentConfig.bucketConfig(bucketName);
            if (newRev > 0L && oldConfig != null && newRev <= oldConfig.rev()) {
                LOGGER.trace("Not applying new configuration, older or same rev ID.");
                return;
            }
            BucketConfig config = BucketConfigParser.parse(ctx.config(), this.environment, ctx.origin());
            this.upsertBucketConfig(config);
        }
        catch (Exception ex) {
            LOGGER.warn("Could not read proposed configuration, ignoring. Message: {}", (Object)ex.getMessage());
        }
    }

    @Override
    public void signalOutdated() {
        LOGGER.debug("Received signal to proactively refresh (a maybe outdated) configuration.");
        if (this.currentConfig.bucketConfigs().isEmpty()) {
            LOGGER.debug("Ignoring outdated signal, since no buckets are open.");
            return;
        }
        for (Refresher refresher : this.refreshers.values()) {
            refresher.refresh(this.currentConfig);
        }
    }

    @Override
    public synchronized Observable<Boolean> shutdown() {
        if (this.terminated) {
            LOGGER.debug("ConfigurationProvider already shut down, ignoring.");
            return Observable.just((Object)true);
        }
        LOGGER.debug("Shutting down ConfigurationProvider.");
        this.terminated = true;
        return Observable.just((Object)true).doOnNext((Action1)new Action1<Boolean>(){

            public void call(Boolean ignored) {
                if (DefaultConfigurationProvider.this.configObservable != null) {
                    LOGGER.trace("Completing ConfigObservable for termination.");
                    DefaultConfigurationProvider.this.configObservable.onCompleted();
                }
            }
        }).flatMap((Func1)new Func1<Boolean, Observable<Boolean>>(){

            public Observable<Boolean> call(Boolean aBoolean) {
                Observable shutdownObs = Observable.just((Object)true);
                for (final Refresher refresher : DefaultConfigurationProvider.this.refreshers.values()) {
                    shutdownObs = shutdownObs.flatMap((Func1)new Func1<Boolean, Observable<Boolean>>(){

                        public Observable<Boolean> call(Boolean ignored) {
                            LOGGER.trace("Initiating {} shutdown.", (Object)refresher.getClass().getSimpleName());
                            return refresher.shutdown();
                        }
                    });
                }
                return shutdownObs;
            }
        });
    }

    static void registerBucketForRefresh(Map<LoaderType, Refresher> refreshers, LoaderType loaderType, final BucketConfig config) {
        boolean loadedFromCarrier = loaderType == LoaderType.Carrier;
        boolean canFetchFromCarrier = config instanceof CouchbaseBucketConfig && config.capabilities().contains((Object)BucketCapabilities.NODES_EXT);
        LOGGER.debug("Loaded from loader {}, can fetch from carrier {}", (Object)loaderType, (Object)canFetchFromCarrier);
        Refresher refresher = loadedFromCarrier || canFetchFromCarrier ? refreshers.get((Object)LoaderType.Carrier) : refreshers.get((Object)LoaderType.HTTP);
        LOGGER.debug("Registering bucket {} for refresh at {}", (Object)config.name(), (Object)refresher.getClass().getSimpleName());
        refresher.registerBucket(config.name(), config.username(), config.password()).subscribe((Subscriber)new Subscriber<Boolean>(){

            public void onCompleted() {
                LOGGER.trace("Config refresh stream for bucket {} ended.", (Object)config.name());
            }

            public void onError(Throwable e) {
                LOGGER.warn("Error while registering config for refresh", e);
            }

            public void onNext(Boolean aBoolean) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upsertBucketConfig(BucketConfig newConfig) {
        ClusterConfig cluster = this.currentConfig;
        BucketConfig oldConfig = cluster.bucketConfig(newConfig.name());
        if (newConfig.rev() > 0L && oldConfig != null && newConfig.rev() <= oldConfig.rev()) {
            LOGGER.trace("Not applying new configuration, older or same rev ID.");
            return;
        }
        if (newConfig.password() == null && oldConfig != null) {
            newConfig.password(oldConfig.password());
        }
        if (oldConfig != null) {
            newConfig.username(oldConfig.username());
        }
        DefaultConfigurationProvider defaultConfigurationProvider = this;
        synchronized (defaultConfigurationProvider) {
            if (oldConfig == null && this.externalNetwork == null) {
                this.externalNetwork = DefaultConfigurationProvider.determineNetworkResolution(newConfig, this.environment.networkResolution(), this.seedHosts);
                LOGGER.info("Selected network configuration: {}", (Object)(this.externalNetwork != null ? this.externalNetwork : "default"));
            }
        }
        if (this.externalNetwork != null) {
            newConfig.useAlternateNetwork(this.externalNetwork);
        }
        cluster.setBucketConfig(newConfig.name(), newConfig);
        LOGGER.debug("Applying new configuration {}", (Object)newConfig);
        this.currentConfig = cluster;
        boolean tainted = newConfig.tainted();
        for (Refresher refresher : this.refreshers.values()) {
            if (tainted) {
                refresher.markTainted(newConfig);
                continue;
            }
            refresher.markUntainted(newConfig);
        }
        this.updateSeedHosts();
        this.configObservable.onNext((Object)this.currentConfig);
    }

    private void updateSeedHosts() {
        ClusterConfig config = this.currentConfig;
        HashSet<String> newSeedHosts = new HashSet<String>();
        for (BucketConfig bucketConfig : config.bucketConfigs().values()) {
            for (NodeInfo nodeInfo : bucketConfig.nodes()) {
                if (!nodeInfo.services().containsKey((Object)ServiceType.BINARY) && !nodeInfo.sslServices().containsKey((Object)ServiceType.BINARY)) continue;
                String alternate = bucketConfig.useAlternateNetwork();
                if (alternate != null) {
                    AlternateAddress aa = nodeInfo.alternateAddresses().get(alternate);
                    if (aa == null) {
                        throw new IllegalStateException("Instructed to use alternate address for seed nodes, but not present - this is a bug!");
                    }
                    newSeedHosts.add(aa.hostname());
                    continue;
                }
                newSeedHosts.add(nodeInfo.hostname());
            }
        }
        if (!newSeedHosts.isEmpty() && !this.seedHosts.equals(newSeedHosts)) {
            this.seedHosts(newSeedHosts, true);
        }
    }

    public static String determineNetworkResolution(BucketConfig config, NetworkResolution nr, Set<String> seedHosts) {
        if (nr.equals(NetworkResolution.DEFAULT)) {
            return null;
        }
        if (nr.equals(NetworkResolution.AUTO)) {
            for (NodeInfo info : config.nodes()) {
                if (seedHosts.contains(info.hostname())) {
                    return null;
                }
                Map<String, AlternateAddress> aa = info.alternateAddresses();
                if (aa == null || aa.isEmpty()) continue;
                for (Map.Entry<String, AlternateAddress> entry : aa.entrySet()) {
                    AlternateAddress alternateAddress = entry.getValue();
                    if (alternateAddress == null || !seedHosts.contains(alternateAddress.hostname())) continue;
                    return entry.getKey();
                }
            }
            return null;
        }
        return nr.name();
    }

    private void removeBucketConfig(String name) {
        LOGGER.debug("Removing bucket {} configuration from known configs.", (Object)name);
        ClusterConfig cluster = this.currentConfig;
        cluster.deleteBucketConfig(name);
        this.currentConfig = cluster;
        this.configObservable.onNext((Object)this.currentConfig);
    }
}

