/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DmDriver;
import dm.jdbc.driver.DmdbDataSourceFactory;
import dm.jdbc.util.StringUtil;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;

public class DmdbDataSource
implements Serializable,
Referenceable,
DataSource {
    private static final long serialVersionUID = 1L;
    private PrintWriter hi;
    private int hj;
    protected String hk;
    protected String hl;
    private String hm;
    private int port;
    private String url;

    @Override
    public Connection getConnection() {
        return this.getConnection(this.hk, this.hl);
    }

    @Override
    public Connection getConnection(String string, String string2) {
        Properties properties = new Properties();
        if (StringUtil.isNotEmpty(this.hm)) {
            properties.setProperty("host", this.hm);
        }
        if (this.port > 0) {
            properties.setProperty("port", String.valueOf(this.port));
        }
        if (StringUtil.isNotEmpty(string)) {
            properties.setProperty("user", string);
        }
        if (StringUtil.isNotEmpty(string2)) {
            properties.setProperty("password", string2);
        }
        return DmDriver.fX.connect(this.getURL(), properties);
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.hi;
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) {
        this.hi = printWriter;
    }

    @Override
    public void setLoginTimeout(int n2) {
        this.hj = n2;
    }

    @Override
    public int getLoginTimeout() {
        return this.hj;
    }

    public String getURL() {
        return StringUtil.isNotEmpty(this.url) ? this.url : "jdbc:dm://" + this.hm + ":" + this.port;
    }

    public void setURL(String string) {
        this.url = string;
    }

    public String getServer() {
        return this.hm;
    }

    public void setServer(String string) {
        this.hm = string;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n2) {
        this.port = n2;
    }

    public String getUser() {
        return this.hk;
    }

    public void setUser(String string) {
        this.hk = string;
    }

    public String getPassword() {
        return this.hl;
    }

    public void setPassword(String string) {
        this.hl = string;
    }

    @Override
    public Reference getReference() {
        String string = DmdbDataSourceFactory.class.getName();
        Reference reference = new Reference(this.getClass().getName(), string, null);
        reference.add(new StringRefAddr("host", this.getServer()));
        reference.add(new StringRefAddr("port", String.valueOf(this.getPort())));
        if (this.url != null) {
            reference.add(new StringRefAddr("url", this.url));
        }
        reference.add(new StringRefAddr("user", this.getUser()));
        reference.add(new StringRefAddr("password", this.hl));
        return reference;
    }

    @Override
    public Logger getParentLogger() {
        return null;
    }

    public Object unwrap(Class clazz) {
        return clazz.cast(this);
    }

    public boolean isWrapperFor(Class clazz) {
        return clazz.isInstance(this);
    }
}

