/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.internal.listener;

import com.dangdang.ddframe.job.lite.api.listener.ElasticJobListener;
import com.dangdang.ddframe.job.lite.internal.config.ConfigurationListenerManager;
import com.dangdang.ddframe.job.lite.internal.election.ElectionListenerManager;
import com.dangdang.ddframe.job.lite.internal.execution.ExecutionListenerManager;
import com.dangdang.ddframe.job.lite.internal.failover.FailoverListenerManager;
import com.dangdang.ddframe.job.lite.internal.guarantee.GuaranteeListenerManager;
import com.dangdang.ddframe.job.lite.internal.server.JobOperationListenerManager;
import com.dangdang.ddframe.job.lite.internal.sharding.ShardingListenerManager;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import java.util.List;

public class ListenerManager {
    private final ElectionListenerManager electionListenerManager;
    private final ShardingListenerManager shardingListenerManager;
    private final ExecutionListenerManager executionListenerManager;
    private final FailoverListenerManager failoverListenerManager;
    private final JobOperationListenerManager jobOperationListenerManager;
    private final ConfigurationListenerManager configurationListenerManager;
    private final GuaranteeListenerManager guaranteeListenerManager;

    public ListenerManager(CoordinatorRegistryCenter regCenter, String jobName, List<ElasticJobListener> elasticJobListeners) {
        this.electionListenerManager = new ElectionListenerManager(regCenter, jobName);
        this.shardingListenerManager = new ShardingListenerManager(regCenter, jobName);
        this.executionListenerManager = new ExecutionListenerManager(regCenter, jobName);
        this.failoverListenerManager = new FailoverListenerManager(regCenter, jobName);
        this.jobOperationListenerManager = new JobOperationListenerManager(regCenter, jobName);
        this.configurationListenerManager = new ConfigurationListenerManager(regCenter, jobName);
        this.guaranteeListenerManager = new GuaranteeListenerManager(regCenter, jobName, elasticJobListeners);
    }

    public void startAllListeners() {
        this.electionListenerManager.start();
        this.shardingListenerManager.start();
        this.executionListenerManager.start();
        this.failoverListenerManager.start();
        this.jobOperationListenerManager.start();
        this.configurationListenerManager.start();
        this.guaranteeListenerManager.start();
    }

    public void setCurrentShardingTotalCount(int currentShardingTotalCount) {
        this.shardingListenerManager.setCurrentShardingTotalCount(currentShardingTotalCount);
    }
}

