/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.internal.server;

import com.dangdang.ddframe.job.lite.internal.server.ServerNode;
import com.dangdang.ddframe.job.lite.internal.server.ServerStatus;
import com.dangdang.ddframe.job.lite.internal.storage.JobNodeStorage;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import com.dangdang.ddframe.job.util.env.LocalHostService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ServerService {
    private final JobNodeStorage jobNodeStorage;
    private final LocalHostService localHostService = new LocalHostService();

    public ServerService(CoordinatorRegistryCenter regCenter, String jobName) {
        this.jobNodeStorage = new JobNodeStorage(regCenter, jobName);
    }

    public void clearPreviousServerStatus() {
        this.jobNodeStorage.removeJobNodeIfExisted(ServerNode.getStatusNode(this.localHostService.getIp()));
        this.jobNodeStorage.removeJobNodeIfExisted(ServerNode.getShutdownNode(this.localHostService.getIp()));
    }

    public void persistServerOnline(boolean enabled) {
        this.jobNodeStorage.fillJobNode(ServerNode.getHostNameNode(this.localHostService.getIp()), this.localHostService.getHostName());
        if (enabled) {
            this.jobNodeStorage.removeJobNodeIfExisted(ServerNode.getDisabledNode(this.localHostService.getIp()));
        } else {
            this.jobNodeStorage.fillJobNode(ServerNode.getDisabledNode(this.localHostService.getIp()), "");
        }
        this.jobNodeStorage.fillEphemeralJobNode(ServerNode.getStatusNode(this.localHostService.getIp()), (Object)ServerStatus.READY);
        this.jobNodeStorage.removeJobNodeIfExisted(ServerNode.getShutdownNode(this.localHostService.getIp()));
    }

    public void clearJobTriggerStatus() {
        this.jobNodeStorage.removeJobNodeIfExisted(ServerNode.getTriggerNode(this.localHostService.getIp()));
    }

    public void clearJobPausedStatus() {
        this.jobNodeStorage.removeJobNodeIfExisted(ServerNode.getPausedNode(this.localHostService.getIp()));
    }

    public boolean isJobPausedManually() {
        return this.jobNodeStorage.isJobNodeExisted(ServerNode.getPausedNode(this.localHostService.getIp()));
    }

    public void processServerShutdown() {
        this.jobNodeStorage.removeJobNodeIfExisted(ServerNode.getStatusNode(this.localHostService.getIp()));
    }

    public void updateServerStatus(ServerStatus status) {
        this.jobNodeStorage.updateJobNode(ServerNode.getStatusNode(this.localHostService.getIp()), (Object)status);
    }

    public void removeServerStatus() {
        this.jobNodeStorage.removeJobNodeIfExisted(ServerNode.getStatusNode(this.localHostService.getIp()));
    }

    public List<String> getAllServers() {
        List<String> result = this.jobNodeStorage.getJobNodeChildrenKeys("servers");
        Collections.sort(result);
        return result;
    }

    public List<String> getAvailableShardingServers() {
        List<String> servers = this.getAllServers();
        ArrayList<String> result = new ArrayList<String>(servers.size());
        for (String each : servers) {
            if (!this.isAvailableShardingServer(each)) continue;
            result.add(each);
        }
        return result;
    }

    private boolean isAvailableShardingServer(String ip) {
        return this.jobNodeStorage.isJobNodeExisted(ServerNode.getStatusNode(ip)) && !this.jobNodeStorage.isJobNodeExisted(ServerNode.getDisabledNode(ip)) && !this.jobNodeStorage.isJobNodeExisted(ServerNode.getShutdownNode(ip));
    }

    public List<String> getAvailableServers() {
        List<String> servers = this.getAllServers();
        ArrayList<String> result = new ArrayList<String>(servers.size());
        for (String each : servers) {
            if (!this.isAvailableServer(each)) continue;
            result.add(each);
        }
        return result;
    }

    public boolean isAvailableServer(String ip) {
        return this.jobNodeStorage.isJobNodeExisted(ServerNode.getStatusNode(ip)) && !this.jobNodeStorage.isJobNodeExisted(ServerNode.getPausedNode(ip)) && !this.jobNodeStorage.isJobNodeExisted(ServerNode.getDisabledNode(ip)) && !this.jobNodeStorage.isJobNodeExisted(ServerNode.getShutdownNode(ip));
    }

    public boolean isLocalhostServerReady() {
        String ip = this.localHostService.getIp();
        return this.isAvailableServer(ip) && ServerStatus.READY.name().equals(this.jobNodeStorage.getJobNodeData(ServerNode.getStatusNode(ip)));
    }

    public boolean isLocalhostServerEnabled() {
        return !this.jobNodeStorage.isJobNodeExisted(ServerNode.getDisabledNode(this.localHostService.getIp()));
    }
}

