/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.internal.sharding;

import com.dangdang.ddframe.job.lite.internal.config.ConfigurationNode;
import com.dangdang.ddframe.job.lite.internal.config.LiteJobConfigurationGsonFactory;
import com.dangdang.ddframe.job.lite.internal.execution.ExecutionService;
import com.dangdang.ddframe.job.lite.internal.listener.AbstractJobListener;
import com.dangdang.ddframe.job.lite.internal.listener.AbstractListenerManager;
import com.dangdang.ddframe.job.lite.internal.server.ServerNode;
import com.dangdang.ddframe.job.lite.internal.sharding.ShardingService;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;

public class ShardingListenerManager
extends AbstractListenerManager {
    private final ShardingService shardingService;
    private final ExecutionService executionService;
    private final ConfigurationNode configNode;
    private final ServerNode serverNode;
    private int currentShardingTotalCount;

    public ShardingListenerManager(CoordinatorRegistryCenter regCenter, String jobName) {
        super(regCenter, jobName);
        this.shardingService = new ShardingService(regCenter, jobName);
        this.executionService = new ExecutionService(regCenter, jobName);
        this.configNode = new ConfigurationNode(jobName);
        this.serverNode = new ServerNode(jobName);
    }

    @Override
    public void start() {
        this.addDataListener(new ShardingTotalCountChangedJobListener());
        this.addDataListener(new ListenServersChangedJobListener());
    }

    public void setCurrentShardingTotalCount(int currentShardingTotalCount) {
        this.currentShardingTotalCount = currentShardingTotalCount;
    }

    class ListenServersChangedJobListener
    extends AbstractJobListener {
        ListenServersChangedJobListener() {
        }

        @Override
        protected void dataChanged(CuratorFramework client, TreeCacheEvent event, String path) {
            if (this.isServersCrashed(event, path) || ShardingListenerManager.this.serverNode.isServerDisabledPath(path) || ShardingListenerManager.this.serverNode.isServerShutdownPath(path)) {
                ShardingListenerManager.this.shardingService.setReshardingFlag();
            }
        }

        private boolean isServersCrashed(TreeCacheEvent event, String path) {
            return ShardingListenerManager.this.serverNode.isServerStatusPath(path) && TreeCacheEvent.Type.NODE_UPDATED != event.getType();
        }
    }

    class ShardingTotalCountChangedJobListener
    extends AbstractJobListener {
        ShardingTotalCountChangedJobListener() {
        }

        @Override
        protected void dataChanged(CuratorFramework client, TreeCacheEvent event, String path) {
            int newShardingTotalCount;
            if (ShardingListenerManager.this.configNode.isConfigPath(path) && 0 != ShardingListenerManager.this.currentShardingTotalCount && (newShardingTotalCount = LiteJobConfigurationGsonFactory.fromJson(new String(event.getData().getData())).getTypeConfig().getCoreConfig().getShardingTotalCount()) != ShardingListenerManager.this.currentShardingTotalCount) {
                ShardingListenerManager.this.shardingService.setReshardingFlag();
                ShardingListenerManager.this.executionService.setNeedFixExecutionInfoFlag();
                ShardingListenerManager.this.currentShardingTotalCount = newShardingTotalCount;
            }
        }
    }
}

