/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.internal.storage;

import com.dangdang.ddframe.job.exception.JobSystemException;
import com.dangdang.ddframe.job.lite.internal.storage.JobNodePath;
import com.dangdang.ddframe.job.lite.internal.storage.LeaderExecutionCallback;
import com.dangdang.ddframe.job.lite.internal.storage.TransactionExecutionCallback;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import com.dangdang.ddframe.job.reg.exception.RegExceptionHandler;
import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.transaction.CuratorTransactionBridge;
import org.apache.curator.framework.api.transaction.CuratorTransactionFinal;
import org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.curator.framework.recipes.cache.TreeCacheListener;
import org.apache.curator.framework.recipes.leader.LeaderLatch;
import org.apache.curator.framework.state.ConnectionStateListener;

public class JobNodeStorage {
    private final CoordinatorRegistryCenter regCenter;
    private final String jobName;
    private final JobNodePath jobNodePath;

    public JobNodeStorage(CoordinatorRegistryCenter regCenter, String jobName) {
        this.regCenter = regCenter;
        this.jobName = jobName;
        this.jobNodePath = new JobNodePath(jobName);
    }

    public boolean isJobNodeExisted(String node) {
        return this.regCenter.isExisted(this.jobNodePath.getFullPath(node));
    }

    public String getJobNodeData(String node) {
        return this.regCenter.get(this.jobNodePath.getFullPath(node));
    }

    public String getJobNodeDataDirectly(String node) {
        return this.regCenter.getDirectly(this.jobNodePath.getFullPath(node));
    }

    public List<String> getJobNodeChildrenKeys(String node) {
        return this.regCenter.getChildrenKeys(this.jobNodePath.getFullPath(node));
    }

    public void createJobNodeIfNeeded(String node) {
        if (this.isJobRootNodeExisted() && !this.isJobNodeExisted(node)) {
            this.regCenter.persist(this.jobNodePath.getFullPath(node), "");
        }
    }

    private boolean isJobRootNodeExisted() {
        return this.regCenter.isExisted("/" + this.jobName);
    }

    public void removeJobNodeIfExisted(String node) {
        if (this.isJobNodeExisted(node)) {
            this.regCenter.remove(this.jobNodePath.getFullPath(node));
        }
    }

    public void fillJobNode(String node, Object value) {
        this.regCenter.persist(this.jobNodePath.getFullPath(node), value.toString());
    }

    public void fillEphemeralJobNode(String node, Object value) {
        this.regCenter.persistEphemeral(this.jobNodePath.getFullPath(node), value.toString());
    }

    public void updateJobNode(String node, Object value) {
        this.regCenter.update(this.jobNodePath.getFullPath(node), value.toString());
    }

    public void replaceJobNode(String node, Object value) {
        this.regCenter.persist(this.jobNodePath.getFullPath(node), value.toString());
    }

    public void executeInTransaction(TransactionExecutionCallback callback) {
        try {
            CuratorTransactionFinal curatorTransactionFinal = ((CuratorTransactionBridge)this.getClient().inTransaction().check().forPath("/")).and();
            callback.execute(curatorTransactionFinal);
            curatorTransactionFinal.commit();
        }
        catch (Exception ex) {
            RegExceptionHandler.handleException((Exception)ex);
        }
    }

    public void executeInLeader(String latchNode, LeaderExecutionCallback callback) {
        try (LeaderLatch latch = new LeaderLatch(this.getClient(), this.jobNodePath.getFullPath(latchNode));){
            latch.start();
            latch.await();
            callback.execute();
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    private void handleException(Exception ex) {
        if (!(ex instanceof InterruptedException)) {
            throw new JobSystemException((Throwable)ex);
        }
        Thread.currentThread().interrupt();
    }

    public void addConnectionStateListener(ConnectionStateListener listener) {
        this.getClient().getConnectionStateListenable().addListener((Object)listener);
    }

    private CuratorFramework getClient() {
        return (CuratorFramework)this.regCenter.getRawClient();
    }

    public void addDataListener(TreeCacheListener listener) {
        TreeCache cache = (TreeCache)this.regCenter.getRawCache("/" + this.jobName);
        cache.getListenable().addListener((Object)listener);
    }

    public long getRegistryCenterTime() {
        return this.regCenter.getRegistryCenterTime(this.jobNodePath.getFullPath("systemTime/current"));
    }
}

