/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.spring.job.parser.common;

import com.dangdang.ddframe.job.config.JobCoreConfiguration;
import com.dangdang.ddframe.job.event.rdb.JobEventRdbConfiguration;
import com.dangdang.ddframe.job.executor.handler.JobProperties;
import com.dangdang.ddframe.job.lite.config.LiteJobConfiguration;
import com.dangdang.ddframe.job.lite.spring.api.SpringJobScheduler;
import com.google.common.base.Strings;
import java.util.EnumMap;
import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public abstract class AbstractJobBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(SpringJobScheduler.class);
        factory.setInitMethodName("init");
        if ("".equals(element.getAttribute("class"))) {
            factory.addConstructorArgValue(null);
        } else {
            factory.addConstructorArgValue((Object)BeanDefinitionBuilder.rootBeanDefinition((String)element.getAttribute("class")).getBeanDefinition());
        }
        factory.addConstructorArgReference(element.getAttribute("registry-center-ref"));
        factory.addConstructorArgValue((Object)this.createLiteJobConfiguration(element));
        BeanDefinition jobEventConfig = this.createJobEventConfig(element);
        if (null != jobEventConfig) {
            factory.addConstructorArgValue((Object)jobEventConfig);
        }
        factory.addConstructorArgValue(this.createJobListeners(element));
        return factory.getBeanDefinition();
    }

    protected abstract BeanDefinition getJobTypeConfigurationBeanDefinition(BeanDefinition var1, Element var2);

    private BeanDefinition createLiteJobConfiguration(Element element) {
        return this.createLiteJobConfigurationBeanDefinition(element, this.createJobCoreBeanDefinition(element));
    }

    private BeanDefinition createLiteJobConfigurationBeanDefinition(Element element, BeanDefinition jobCoreBeanDefinition) {
        BeanDefinitionBuilder result = BeanDefinitionBuilder.rootBeanDefinition(LiteJobConfiguration.class);
        result.addConstructorArgValue((Object)this.getJobTypeConfigurationBeanDefinition(jobCoreBeanDefinition, element));
        result.addConstructorArgValue((Object)element.getAttribute("monitor-execution"));
        result.addConstructorArgValue((Object)element.getAttribute("max-time-diff-seconds"));
        result.addConstructorArgValue((Object)element.getAttribute("monitor-port"));
        result.addConstructorArgValue((Object)element.getAttribute("job-sharding-strategy-class"));
        result.addConstructorArgValue((Object)element.getAttribute("reconcile-interval-minutes"));
        result.addConstructorArgValue((Object)element.getAttribute("disabled"));
        result.addConstructorArgValue((Object)element.getAttribute("overwrite"));
        return result.getBeanDefinition();
    }

    private BeanDefinition createJobCoreBeanDefinition(Element element) {
        BeanDefinitionBuilder jobCoreBeanDefinitionBuilder = BeanDefinitionBuilder.rootBeanDefinition(JobCoreConfiguration.class);
        jobCoreBeanDefinitionBuilder.addConstructorArgValue((Object)element.getAttribute("id"));
        jobCoreBeanDefinitionBuilder.addConstructorArgValue((Object)element.getAttribute("cron"));
        jobCoreBeanDefinitionBuilder.addConstructorArgValue((Object)element.getAttribute("sharding-total-count"));
        jobCoreBeanDefinitionBuilder.addConstructorArgValue((Object)element.getAttribute("sharding-item-parameters"));
        jobCoreBeanDefinitionBuilder.addConstructorArgValue((Object)element.getAttribute("job-parameter"));
        jobCoreBeanDefinitionBuilder.addConstructorArgValue((Object)element.getAttribute("failover"));
        jobCoreBeanDefinitionBuilder.addConstructorArgValue((Object)element.getAttribute("misfire"));
        jobCoreBeanDefinitionBuilder.addConstructorArgValue((Object)element.getAttribute("description"));
        jobCoreBeanDefinitionBuilder.addConstructorArgValue((Object)this.createJobPropertiesBeanDefinition(element));
        return jobCoreBeanDefinitionBuilder.getBeanDefinition();
    }

    private BeanDefinition createJobPropertiesBeanDefinition(Element element) {
        BeanDefinitionBuilder result = BeanDefinitionBuilder.rootBeanDefinition(JobProperties.class);
        EnumMap<JobProperties.JobPropertiesEnum, String> map = new EnumMap<JobProperties.JobPropertiesEnum, String>(JobProperties.JobPropertiesEnum.class);
        map.put(JobProperties.JobPropertiesEnum.EXECUTOR_SERVICE_HANDLER, element.getAttribute("executor-service-handler"));
        map.put(JobProperties.JobPropertiesEnum.JOB_EXCEPTION_HANDLER, element.getAttribute("job-exception-handler"));
        result.addConstructorArgValue(map);
        return result.getBeanDefinition();
    }

    private BeanDefinition createJobEventConfig(Element element) {
        String eventTraceDataSourceName = element.getAttribute("event-trace-rdb-data-source");
        if (Strings.isNullOrEmpty((String)eventTraceDataSourceName)) {
            return null;
        }
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(JobEventRdbConfiguration.class);
        factory.addConstructorArgReference(eventTraceDataSourceName);
        return factory.getBeanDefinition();
    }

    private List<BeanDefinition> createJobListeners(Element element) {
        BeanDefinitionBuilder factory;
        Element listenerElement = DomUtils.getChildElementByTagName((Element)element, (String)"listener");
        Element distributedListenerElement = DomUtils.getChildElementByTagName((Element)element, (String)"distributed-listener");
        ManagedList result = new ManagedList(2);
        if (null != listenerElement) {
            factory = BeanDefinitionBuilder.rootBeanDefinition((String)listenerElement.getAttribute("class"));
            factory.setScope("prototype");
            result.add(factory.getBeanDefinition());
        }
        if (null != distributedListenerElement) {
            factory = BeanDefinitionBuilder.rootBeanDefinition((String)distributedListenerElement.getAttribute("class"));
            factory.setScope("prototype");
            factory.addConstructorArgValue((Object)distributedListenerElement.getAttribute("started-timeout-milliseconds"));
            factory.addConstructorArgValue((Object)distributedListenerElement.getAttribute("completed-timeout-milliseconds"));
            result.add(factory.getBeanDefinition());
        }
        return result;
    }

    protected boolean shouldGenerateId() {
        return true;
    }
}

