/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.merger.resultset.memory.row;

import com.dangdang.ddframe.rdb.sharding.merger.resultset.memory.row.AbstractResultSetRow;
import com.dangdang.ddframe.rdb.sharding.merger.util.ResultSetUtil;
import com.dangdang.ddframe.rdb.sharding.parser.result.merger.OrderByColumn;
import com.google.common.base.Preconditions;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class OrderByResultSetRow
extends AbstractResultSetRow
implements Comparable<OrderByResultSetRow> {
    private final List<OrderByColumn> orderByColumns;
    private final List<Comparable<?>> orderByValues;

    public OrderByResultSetRow(ResultSet resultSet, List<OrderByColumn> orderByColumns) throws SQLException {
        super(resultSet);
        this.orderByColumns = orderByColumns;
        this.orderByValues = this.loadOrderByValues();
    }

    private List<Comparable<?>> loadOrderByValues() {
        ArrayList result = new ArrayList(this.orderByColumns.size());
        for (OrderByColumn each : this.orderByColumns) {
            Object value = this.getCell(each.getColumnIndex());
            Preconditions.checkState((boolean)(value instanceof Comparable), (Object)"Sharding-JDBC: order by value must extends Comparable");
            result.add((Comparable)value);
        }
        return result;
    }

    @Override
    public int compareTo(OrderByResultSetRow otherOrderByValue) {
        for (int i = 0; i < this.orderByColumns.size(); ++i) {
            OrderByColumn thisOrderByColumn = this.orderByColumns.get(i);
            int result = ResultSetUtil.compareTo(this.orderByValues.get(i), otherOrderByValue.orderByValues.get(i), thisOrderByColumn.getOrderByType());
            if (0 == result) continue;
            return result;
        }
        return 0;
    }

    public String toString() {
        return String.format("Order by columns value is %s", this.orderByValues);
    }
}

