/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.parser.result.router;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SQLBuilder
implements Appendable {
    private final List<SQLBuilder> derivedSQLBuilders = new ArrayList<SQLBuilder>();
    private final List<Object> segments;
    private final Map<String, StringToken> tokenMap;
    private final List<StringToken> newTokenList = new LinkedList<StringToken>();
    private StringBuilder currentSegment;
    private boolean changed;
    private boolean removeDerivedSQLToken;
    private boolean hasExistedDerivedSQLToken;

    public SQLBuilder() {
        this.segments = new LinkedList<Object>();
        this.tokenMap = new HashMap<String, StringToken>();
        this.currentSegment = new StringBuilder();
        this.segments.add(this.currentSegment);
    }

    private SQLBuilder(SQLBuilder originBuilder) {
        this.segments = new LinkedList<Object>(originBuilder.segments);
        this.tokenMap = new HashMap<String, StringToken>(originBuilder.tokenMap);
        this.changeState();
    }

    public void appendToken(String token) {
        this.appendToken(token, token);
    }

    public void appendToken(String label, String token) {
        StringToken stringToken;
        if (this.tokenMap.containsKey(label)) {
            stringToken = this.tokenMap.get(label);
        } else {
            stringToken = new StringToken();
            stringToken.label = label;
            stringToken.value = token;
            this.tokenMap.put(label, stringToken);
        }
        stringToken.indices.add(this.segments.size());
        this.segments.add(stringToken);
        this.currentSegment = new StringBuilder();
        this.segments.add(this.currentSegment);
    }

    public void buildSQL(String label, String token) {
        this.buildSQL(label, token, false);
    }

    public void buildSQL(String label, String token, boolean isDerived) {
        if (!this.tokenMap.containsKey(label)) {
            return;
        }
        if (isDerived) {
            this.hasExistedDerivedSQLToken = true;
        }
        StringToken labelSQL = this.tokenMap.get(label);
        labelSQL.isDerived = isDerived;
        labelSQL.value = token;
        this.changeState();
    }

    public void recordNewToken(String label, String token) {
        StringToken newToken = new StringToken();
        newToken.label = label;
        newToken.value = token;
        this.newTokenList.add(newToken);
    }

    public SQLBuilder buildSQLWithNewToken() {
        if (!this.newTokenList.isEmpty()) {
            this.changeState();
        }
        SQLBuilder result = new SQLBuilder(this);
        for (StringToken each : this.newTokenList) {
            StringToken origin = result.tokenMap.get(each.label);
            each.indices.addAll(origin.indices);
            result.tokenMap.put(each.label, each);
            for (Integer index : origin.indices) {
                result.segments.set(index, each);
            }
        }
        this.derivedSQLBuilders.add(result);
        this.newTokenList.clear();
        return result;
    }

    public String toSQL() {
        this.clearState();
        StringBuilder result = new StringBuilder();
        for (Object each : this.segments) {
            result.append(each.toString());
        }
        return result.toString();
    }

    @Override
    public Appendable append(CharSequence sql) throws IOException {
        this.currentSegment.append(sql);
        this.changeState();
        return this;
    }

    @Override
    public Appendable append(CharSequence sql, int start, int end) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Appendable append(char c) throws IOException {
        this.currentSegment.append(c);
        this.changeState();
        return this;
    }

    private void changeState() {
        this.changed = true;
        for (SQLBuilder each : this.derivedSQLBuilders) {
            each.changeState();
        }
    }

    private void clearState() {
        this.changed = false;
    }

    public void removeDerivedSQL() {
        if (this.hasExistedDerivedSQLToken) {
            this.removeDerivedSQLToken = true;
            this.changeState();
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (Object each : this.segments) {
            if (each instanceof StringToken) {
                result.append(((StringToken)each).toToken());
                continue;
            }
            result.append(each.toString());
        }
        return result.toString();
    }

    public boolean isChanged() {
        return this.changed;
    }

    private boolean isRemoveDerivedSQLToken() {
        return this.removeDerivedSQLToken;
    }

    private class StringToken {
        private String label;
        private String value;
        private boolean isDerived;
        private final List<Integer> indices = new LinkedList<Integer>();

        private StringToken() {
        }

        String toToken() {
            if (this.isEmptyValueOutput()) {
                return "";
            }
            Joiner joiner = Joiner.on((String)"");
            return this.label.equals(this.value) ? joiner.join((Object)"[Token(", (Object)this.value, new Object[]{")]"}) : joiner.join((Object)"[", (Object)this.label, new Object[]{"(", this.value, ")]"});
        }

        private boolean isEmptyValueOutput() {
            return null == this.value || this.isDerived && SQLBuilder.this.isRemoveDerivedSQLToken();
        }

        public String toString() {
            return this.isEmptyValueOutput() ? "" : this.value;
        }
    }
}

