/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.router;

import com.codahale.metrics.Timer;
import com.dangdang.ddframe.rdb.sharding.api.rule.ShardingRule;
import com.dangdang.ddframe.rdb.sharding.constants.DatabaseType;
import com.dangdang.ddframe.rdb.sharding.exception.SQLParserException;
import com.dangdang.ddframe.rdb.sharding.metrics.MetricsContext;
import com.dangdang.ddframe.rdb.sharding.parser.SQLParserFactory;
import com.dangdang.ddframe.rdb.sharding.parser.result.SQLParsedResult;
import com.dangdang.ddframe.rdb.sharding.parser.result.merger.Limit;
import com.dangdang.ddframe.rdb.sharding.parser.result.router.ConditionContext;
import com.dangdang.ddframe.rdb.sharding.parser.result.router.SQLBuilder;
import com.dangdang.ddframe.rdb.sharding.parser.result.router.Table;
import com.dangdang.ddframe.rdb.sharding.router.PreparedSQLRouter;
import com.dangdang.ddframe.rdb.sharding.router.RoutingResult;
import com.dangdang.ddframe.rdb.sharding.router.SQLExecutionUnit;
import com.dangdang.ddframe.rdb.sharding.router.SQLRouteResult;
import com.dangdang.ddframe.rdb.sharding.router.binding.BindingTablesRouter;
import com.dangdang.ddframe.rdb.sharding.router.mixed.MixedTablesRouter;
import com.dangdang.ddframe.rdb.sharding.router.single.SingleTableRouter;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SQLRouteEngine {
    private static final Logger log = LoggerFactory.getLogger(SQLRouteEngine.class);
    private final ShardingRule shardingRule;
    private final DatabaseType databaseType;

    public SQLRouteResult route(String logicSql) throws SQLParserException {
        return this.route(logicSql, Collections.emptyList());
    }

    SQLRouteResult route(String logicSql, List<Object> parameters) throws SQLParserException {
        return this.routeSQL(this.parseSQL(logicSql, parameters), parameters);
    }

    public PreparedSQLRouter prepareSQL(String logicSql) {
        return new PreparedSQLRouter(logicSql, this, this.shardingRule);
    }

    SQLParsedResult parseSQL(String logicSql, List<Object> parameters) {
        Timer.Context context = MetricsContext.start("Parse SQL");
        SQLParsedResult result = SQLParserFactory.create(this.databaseType, logicSql, parameters, this.shardingRule).parse();
        MetricsContext.stop(context);
        return result;
    }

    SQLRouteResult routeSQL(SQLParsedResult parsedResult, List<Object> parameters) {
        Timer.Context context = MetricsContext.start("Route SQL");
        SQLRouteResult result = new SQLRouteResult(parsedResult.getRouteContext().getSqlStatementType(), parsedResult.getMergeContext(), parsedResult.getGeneratedKeyContext());
        for (ConditionContext conditionContext : parsedResult.getConditionContexts()) {
            RoutingResult routingResult = this.routeSQL(conditionContext, parsedResult);
            result.getExecutionUnits().addAll(routingResult.getSQLExecutionUnits(parsedResult.getRouteContext().getSqlBuilder()));
        }
        this.amendSQLAccordingToRouteResult(parsedResult, parameters, result);
        MetricsContext.stop(context);
        log.debug("final route result is {} target", (Object)result.getExecutionUnits().size());
        for (SQLExecutionUnit sQLExecutionUnit : result.getExecutionUnits()) {
            log.debug("{}:{} {}", new Object[]{sQLExecutionUnit.getDataSource(), sQLExecutionUnit.getSql(), parameters});
        }
        log.debug("merge context:{}", (Object)result.getMergeContext());
        return result;
    }

    private RoutingResult routeSQL(ConditionContext conditionContext, SQLParsedResult parsedResult) {
        LinkedHashSet logicTables = Sets.newLinkedHashSet((Iterable)Collections2.transform(parsedResult.getRouteContext().getTables(), (Function)new Function<Table, String>(){

            public String apply(Table input) {
                return input.getName();
            }
        }));
        if (1 == logicTables.size()) {
            return new SingleTableRouter(this.shardingRule, (String)logicTables.iterator().next(), conditionContext, parsedResult.getRouteContext().getSqlStatementType()).route();
        }
        if (this.shardingRule.isAllBindingTables(logicTables)) {
            return new BindingTablesRouter(this.shardingRule, logicTables, conditionContext, parsedResult.getRouteContext().getSqlStatementType()).route();
        }
        return new MixedTablesRouter(this.shardingRule, logicTables, conditionContext, parsedResult.getRouteContext().getSqlStatementType()).route();
    }

    private void amendSQLAccordingToRouteResult(SQLParsedResult parsedResult, List<Object> parameters, SQLRouteResult result) {
        boolean isVarious = result.getExecutionUnits().size() > 1;
        Limit limit = result.getMergeContext().getLimit();
        SQLBuilder sqlBuilder = parsedResult.getRouteContext().getSqlBuilder();
        if (null != limit) {
            limit.replaceSQL(sqlBuilder, isVarious);
            limit.replaceParameters(parameters, isVarious);
        }
        if (!isVarious) {
            sqlBuilder.removeDerivedSQL();
        }
    }

    @ConstructorProperties(value={"shardingRule", "databaseType"})
    public SQLRouteEngine(ShardingRule shardingRule, DatabaseType databaseType) {
        this.shardingRule = shardingRule;
        this.databaseType = databaseType;
    }
}

