/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.router.mixed;

import com.dangdang.ddframe.rdb.sharding.router.mixed.CartesianResult;
import com.dangdang.ddframe.rdb.sharding.router.mixed.CartesianTableReference;
import com.dangdang.ddframe.rdb.sharding.router.single.SingleRoutingResult;
import com.dangdang.ddframe.rdb.sharding.router.single.SingleRoutingTableFactor;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CartesianTablesRouter {
    private static final Logger log = LoggerFactory.getLogger(CartesianTablesRouter.class);
    private final Collection<SingleRoutingResult> routingResults;

    CartesianResult route() {
        CartesianResult result = new CartesianResult();
        for (Map.Entry<String, Set<String>> entry : this.getDataSourceLogicTablesMap().entrySet()) {
            List<Set<String>> actualTableGroups = this.getActualTableGroups(entry.getKey(), entry.getValue());
            List<Set<SingleRoutingTableFactor>> routingTableFactorGroups = this.toRoutingTableFactorGroups(entry.getKey(), actualTableGroups);
            result.merge(entry.getKey(), this.getCartesianTableReferences(Sets.cartesianProduct(routingTableFactorGroups)));
        }
        log.trace("cartesian tables sharding result: {}", (Object)result);
        return result;
    }

    private Map<String, Set<String>> getDataSourceLogicTablesMap() {
        Collection<String> intersectionDataSources = this.getIntersectionDataSources();
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>(this.routingResults.size());
        for (SingleRoutingResult each : this.routingResults) {
            for (Map.Entry<String, Set<String>> entry : each.getDataSourceLogicTablesMap(intersectionDataSources).entrySet()) {
                if (result.containsKey(entry.getKey())) {
                    ((Set)result.get(entry.getKey())).addAll((Collection)entry.getValue());
                    continue;
                }
                result.put(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    private Collection<String> getIntersectionDataSources() {
        HashSet<String> result = new HashSet<String>();
        for (SingleRoutingResult each : this.routingResults) {
            if (result.isEmpty()) {
                result.addAll(each.getDataSources());
            }
            result.retainAll(each.getDataSources());
        }
        return result;
    }

    private List<Set<String>> getActualTableGroups(String dataSource, Set<String> logicTables) {
        ArrayList<Set<String>> result = new ArrayList<Set<String>>(logicTables.size());
        for (SingleRoutingResult each : this.routingResults) {
            result.addAll(each.getActualTableGroups(dataSource, logicTables));
        }
        return result;
    }

    private List<Set<SingleRoutingTableFactor>> toRoutingTableFactorGroups(final String dataSource, List<Set<String>> actualTableGroups) {
        ArrayList<Set<SingleRoutingTableFactor>> result = new ArrayList<Set<SingleRoutingTableFactor>>(actualTableGroups.size());
        for (Set<String> each : actualTableGroups) {
            result.add(new HashSet(Lists.transform(new ArrayList<String>(each), (Function)new Function<String, SingleRoutingTableFactor>(){

                public SingleRoutingTableFactor apply(String input) {
                    return CartesianTablesRouter.this.findRoutingTableFactor(dataSource, input);
                }
            })));
        }
        return result;
    }

    private SingleRoutingTableFactor findRoutingTableFactor(String dataSource, String actualTable) {
        for (SingleRoutingResult each : this.routingResults) {
            Optional<SingleRoutingTableFactor> result = each.findRoutingTableFactor(dataSource, actualTable);
            if (!result.isPresent()) continue;
            return (SingleRoutingTableFactor)result.get();
        }
        throw new IllegalStateException(String.format("Cannot found routing table factor, data source: %s, actual table: %s", dataSource, actualTable));
    }

    private List<CartesianTableReference> getCartesianTableReferences(Set<List<SingleRoutingTableFactor>> cartesianRoutingTableFactorGroups) {
        ArrayList<CartesianTableReference> result = new ArrayList<CartesianTableReference>(cartesianRoutingTableFactorGroups.size());
        for (List<SingleRoutingTableFactor> each : cartesianRoutingTableFactorGroups) {
            result.add(new CartesianTableReference(each));
        }
        return result;
    }

    @ConstructorProperties(value={"routingResults"})
    public CartesianTablesRouter(Collection<SingleRoutingResult> routingResults) {
        this.routingResults = routingResults;
    }
}

