/*
 * Decompiled with CFR 0.152.
 */
package com.dingtalk.open.app.stream.network.ws;

import com.alibaba.fastjson2.JSON;
import com.dingtalk.open.app.stream.network.api.utils.NettyByteBufUtils;
import com.dingtalk.open.app.stream.protocol.ProtocolRequest;
import com.dingtalk.open.app.stream.protocol.ProtocolResponse;
import shade.io.netty.channel.ChannelDuplexHandler;
import shade.io.netty.channel.ChannelHandlerContext;
import shade.io.netty.channel.ChannelPromise;
import shade.io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import shade.io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import shade.io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import shade.io.netty.util.ReferenceCountUtil;

public class ProtocolFrameHandler
extends ChannelDuplexHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof TextWebSocketFrame) {
            try {
                byte[] data = NettyByteBufUtils.getBytes(((TextWebSocketFrame)msg).content());
                ProtocolRequest request = (ProtocolRequest)JSON.parseObject((byte[])data, ProtocolRequest.class);
                ctx.fireChannelRead(request);
            }
            finally {
                ReferenceCountUtil.safeRelease(msg);
            }
            return;
        }
        if (msg instanceof PingWebSocketFrame) {
            ctx.channel().writeAndFlush(new PongWebSocketFrame(((PingWebSocketFrame)msg).content()));
            return;
        }
        ctx.fireChannelRead(msg);
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof ProtocolResponse) {
            TextWebSocketFrame frame = new TextWebSocketFrame(JSON.toJSONString((Object)msg));
            ctx.write(frame);
        } else {
            super.write(ctx, msg, promise);
        }
    }
}

