/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.http;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejlchina.http.HttpResult;
import com.ejlchina.http.internal.HttpClient;
import com.ejlchina.http.internal.HttpException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;

public abstract class HttpTask<C extends HttpTask<?>> {
    private static final MediaType TYPE_JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static String PATH_PARAM_REGEX = "[A-Za-z0-9_\\-/]*\\{[A-Za-z0-9_\\-]+\\}[A-Za-z0-9_\\-/]*";
    protected HttpClient httpClient;
    private String urlPath;
    private Map<String, String> headers;
    private Map<String, String> pathParams;
    private Map<String, String> urlParams;
    private Map<String, String> bodyParams;
    private Map<String, String> jsonStrParams;
    private Map<String, Integer> jsonIntParams;
    private Map<String, FilePara> files;
    private String requestJson;
    protected boolean nothrow;
    protected String tag;

    public HttpTask(HttpClient httpClient, String urlPath) {
        this.httpClient = httpClient;
        this.urlPath = urlPath;
    }

    public C nothrow() {
        this.nothrow = true;
        return (C)this;
    }

    public C tag(String tag) {
        this.tag = tag;
        return (C)this;
    }

    public String getTag() {
        return this.tag;
    }

    public String getUrl() {
        return this.urlPath;
    }

    public C addHeader(String name, String value) {
        if (name != null && value != null) {
            if (this.headers == null) {
                this.headers = new HashMap<String, String>();
            }
            this.headers.put(name, value);
        }
        return (C)this;
    }

    public C addHeader(Map<String, String> headers) {
        if (headers != null) {
            if (this.headers == null) {
                this.headers = new HashMap<String, String>();
            }
            this.headers.putAll(headers);
        }
        return (C)this;
    }

    public C addPathParam(String name, String value) {
        if (name != null && value != null) {
            if (this.pathParams == null) {
                this.pathParams = new HashMap<String, String>();
            }
            this.pathParams.put(name, value);
        }
        return (C)this;
    }

    public C addPathParam(String name, Number value) {
        if (value != null) {
            this.addPathParam(name, value.toString());
        }
        return (C)this;
    }

    public C addPathParam(Map<String, ?> params) {
        if (params != null) {
            if (this.pathParams == null) {
                this.pathParams = new HashMap<String, String>();
            }
            params.forEach((name, value) -> {
                if (name != null && value != null) {
                    this.pathParams.put((String)name, value.toString());
                }
            });
        }
        return (C)this;
    }

    public C addUrlParam(String name, String value) {
        if (name != null && value != null) {
            if (this.urlParams == null) {
                this.urlParams = new HashMap<String, String>();
            }
            this.urlParams.put(name, value);
        }
        return (C)this;
    }

    public C addUrlParam(String name, Number value) {
        if (value != null) {
            this.addUrlParam(name, value.toString());
        }
        return (C)this;
    }

    public C addUrlParam(Map<String, ?> params) {
        if (params != null) {
            if (this.urlParams == null) {
                this.urlParams = new HashMap<String, String>();
            }
            params.forEach((name, value) -> {
                if (name != null && value != null) {
                    this.urlParams.put((String)name, value.toString());
                }
            });
        }
        return (C)this;
    }

    public C addBodyParam(String name, String value) {
        if (name != null && value != null) {
            if (this.bodyParams == null) {
                this.bodyParams = new HashMap<String, String>();
            }
            this.bodyParams.put(name, value);
        }
        return (C)this;
    }

    public C addBodyParam(String name, Number value) {
        if (value != null) {
            this.addBodyParam(name, value.toString());
        }
        return (C)this;
    }

    public C addBodyParam(Map<String, ?> params) {
        if (params != null) {
            if (this.bodyParams == null) {
                this.bodyParams = new HashMap<String, String>();
            }
            params.forEach((name, value) -> {
                if (name != null && value != null) {
                    this.bodyParams.put((String)name, value.toString());
                }
            });
        }
        return (C)this;
    }

    public C addJsonParam(String name, String value) {
        if (name != null && value != null) {
            if (this.jsonStrParams == null) {
                this.jsonStrParams = new HashMap<String, String>();
            }
            this.jsonStrParams.put(name, value);
        }
        return (C)this;
    }

    public C addJsonParam(String name, Number value) {
        if (value != null) {
            this.addJsonParam(name, value.toString());
        }
        return (C)this;
    }

    public C addJsonParam(Map<String, Object> params) {
        if (params != null) {
            if (this.jsonStrParams == null) {
                this.jsonStrParams = new HashMap<String, String>();
            }
            params.forEach((name, value) -> {
                if (name != null && value != null) {
                    this.jsonStrParams.put((String)name, value.toString());
                }
            });
        }
        return (C)this;
    }

    public C setRequestJson(String json) {
        if (json != null) {
            this.requestJson = json;
        }
        return (C)this;
    }

    public C setRequestJson(Object bean) {
        if (bean != null) {
            this.requestJson = JSON.toJSONString((Object)bean);
        }
        return (C)this;
    }

    public C setRequestJson(Object bean, String dateFormat) {
        if (bean != null) {
            this.requestJson = JSON.toJSONStringWithDateFormat((Object)bean, (String)dateFormat, (SerializerFeature[])new SerializerFeature[0]);
        }
        return (C)this;
    }

    public C addFileParam(String name, File file) {
        if (name != null && file != null && file.exists()) {
            String filename = file.getName();
            String type = filename.substring(filename.lastIndexOf(".") + 1);
            try {
                this.addFileParam(name, type, filename, new FileInputStream(file));
            }
            catch (FileNotFoundException e) {
                throw new HttpException("\u4e0a\u4f20\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\uff01", e);
            }
        }
        return (C)this;
    }

    public C addFileParam(String name, String type, InputStream inputStream) {
        String fileName = System.currentTimeMillis() + "." + type;
        return this.addFileParam(name, type, fileName, inputStream);
    }

    public C addFileParam(String name, String type, String fileName, InputStream input) {
        if (name != null && input != null) {
            byte[] content = null;
            try {
                Buffer buffer = new Buffer();
                content = buffer.readFrom(input).readByteArray();
                buffer.close();
            }
            catch (IOException e) {
                throw new HttpException("\u8bfb\u53d6\u6587\u4ef6\u8f93\u5165\u6d41\u51fa\u9519\uff1a", e);
            }
            this.addFileParam(name, type, fileName, content);
        }
        return (C)this;
    }

    public C addFileParam(String name, String type, byte[] content) {
        String fileName = System.currentTimeMillis() + "." + type;
        return this.addFileParam(name, type, fileName, content);
    }

    public C addFileParam(String name, String type, String fileName, byte[] content) {
        if (name != null && content != null) {
            if (this.files == null) {
                this.files = new HashMap<String, FilePara>();
            }
            this.files.put(name, new FilePara(type, fileName, content));
        }
        return (C)this;
    }

    protected Call prepareCall(String method) {
        this.assertNotConflict("GET".equals(method));
        Request.Builder builder = new Request.Builder().url(this.buildUrlPath());
        this.buildHeaders(builder);
        switch (method) {
            case "GET": {
                builder.get();
                break;
            }
            case "POST": {
                builder.post(this.buildRequestBody());
                break;
            }
            case "PUT": {
                builder.put(this.buildRequestBody());
                break;
            }
            case "DELETE": {
                builder.delete(this.buildRequestBody());
            }
        }
        return this.httpClient.callRequest(builder.build());
    }

    private void buildHeaders(Request.Builder builder) {
        if (this.headers != null) {
            for (String name : this.headers.keySet()) {
                String value = this.headers.get(name);
                if (value == null) continue;
                builder.addHeader(name, value);
            }
        }
    }

    protected String toString(Response response) throws IOException {
        String body = null;
        ResponseBody rbody = response.body();
        if (rbody != null) {
            body = rbody.string();
        }
        return body;
    }

    protected HttpResult.State toState(Exception e) {
        if (e instanceof SocketTimeoutException) {
            return HttpResult.State.TIMEOUT;
        }
        if (e instanceof UnknownHostException || e instanceof ConnectException) {
            return HttpResult.State.NETWORK_ERROR;
        }
        if ("Canceled".equals(e.getMessage())) {
            return HttpResult.State.CANCELED;
        }
        return HttpResult.State.EXCEPTION;
    }

    private RequestBody buildRequestBody() {
        if (this.jsonStrParams != null || this.jsonIntParams != null) {
            this.requestJson = this.buildRequestJson();
        }
        if (this.files != null) {
            MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
            if (this.bodyParams != null) {
                for (String name : this.bodyParams.keySet()) {
                    String value = this.bodyParams.get(name);
                    builder.addFormDataPart(name, value);
                }
            }
            for (String name : this.files.keySet()) {
                FilePara file = this.files.get(name);
                MediaType type = this.httpClient.getMediaType(file.type);
                builder.addFormDataPart(name, file.fileName, RequestBody.create((MediaType)type, (byte[])file.content));
            }
            return builder.build();
        }
        if (this.requestJson != null) {
            return RequestBody.create((MediaType)TYPE_JSON, (String)this.requestJson);
        }
        FormBody.Builder builder = new FormBody.Builder();
        if (this.bodyParams != null) {
            for (String name : this.bodyParams.keySet()) {
                String value = this.bodyParams.get(name);
                builder.add(name, value);
            }
        }
        return builder.build();
    }

    private String buildRequestJson() {
        String json = "{";
        if (this.jsonStrParams != null) {
            for (String name : this.jsonStrParams.keySet()) {
                String value = this.jsonStrParams.get(name);
                if (value != null) {
                    json = json + "\"" + name + "\":\"" + value + "\",";
                    continue;
                }
                json = json + "\"" + name + "\":null,";
            }
        }
        if (this.jsonIntParams != null) {
            for (String name : this.jsonIntParams.keySet()) {
                json = json + "\"" + name + "\":" + this.jsonIntParams.get(name) + ",";
            }
        }
        return json.substring(0, json.length() - 1) + "}";
    }

    private String buildUrlPath() {
        String url = this.urlPath;
        if (url == null || url.trim().isEmpty()) {
            throw new HttpException("url \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (this.pathParams != null) {
            for (String name : this.pathParams.keySet()) {
                String target = "{" + name + "}";
                if (url.contains(target)) {
                    url = url.replace(target, this.pathParams.get(name));
                    continue;
                }
                throw new HttpException("pathParameter [ " + name + " ] \u4e0d\u5b58\u5728\u4e8e url [ " + this.urlPath + " ]");
            }
        }
        if (url.matches(PATH_PARAM_REGEX)) {
            throw new HttpException("url \u91cc\u6709 pathParameter \u6ca1\u6709\u8bbe\u7f6e\uff0c\u4f60\u5fc5\u987b\u5148\u8c03\u7528 addPathParam \u4e3a\u5176\u8bbe\u7f6e\uff01");
        }
        if (this.urlParams != null) {
            if (url.contains("?")) {
                if (!url.endsWith("?")) {
                    if ((url = url.trim()).lastIndexOf("=") < url.lastIndexOf("?") + 2) {
                        throw new HttpException("url \u683c\u5f0f\u9519\u8bef\uff0c'\uff1f' \u540e\u6ca1\u6709\u53d1\u73b0 '='");
                    }
                    if (!url.endsWith("&")) {
                        url = url + "&";
                    }
                }
            } else {
                url = url + "?";
            }
            for (String name : this.urlParams.keySet()) {
                url = url + name + "=" + this.urlParams.get(name) + "&";
            }
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    protected void assertNotConflict(boolean isGetRequest) {
        if (isGetRequest) {
            if (this.requestJson != null) {
                throw new HttpException("GET \u8bf7\u6c42 \u4e0d\u80fd\u8c03\u7528 setRequestJson \u65b9\u6cd5\uff01");
            }
            if (this.jsonStrParams != null || this.jsonIntParams != null) {
                throw new HttpException("GET \u8bf7\u6c42 \u4e0d\u80fd\u8c03\u7528 addJsonParam \u65b9\u6cd5\uff01");
            }
            if (this.bodyParams != null) {
                throw new HttpException("GET \u8bf7\u6c42 \u4e0d\u80fd\u8c03\u7528 addBodyParam \u65b9\u6cd5\uff01");
            }
            if (this.files != null) {
                throw new HttpException("GET \u8bf7\u6c42 \u4e0d\u80fd\u8c03\u7528 addFileParam \u65b9\u6cd5\uff01");
            }
        }
        if (this.requestJson != null) {
            if (this.jsonStrParams != null || this.jsonIntParams != null) {
                throw new HttpException("\u65b9\u6cd5 addJsonParam \u4e0e setRequestJson \u4e0d\u80fd\u540c\u65f6\u8c03\u7528\uff01");
            }
            if (this.bodyParams != null) {
                throw new HttpException("\u65b9\u6cd5 addBodyParam \u4e0e setRequestJson \u4e0d\u80fd\u540c\u65f6\u8c03\u7528\uff01");
            }
            if (this.files != null) {
                throw new HttpException("\u65b9\u6cd5 addFileParam \u4e0e setRequestJson \u4e0d\u80fd\u540c\u65f6\u8c03\u7528\uff01");
            }
        }
        if (this.jsonStrParams != null || this.jsonIntParams != null) {
            if (this.bodyParams != null) {
                throw new HttpException("\u65b9\u6cd5 addBodyParam \u4e0e addJsonParam \u4e0d\u80fd\u540c\u65f6\u8c03\u7528\uff01");
            }
            if (this.files != null) {
                throw new HttpException("\u65b9\u6cd5 addFileParam \u4e0e addJsonParam \u4e0d\u80fd\u540c\u65f6\u8c03\u7528\uff01");
            }
        }
    }

    class FilePara {
        String type;
        String fileName;
        byte[] content;

        FilePara(String type, String fileName, byte[] content) {
            this.type = type;
            this.fileName = fileName;
            this.content = content;
        }
    }
}

