/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.http.internal;

import com.ejlchina.http.HttpCall;
import com.ejlchina.http.HttpResult;
import com.ejlchina.http.HttpTask;
import com.ejlchina.http.OnCallback;
import com.ejlchina.http.internal.HttpClient;
import com.ejlchina.http.internal.HttpException;
import com.ejlchina.http.internal.RealHttpResult;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;

public class AsyncHttpTask
extends HttpTask<AsyncHttpTask> {
    private OnCallback<HttpResult> onResponse;
    private OnCallback<Exception> onException;
    private OnCallback<HttpResult.State> onComplete;

    public AsyncHttpTask(HttpClient client, String urlPath) {
        super(client, urlPath);
    }

    public AsyncHttpTask setOnException(OnCallback<Exception> onException) {
        this.onException = onException;
        return this;
    }

    public AsyncHttpTask setOnComplete(OnCallback<HttpResult.State> onComplete) {
        this.onComplete = onComplete;
        return this;
    }

    public AsyncHttpTask setOnResponse(OnCallback<HttpResult> onResponse) {
        this.onResponse = onResponse;
        return this;
    }

    public HttpCall get() {
        return this.request("GET");
    }

    public HttpCall post() {
        return this.request("POST");
    }

    public HttpCall put() {
        return this.request("PUT");
    }

    public HttpCall delete() {
        return this.request("DELETE");
    }

    private HttpCall request(String method) {
        PreHttpCall call = new PreHttpCall();
        this.httpClient.preprocess(this, () -> {
            PreHttpCall preHttpCall = call;
            synchronized (preHttpCall) {
                if (!call.isCanceled()) {
                    call.setCall(this.executeCall(this.prepareCall(method)));
                }
            }
        });
        if (this.tag != null) {
            this.httpClient.addTagCall(this.tag, call, this);
        }
        return call;
    }

    private HttpCall executeCall(Call call) {
        final OkHttpCall httpCall = new OkHttpCall(call);
        call.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                HttpResult.State state = AsyncHttpTask.this.toState(e);
                AsyncHttpTask.this.doOnException(state, e);
                if (state == HttpResult.State.CANCELED) {
                    httpCall.setResult(new RealHttpResult(state));
                } else {
                    httpCall.setResult(new RealHttpResult(state, e));
                }
            }

            public void onResponse(Call call, Response response) throws IOException {
                RealHttpResult result = new RealHttpResult(response);
                AsyncHttpTask.this.doOnResponse(result);
                httpCall.setResult(result);
            }
        });
        return httpCall;
    }

    private void doOnResponse(RealHttpResult result) {
        this.httpClient.executeCallback(() -> {
            if (this.onComplete != null) {
                this.onComplete.on(HttpResult.State.RESPONSED);
            }
            if (this.onResponse != null) {
                this.onResponse.on(result);
            }
        });
    }

    private void doOnException(HttpResult.State state, Exception e) {
        this.httpClient.executeCallback(() -> {
            if (this.onComplete != null) {
                this.onComplete.on(state);
            }
            if (state != HttpResult.State.CANCELED) {
                if (this.onException != null) {
                    this.onException.on(e);
                } else if (!this.nothrow) {
                    throw new HttpException(e.getMessage(), e);
                }
            }
        });
    }

    class OkHttpCall
    implements HttpCall {
        private Call call;
        private RealHttpResult result;

        public OkHttpCall(Call call) {
            this.call = call;
        }

        @Override
        public boolean cancel() {
            if (this.result == null) {
                this.call.cancel();
                return true;
            }
            return false;
        }

        @Override
        public boolean isDone() {
            return this.result != null;
        }

        @Override
        public boolean isCanceled() {
            return this.call.isCanceled();
        }

        @Override
        public synchronized RealHttpResult getResult() {
            if (this.result == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new HttpException(e.getMessage(), e);
                }
            }
            return this.result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setResult(RealHttpResult result) {
            OkHttpCall okHttpCall = this;
            synchronized (okHttpCall) {
                this.result = result;
                this.notify();
            }
            if (AsyncHttpTask.this.tag != null) {
                AsyncHttpTask.this.httpClient.removeTagCall(AsyncHttpTask.this);
            }
        }
    }

    class PreHttpCall
    implements HttpCall {
        private boolean canceled = false;
        private HttpCall call;

        PreHttpCall() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel() {
            boolean res = true;
            PreHttpCall preHttpCall = this;
            synchronized (preHttpCall) {
                if (this.call != null) {
                    res = this.call.cancel();
                } else {
                    this.canceled = true;
                }
                this.notify();
            }
            if (AsyncHttpTask.this.tag != null && this.call == null) {
                AsyncHttpTask.this.httpClient.removeTagCall(AsyncHttpTask.this);
            }
            return res;
        }

        @Override
        public boolean isDone() {
            if (this.call != null) {
                return this.call.isDone();
            }
            return this.canceled;
        }

        @Override
        public boolean isCanceled() {
            if (this.call != null) {
                return this.call.isCanceled();
            }
            return this.canceled;
        }

        public void setCall(HttpCall call) {
            this.call = call;
            this.notify();
        }

        @Override
        public synchronized RealHttpResult getResult() {
            if (this.canceled) {
                return new RealHttpResult(HttpResult.State.CANCELED);
            }
            if (this.call == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new HttpException(e.getMessage(), e);
                }
            }
            if (this.call != null) {
                return this.call.getResult();
            }
            return new RealHttpResult(HttpResult.State.CANCELED);
        }
    }
}

