/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.http.internal;

import com.ejlchina.http.Configurator;
import com.ejlchina.http.HTTP;
import com.ejlchina.http.HttpCall;
import com.ejlchina.http.HttpTask;
import com.ejlchina.http.Preprocessor;
import com.ejlchina.http.internal.AsyncHttpTask;
import com.ejlchina.http.internal.HttpException;
import com.ejlchina.http.internal.SyncHttpTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Executor;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;

public class HttpClient
implements HTTP {
    private OkHttpClient client;
    private String baseUrl;
    private Map<String, String> mediaTypes;
    private Executor callbackExecutor;
    private Preprocessor[] preprocessors;
    private List<TagCall> tagCalls;

    private HttpClient(Builder builder) {
        this.client = builder.client;
        this.baseUrl = builder.baseUrl;
        this.mediaTypes = builder.mediaTypes;
        this.callbackExecutor = builder.callbackExecutor;
        this.preprocessors = builder.preprocessors.toArray(new Preprocessor[builder.preprocessors.size()]);
        this.tagCalls = Collections.synchronizedList(new LinkedList());
    }

    @Override
    public AsyncHttpTask async(String urlPath) {
        return new AsyncHttpTask(this, this.urlPath(urlPath));
    }

    @Override
    public SyncHttpTask sync(String urlPath) {
        return new SyncHttpTask(this, this.urlPath(urlPath));
    }

    @Override
    public int cancel(String tag) {
        if (tag == null) {
            return 0;
        }
        int count = 0;
        Iterator<TagCall> it = this.tagCalls.iterator();
        while (it.hasNext()) {
            TagCall tagCall = it.next();
            if (!tag.equals(tagCall.tag)) continue;
            if (tagCall.call.cancel()) {
                ++count;
            }
            it.remove();
        }
        return count;
    }

    public int getTagCallCount() {
        return this.tagCalls.size();
    }

    public void addTagCall(String tag, HttpCall call, HttpTask<?> task) {
        this.tagCalls.add(new TagCall(tag, call, task));
    }

    public void removeTagCall(HttpTask<?> task) {
        Iterator<TagCall> it = this.tagCalls.iterator();
        while (it.hasNext()) {
            TagCall tagCall = it.next();
            if (tagCall.task != task) continue;
            it.remove();
            break;
        }
    }

    public Call callRequest(Request request) {
        return this.client.newCall(request);
    }

    public MediaType getMediaType(String type) {
        String mediaType = this.mediaTypes.get(type);
        if (mediaType != null) {
            return MediaType.parse((String)mediaType);
        }
        return MediaType.parse((String)"application/octet-stream");
    }

    public void executeCallback(Runnable callback) {
        if (this.callbackExecutor != null) {
            this.callbackExecutor.execute(callback);
        } else {
            callback.run();
        }
    }

    public void preprocess(HttpTask<? extends HttpTask<?>> httpTask, Runnable request) {
        if (this.preprocessors.length > 0) {
            HttpProcess process = new HttpProcess(this.preprocessors, httpTask, request);
            this.preprocessors[0].doProcess(process);
        } else {
            request.run();
        }
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    private String urlPath(String urlPath) {
        boolean isFullPath;
        boolean bl = isFullPath = urlPath.startsWith("https://") || urlPath.startsWith("http://");
        if (isFullPath) {
            return urlPath;
        }
        if (this.baseUrl != null) {
            return this.baseUrl + urlPath;
        }
        throw new HttpException("\u5728\u8bbe\u7f6e BaseUrl \u4e4b\u524d\uff0c\u60a8\u5fc5\u987b\u4f7f\u7528\u5168\u8def\u5f84URL\u53d1\u8d77\u8bf7\u6c42\uff0c\u5f53\u524dURL\u4e3a\uff1a" + urlPath);
    }

    public static class Builder {
        private OkHttpClient client;
        private String baseUrl;
        private Map<String, String> mediaTypes;
        private Configurator configurator;
        private Executor callbackExecutor;
        private List<Preprocessor> preprocessors;

        public Builder() {
            this.mediaTypes = new HashMap<String, String>();
            this.mediaTypes.put("*", "application/octet-stream");
            this.mediaTypes.put("png", "image/png");
            this.mediaTypes.put("jpg", "image/jpeg");
            this.mediaTypes.put("jpeg", "image/jpeg");
            this.mediaTypes.put("wav", "audio/wav");
            this.mediaTypes.put("mp3", "audio/mp3");
            this.mediaTypes.put("mp4", "video/mpeg4");
            this.mediaTypes.put("txt", "text/plain");
            this.mediaTypes.put("xls", "application/x-xls");
            this.mediaTypes.put("xml", "text/xml");
            this.mediaTypes.put("apk", "application/vnd.android.package-archive");
            this.mediaTypes.put("doc", "application/msword");
            this.mediaTypes.put("pdf", "application/pdf");
            this.mediaTypes.put("html", "text/html");
            this.preprocessors = new ArrayList<Preprocessor>();
        }

        private Builder(HttpClient hc) {
            this.client = hc.client;
            this.baseUrl = hc.baseUrl;
            this.mediaTypes = hc.mediaTypes;
            this.preprocessors = new ArrayList<Preprocessor>();
            Collections.addAll(this.preprocessors, hc.preprocessors);
        }

        public Builder config(Configurator configurator) {
            this.configurator = configurator;
            return this;
        }

        public Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder mediaTypes(Map<String, String> mediaTypes) {
            this.mediaTypes.putAll(mediaTypes);
            return this;
        }

        public Builder mediaTypes(String key, String value) {
            this.mediaTypes.put(key, value);
            return this;
        }

        public Builder callbackExecutor(Executor executor) {
            this.callbackExecutor = executor;
            return this;
        }

        public Builder addPreprocessor(Preprocessor preprocessor) {
            this.preprocessors.add(preprocessor);
            return this;
        }

        public Builder addSerialPreprocessor(Preprocessor preprocessor) {
            this.preprocessors.add(new SerialPreprocessor(preprocessor));
            return this;
        }

        public HTTP build() {
            if (this.configurator != null || this.client == null) {
                OkHttpClient.Builder builder = new OkHttpClient.Builder();
                if (this.configurator != null) {
                    this.configurator.config(builder);
                }
                this.client = builder.build();
            }
            return new HttpClient(this);
        }
    }

    class HttpProcess
    implements Preprocessor.Process {
        private int index = 1;
        private Preprocessor[] preprocessors;
        private HttpTask<? extends HttpTask<?>> httpTask;
        private Runnable request;

        public HttpProcess(Preprocessor[] preprocessors, HttpTask<? extends HttpTask<?>> httpTask, Runnable request) {
            this.preprocessors = preprocessors;
            this.httpTask = httpTask;
            this.request = request;
        }

        @Override
        public HttpTask<? extends HttpTask<?>> getTask() {
            return this.httpTask;
        }

        @Override
        public HTTP getHttp() {
            return HttpClient.this;
        }

        @Override
        public void proceed() {
            Preprocessor last;
            if (this.index > 0 && (last = this.preprocessors[this.index - 1]) instanceof SerialPreprocessor) {
                ((SerialPreprocessor)last).afterProcess();
            }
            if (this.index < this.preprocessors.length) {
                this.preprocessors[this.index++].doProcess(this);
            } else {
                this.request.run();
            }
        }
    }

    static class SerialPreprocessor
    implements Preprocessor {
        private Preprocessor preprocessor;
        private Queue<Preprocessor.Process> pendings;
        private boolean running = false;

        SerialPreprocessor(Preprocessor preprocessor) {
            this.preprocessor = preprocessor;
            this.pendings = new LinkedList<Preprocessor.Process>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doProcess(Preprocessor.Process process) {
            boolean should = true;
            SerialPreprocessor serialPreprocessor = this;
            synchronized (serialPreprocessor) {
                if (this.running) {
                    this.pendings.add(process);
                    should = false;
                } else {
                    this.running = true;
                }
            }
            if (should) {
                this.preprocessor.doProcess(process);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterProcess() {
            Preprocessor.Process process = null;
            SerialPreprocessor serialPreprocessor = this;
            synchronized (serialPreprocessor) {
                if (this.pendings.size() > 0) {
                    process = this.pendings.poll();
                } else {
                    this.running = false;
                }
            }
            if (process != null) {
                this.preprocessor.doProcess(process);
            }
        }
    }

    class TagCall {
        String tag;
        HttpCall call;
        HttpTask<?> task;

        public TagCall(String tag, HttpCall call, HttpTask<?> task) {
            this.tag = tag;
            this.call = call;
            this.task = task;
        }
    }
}

