/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.http.internal;

import com.ejlchina.http.HttpResult;
import com.ejlchina.http.internal.ResultBody;
import okhttp3.Headers;
import okhttp3.Response;

public class RealHttpResult
implements HttpResult {
    private HttpResult.State state;
    private Response response;
    private Exception error;

    public RealHttpResult() {
    }

    public RealHttpResult(HttpResult.State state) {
        this.state = state;
    }

    public RealHttpResult(Response response) {
        this.response(response);
    }

    public RealHttpResult(HttpResult.State state, Exception error) {
        this.exception(state, error);
    }

    public void exception(HttpResult.State state, Exception error) {
        this.state = state;
        this.error = error;
    }

    public void response(Response response) {
        this.state = HttpResult.State.RESPONSED;
        this.response = response;
    }

    @Override
    public HttpResult.State getState() {
        return this.state;
    }

    @Override
    public int getStatus() {
        if (this.response != null) {
            return this.response.code();
        }
        return 0;
    }

    @Override
    public boolean isSuccessful() {
        if (this.response != null) {
            return this.response.isSuccessful();
        }
        return false;
    }

    @Override
    public Headers getHeaders() {
        if (this.response != null) {
            return this.response.headers();
        }
        return null;
    }

    @Override
    public HttpResult.Body getBody() {
        if (this.response != null) {
            return new ResultBody(this.response.body());
        }
        return null;
    }

    @Override
    public Exception getError() {
        return this.error;
    }

    public String toString() {
        HttpResult.Body body = this.getBody();
        String str = "HttpResult [\n  state: " + (Object)((Object)this.state) + ",\n  status: " + this.getStatus() + ",\n  headers: " + this.getHeaders();
        if (body != null) {
            str = str + ",\n  contentType: " + body.getContentType() + ",\n  body: " + body.toString();
        }
        return str + ",\n  error: " + this.error + "\n]";
    }
}

