/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.http.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.ejlchina.http.HttpResult;
import com.ejlchina.http.internal.HttpException;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import okhttp3.MediaType;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;

public class ResultBody
implements HttpResult.Body {
    private ResponseBody body;

    ResultBody(ResponseBody body) {
        this.body = body;
    }

    @Override
    public MediaType getContentType() {
        return this.body.contentType();
    }

    @Override
    public long getContentLength() {
        return this.body.contentLength();
    }

    @Override
    public InputStream toByteStream() {
        return this.body.byteStream();
    }

    @Override
    public byte[] toBytes() {
        try {
            return this.body.bytes();
        }
        catch (IOException e) {
            throw new HttpException("\u62a5\u6587\u4f53\u8f6c\u5316\u5b57\u8282\u6570\u7ec4\u51fa\u9519", e);
        }
    }

    @Override
    public Reader toCharStream() {
        return this.body.charStream();
    }

    @Override
    public String toString() {
        try {
            return this.body.string();
        }
        catch (IOException e) {
            throw new HttpException("\u62a5\u6587\u4f53\u8f6c\u5316\u5b57\u7b26\u4e32\u51fa\u9519", e);
        }
    }

    @Override
    public JSONObject toJsonObject() {
        return JSON.parseObject((String)this.toString());
    }

    @Override
    public JSONArray toJsonArray() {
        return JSON.parseArray((String)this.toString());
    }

    @Override
    public <T> T toBean(Class<T> type) {
        return (T)JSON.parseObject((String)this.toString(), type);
    }

    @Override
    public <T> T toBean(TypeReference<T> typeRef) {
        return (T)JSON.parseObject((String)this.toString(), (Type)typeRef.getType(), (Feature[])new Feature[0]);
    }

    @Override
    public File toFile(String filePath) {
        return this.toFile(new File(filePath));
    }

    @Override
    public File toFile(File file) {
        FileOutputStream output;
        if (file.exists() && !file.delete()) {
            throw new HttpException("Destination file [" + file.getAbsolutePath() + "] already exists and could not be deleted");
        }
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            throw new HttpException("Cannot create file [" + file.getAbsolutePath() + "]");
        }
        try {
            output = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new HttpException("\u65e0\u6cd5\u83b7\u53d6\u6587\u4ef6[" + file.getAbsolutePath() + "]\u7684\u8f93\u5165\u6d41", e);
        }
        InputStream input = this.body.byteStream();
        try {
            byte[] buff = new byte[1024];
            int len = -1;
            while ((len = input.read(buff)) != -1) {
                ((OutputStream)output).write(buff, 0, len);
            }
        }
        catch (IOException e) {
            throw new HttpException("\u6d41\u4f20\u8f93\u5931\u8d25", e);
        }
        finally {
            Util.closeQuietly((Closeable)output);
            this.body.close();
        }
        return file;
    }
}

