/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.http.internal;

import com.ejlchina.http.HttpResult;
import com.ejlchina.http.HttpTask;
import com.ejlchina.http.internal.HttpClient;
import com.ejlchina.http.internal.HttpException;
import com.ejlchina.http.internal.RealHttpResult;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.Response;

public class SyncHttpTask
extends HttpTask<SyncHttpTask> {
    public SyncHttpTask(HttpClient client, String urlPath) {
        super(client, urlPath);
    }

    public HttpResult get() {
        return this.request("GET");
    }

    public HttpResult post() {
        return this.request("POST");
    }

    public HttpResult put() {
        return this.request("PUT");
    }

    public HttpResult delete() {
        return this.request("DELETE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResult request(String method) {
        RealHttpResult result = new RealHttpResult();
        this.httpClient.preprocess(this, () -> {
            Call call = this.prepareCall(method);
            try {
                Response response = call.execute();
                SyncHttpTask syncHttpTask = this;
                synchronized (syncHttpTask) {
                    result.response(response);
                    this.notify();
                }
            }
            catch (IOException e) {
                HttpResult.State state = this.toState(e);
                SyncHttpTask syncHttpTask = this;
                synchronized (syncHttpTask) {
                    result.exception(state, e);
                    this.notify();
                }
            }
        });
        SyncHttpTask syncHttpTask = this;
        synchronized (syncHttpTask) {
            if (result.getState() == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new HttpException("\u7b49\u5f85\u5f02\u5e38", e);
                }
            }
        }
        Exception e = result.getError();
        if (e != null && result.getState() != HttpResult.State.CANCELED && !this.nothrow) {
            throw new HttpException("\u8bf7\u6c42\u6267\u884c\u5f02\u5e38", e);
        }
        return result;
    }
}

