/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client;

import com.espertech.esper.client.Configuration;
import com.espertech.esper.client.ConfigurationCacheReferenceType;
import com.espertech.esper.client.ConfigurationDBRef;
import com.espertech.esper.client.ConfigurationEngineDefaults;
import com.espertech.esper.client.ConfigurationEventTypeLegacy;
import com.espertech.esper.client.ConfigurationEventTypeMap;
import com.espertech.esper.client.ConfigurationEventTypeObjectArray;
import com.espertech.esper.client.ConfigurationEventTypeXMLDOM;
import com.espertech.esper.client.ConfigurationException;
import com.espertech.esper.client.ConfigurationMethodRef;
import com.espertech.esper.client.ConfigurationMetricsReporting;
import com.espertech.esper.client.ConfigurationPlugInAggregationMultiFunction;
import com.espertech.esper.client.ConfigurationPlugInSingleRowFunction;
import com.espertech.esper.client.ConfigurationRevisionEventType;
import com.espertech.esper.client.ConfigurationVariantStream;
import com.espertech.esper.client.EPException;
import com.espertech.esper.client.soda.StreamSelector;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.type.StringPatternSetLike;
import com.espertech.esper.type.StringPatternSetRegex;
import com.espertech.esper.util.DOMElementIterator;
import com.espertech.esper.util.JavaClassHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.math.MathContext;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class ConfigurationParser {
    private static Log log = LogFactory.getLog(ConfigurationParser.class);

    ConfigurationParser() {
    }

    protected static void doConfigure(Configuration configuration, InputStream stream, String resourceName) throws EPException {
        Document document = ConfigurationParser.getDocument(stream, resourceName);
        ConfigurationParser.doConfigure(configuration, document);
    }

    protected static Document getDocument(InputStream stream, String resourceName) throws EPException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(stream);
        }
        catch (ParserConfigurationException ex) {
            throw new EPException("Could not get a DOM parser configuration: " + resourceName, ex);
        }
        catch (SAXException ex) {
            throw new EPException("Could not parse configuration: " + resourceName, ex);
        }
        catch (IOException ex) {
            throw new EPException("Could not read configuration: " + resourceName, ex);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException ioe) {
                log.warn((Object)("could not close input stream for: " + resourceName), (Throwable)ioe);
            }
        }
        return document;
    }

    protected static void doConfigure(Configuration configuration, Document doc) throws EPException {
        Element root = doc.getDocumentElement();
        DOMElementIterator eventTypeNodeIterator = new DOMElementIterator(root.getChildNodes());
        while (eventTypeNodeIterator.hasNext()) {
            Element element = eventTypeNodeIterator.next();
            String nodeName = element.getNodeName();
            if (nodeName.equals("event-type-auto-name")) {
                ConfigurationParser.handleEventTypeAutoNames(configuration, element);
                continue;
            }
            if (nodeName.equals("event-type")) {
                ConfigurationParser.handleEventTypes(configuration, element);
                continue;
            }
            if (nodeName.equals("auto-import")) {
                ConfigurationParser.handleAutoImports(configuration, element);
                continue;
            }
            if (nodeName.equals("auto-import-annotations")) {
                ConfigurationParser.handleAutoImportAnnotations(configuration, element);
                continue;
            }
            if (nodeName.equals("method-reference")) {
                ConfigurationParser.handleMethodReference(configuration, element);
                continue;
            }
            if (nodeName.equals("database-reference")) {
                ConfigurationParser.handleDatabaseRefs(configuration, element);
                continue;
            }
            if (nodeName.equals("plugin-view")) {
                ConfigurationParser.handlePlugInView(configuration, element);
                continue;
            }
            if (nodeName.equals("plugin-virtualdw")) {
                ConfigurationParser.handlePlugInVirtualDW(configuration, element);
                continue;
            }
            if (nodeName.equals("plugin-aggregation-function")) {
                ConfigurationParser.handlePlugInAggregation(configuration, element);
                continue;
            }
            if (nodeName.equals("plugin-aggregation-multifunction")) {
                ConfigurationParser.handlePlugInMultiFunctionAggregation(configuration, element);
                continue;
            }
            if (nodeName.equals("plugin-singlerow-function")) {
                ConfigurationParser.handlePlugInSingleRow(configuration, element);
                continue;
            }
            if (nodeName.equals("plugin-pattern-guard")) {
                ConfigurationParser.handlePlugInPatternGuard(configuration, element);
                continue;
            }
            if (nodeName.equals("plugin-pattern-observer")) {
                ConfigurationParser.handlePlugInPatternObserver(configuration, element);
                continue;
            }
            if (nodeName.equals("variable")) {
                ConfigurationParser.handleVariable(configuration, element);
                continue;
            }
            if (nodeName.equals("plugin-loader")) {
                ConfigurationParser.handlePluginLoaders(configuration, element);
                continue;
            }
            if (nodeName.equals("engine-settings")) {
                ConfigurationParser.handleEngineSettings(configuration, element);
                continue;
            }
            if (nodeName.equals("plugin-event-representation")) {
                ConfigurationParser.handlePlugInEventRepresentation(configuration, element);
                continue;
            }
            if (nodeName.equals("plugin-event-type")) {
                ConfigurationParser.handlePlugInEventType(configuration, element);
                continue;
            }
            if (nodeName.equals("plugin-event-type-name-resolution")) {
                ConfigurationParser.handlePlugIneventTypeNameResolution(configuration, element);
                continue;
            }
            if (nodeName.equals("revision-event-type")) {
                ConfigurationParser.handleRevisionEventType(configuration, element);
                continue;
            }
            if (!nodeName.equals("variant-stream")) continue;
            ConfigurationParser.handleVariantStream(configuration, element);
        }
    }

    private static void handleEventTypeAutoNames(Configuration configuration, Element element) {
        String name = ConfigurationParser.getRequiredAttribute(element, "package-name");
        configuration.addEventTypeAutoName(name);
    }

    private static void handleEventTypes(Configuration configuration, Element element) {
        String name = ConfigurationParser.getRequiredAttribute(element, "name");
        Node classNode = element.getAttributes().getNamedItem("class");
        String optionalClassName = null;
        if (classNode != null) {
            optionalClassName = classNode.getTextContent();
            configuration.addEventType(name, optionalClassName);
        }
        ConfigurationParser.handleEventTypeDef(name, optionalClassName, configuration, element);
    }

    private static void handleEventTypeDef(String name, String optionalClassName, Configuration configuration, Node parentNode) {
        DOMElementIterator eventTypeNodeIterator = new DOMElementIterator(parentNode.getChildNodes());
        while (eventTypeNodeIterator.hasNext()) {
            Element eventTypeElement = eventTypeNodeIterator.next();
            String nodeName = eventTypeElement.getNodeName();
            if (nodeName.equals("xml-dom")) {
                ConfigurationParser.handleXMLDOM(name, configuration, eventTypeElement);
                continue;
            }
            if (nodeName.equals("java-util-map")) {
                ConfigurationParser.handleMap(name, configuration, eventTypeElement);
                continue;
            }
            if (nodeName.equals("objectarray")) {
                ConfigurationParser.handleObjectArray(name, configuration, eventTypeElement);
                continue;
            }
            if (!nodeName.equals("legacy-type")) continue;
            ConfigurationParser.handleLegacy(name, optionalClassName, configuration, eventTypeElement);
        }
    }

    private static void handleMap(String name, Configuration configuration, Element eventTypeElement) {
        String startTimestampProp = ConfigurationParser.getOptionalAttribute(eventTypeElement, "start-timestamp-property-name");
        String endTimestampProp = ConfigurationParser.getOptionalAttribute(eventTypeElement, "end-timestamp-property-name");
        Node superTypesList = eventTypeElement.getAttributes().getNamedItem("supertype-names");
        if (superTypesList != null || startTimestampProp != null || endTimestampProp != null) {
            ConfigurationEventTypeMap config = new ConfigurationEventTypeMap();
            if (superTypesList != null) {
                String[] names;
                String value = superTypesList.getTextContent();
                for (String superTypeName : names = value.split(",")) {
                    config.getSuperTypes().add(superTypeName.trim());
                }
            }
            config.setEndTimestampPropertyName(endTimestampProp);
            config.setStartTimestampPropertyName(startTimestampProp);
            configuration.addMapConfiguration(name, config);
        }
        Properties propertyTypeNames = new Properties();
        NodeList propertyList = eventTypeElement.getElementsByTagName("map-property");
        for (int i = 0; i < propertyList.getLength(); ++i) {
            String nameProperty = ConfigurationParser.getRequiredAttribute(propertyList.item(i), "name");
            String clazz = ConfigurationParser.getRequiredAttribute(propertyList.item(i), "class");
            propertyTypeNames.put(nameProperty, clazz);
        }
        configuration.addEventType(name, propertyTypeNames);
    }

    private static void handleObjectArray(String name, Configuration configuration, Element eventTypeElement) {
        String startTimestampProp = ConfigurationParser.getOptionalAttribute(eventTypeElement, "start-timestamp-property-name");
        String endTimestampProp = ConfigurationParser.getOptionalAttribute(eventTypeElement, "end-timestamp-property-name");
        Node superTypesList = eventTypeElement.getAttributes().getNamedItem("supertype-names");
        if (superTypesList != null || startTimestampProp != null || endTimestampProp != null) {
            ConfigurationEventTypeObjectArray config = new ConfigurationEventTypeObjectArray();
            if (superTypesList != null) {
                String[] names;
                String value = superTypesList.getTextContent();
                for (String superTypeName : names = value.split(",")) {
                    config.getSuperTypes().add(superTypeName.trim());
                }
            }
            config.setEndTimestampPropertyName(endTimestampProp);
            config.setStartTimestampPropertyName(startTimestampProp);
            configuration.addObjectArrayConfiguration(name, config);
        }
        ArrayList<String> propertyNames = new ArrayList<String>();
        ArrayList<String> propertyTypes = new ArrayList<String>();
        NodeList propertyList = eventTypeElement.getElementsByTagName("objectarray-property");
        for (int i = 0; i < propertyList.getLength(); ++i) {
            String nameProperty = ConfigurationParser.getRequiredAttribute(propertyList.item(i), "name");
            String clazz = ConfigurationParser.getRequiredAttribute(propertyList.item(i), "class");
            propertyNames.add(nameProperty);
            propertyTypes.add(clazz);
        }
        configuration.addEventType(name, propertyNames.toArray(new String[propertyNames.size()]), propertyTypes.toArray());
    }

    private static void handleXMLDOM(String name, Configuration configuration, Element xmldomElement) {
        String rootElementName = ConfigurationParser.getRequiredAttribute(xmldomElement, "root-element-name");
        String rootElementNamespace = ConfigurationParser.getOptionalAttribute(xmldomElement, "root-element-namespace");
        String schemaResource = ConfigurationParser.getOptionalAttribute(xmldomElement, "schema-resource");
        String schemaText = ConfigurationParser.getOptionalAttribute(xmldomElement, "schema-text");
        String defaultNamespace = ConfigurationParser.getOptionalAttribute(xmldomElement, "default-namespace");
        String resolvePropertiesAbsoluteStr = ConfigurationParser.getOptionalAttribute(xmldomElement, "xpath-resolve-properties-absolute");
        String propertyExprXPathStr = ConfigurationParser.getOptionalAttribute(xmldomElement, "xpath-property-expr");
        String eventSenderChecksRootStr = ConfigurationParser.getOptionalAttribute(xmldomElement, "event-sender-validates-root");
        String xpathFunctionResolverClass = ConfigurationParser.getOptionalAttribute(xmldomElement, "xpath-function-resolver");
        String xpathVariableResolverClass = ConfigurationParser.getOptionalAttribute(xmldomElement, "xpath-variable-resolver");
        String autoFragmentStr = ConfigurationParser.getOptionalAttribute(xmldomElement, "auto-fragment");
        String startTimestampProperty = ConfigurationParser.getOptionalAttribute(xmldomElement, "start-timestamp-property-name");
        String endTimestampProperty = ConfigurationParser.getOptionalAttribute(xmldomElement, "end-timestamp-property-name");
        ConfigurationEventTypeXMLDOM xmlDOMEventTypeDesc = new ConfigurationEventTypeXMLDOM();
        xmlDOMEventTypeDesc.setRootElementName(rootElementName);
        xmlDOMEventTypeDesc.setSchemaResource(schemaResource);
        xmlDOMEventTypeDesc.setSchemaText(schemaText);
        xmlDOMEventTypeDesc.setRootElementNamespace(rootElementNamespace);
        xmlDOMEventTypeDesc.setDefaultNamespace(defaultNamespace);
        xmlDOMEventTypeDesc.setXPathFunctionResolver(xpathFunctionResolverClass);
        xmlDOMEventTypeDesc.setXPathVariableResolver(xpathVariableResolverClass);
        xmlDOMEventTypeDesc.setStartTimestampPropertyName(startTimestampProperty);
        xmlDOMEventTypeDesc.setEndTimestampPropertyName(endTimestampProperty);
        if (resolvePropertiesAbsoluteStr != null) {
            xmlDOMEventTypeDesc.setXPathResolvePropertiesAbsolute(Boolean.parseBoolean(resolvePropertiesAbsoluteStr));
        }
        if (propertyExprXPathStr != null) {
            xmlDOMEventTypeDesc.setXPathPropertyExpr(Boolean.parseBoolean(propertyExprXPathStr));
        }
        if (eventSenderChecksRootStr != null) {
            xmlDOMEventTypeDesc.setEventSenderValidatesRoot(Boolean.parseBoolean(eventSenderChecksRootStr));
        }
        if (autoFragmentStr != null) {
            xmlDOMEventTypeDesc.setAutoFragment(Boolean.parseBoolean(autoFragmentStr));
        }
        configuration.addEventType(name, xmlDOMEventTypeDesc);
        DOMElementIterator propertyNodeIterator = new DOMElementIterator(xmldomElement.getChildNodes());
        while (propertyNodeIterator.hasNext()) {
            QName xpathConstantType;
            Element propertyElement = propertyNodeIterator.next();
            if (propertyElement.getNodeName().equals("namespace-prefix")) {
                String prefix = ConfigurationParser.getRequiredAttribute(propertyElement, "prefix");
                String namespace = ConfigurationParser.getRequiredAttribute(propertyElement, "namespace");
                xmlDOMEventTypeDesc.addNamespacePrefix(prefix, namespace);
            }
            if (!propertyElement.getNodeName().equals("xpath-property")) continue;
            String propertyName = ConfigurationParser.getRequiredAttribute(propertyElement, "property-name");
            String xPath = ConfigurationParser.getRequiredAttribute(propertyElement, "xpath");
            String propertyType = ConfigurationParser.getRequiredAttribute(propertyElement, "type");
            if (propertyType.toUpperCase().equals("NUMBER")) {
                xpathConstantType = XPathConstants.NUMBER;
            } else if (propertyType.toUpperCase().equals("STRING")) {
                xpathConstantType = XPathConstants.STRING;
            } else if (propertyType.toUpperCase().equals("BOOLEAN")) {
                xpathConstantType = XPathConstants.BOOLEAN;
            } else if (propertyType.toUpperCase().equals("NODE")) {
                xpathConstantType = XPathConstants.NODE;
            } else if (propertyType.toUpperCase().equals("NODESET")) {
                xpathConstantType = XPathConstants.NODESET;
            } else {
                throw new IllegalArgumentException("Invalid xpath property type for property '" + propertyName + "' and type '" + propertyType + '\'');
            }
            String castToClass = null;
            if (propertyElement.getAttributes().getNamedItem("cast") != null) {
                castToClass = propertyElement.getAttributes().getNamedItem("cast").getTextContent();
            }
            String optionaleventTypeName = null;
            if (propertyElement.getAttributes().getNamedItem("event-type-name") != null) {
                optionaleventTypeName = propertyElement.getAttributes().getNamedItem("event-type-name").getTextContent();
            }
            if (optionaleventTypeName != null) {
                xmlDOMEventTypeDesc.addXPathPropertyFragment(propertyName, xPath, xpathConstantType, optionaleventTypeName);
                continue;
            }
            xmlDOMEventTypeDesc.addXPathProperty(propertyName, xPath, xpathConstantType, castToClass);
        }
    }

    private static void handleLegacy(String name, String className, Configuration configuration, Element xmldomElement) {
        if (className == null) {
            throw new ConfigurationException("Required class name not supplied for legacy type definition");
        }
        String accessorStyle = ConfigurationParser.getRequiredAttribute(xmldomElement, "accessor-style");
        String codeGeneration = ConfigurationParser.getRequiredAttribute(xmldomElement, "code-generation");
        String propertyResolution = ConfigurationParser.getRequiredAttribute(xmldomElement, "property-resolution-style");
        String factoryMethod = ConfigurationParser.getOptionalAttribute(xmldomElement, "factory-method");
        String copyMethod = ConfigurationParser.getOptionalAttribute(xmldomElement, "copy-method");
        String startTimestampProp = ConfigurationParser.getOptionalAttribute(xmldomElement, "start-timestamp-property-name");
        String endTimestampProp = ConfigurationParser.getOptionalAttribute(xmldomElement, "end-timestamp-property-name");
        ConfigurationEventTypeLegacy legacyDesc = new ConfigurationEventTypeLegacy();
        if (accessorStyle != null) {
            legacyDesc.setAccessorStyle(ConfigurationEventTypeLegacy.AccessorStyle.valueOf(accessorStyle.toUpperCase()));
        }
        if (codeGeneration != null) {
            legacyDesc.setCodeGeneration(ConfigurationEventTypeLegacy.CodeGeneration.valueOf(codeGeneration.toUpperCase()));
        }
        if (propertyResolution != null) {
            legacyDesc.setPropertyResolutionStyle(Configuration.PropertyResolutionStyle.valueOf(propertyResolution.toUpperCase()));
        }
        legacyDesc.setFactoryMethod(factoryMethod);
        legacyDesc.setCopyMethod(copyMethod);
        legacyDesc.setStartTimestampPropertyName(startTimestampProp);
        legacyDesc.setEndTimestampPropertyName(endTimestampProp);
        configuration.addEventType(name, className, legacyDesc);
        DOMElementIterator propertyNodeIterator = new DOMElementIterator(xmldomElement.getChildNodes());
        while (propertyNodeIterator.hasNext()) {
            String nameProperty;
            Element propertyElement = propertyNodeIterator.next();
            if (propertyElement.getNodeName().equals("method-property")) {
                nameProperty = ConfigurationParser.getRequiredAttribute(propertyElement, "name");
                String method = ConfigurationParser.getRequiredAttribute(propertyElement, "accessor-method");
                legacyDesc.addMethodProperty(nameProperty, method);
                continue;
            }
            if (propertyElement.getNodeName().equals("field-property")) {
                nameProperty = ConfigurationParser.getRequiredAttribute(propertyElement, "name");
                String field = ConfigurationParser.getRequiredAttribute(propertyElement, "accessor-field");
                legacyDesc.addFieldProperty(nameProperty, field);
                continue;
            }
            throw new ConfigurationException("Invalid node " + propertyElement.getNodeName() + " encountered while parsing legacy type definition");
        }
    }

    private static void handleAutoImports(Configuration configuration, Element element) {
        String name = ConfigurationParser.getRequiredAttribute(element, "import-name");
        configuration.addImport(name);
    }

    private static void handleAutoImportAnnotations(Configuration configuration, Element element) {
        String name = ConfigurationParser.getRequiredAttribute(element, "import-name");
        configuration.addAnnotationImport(name);
    }

    private static void handleDatabaseRefs(Configuration configuration, Element element) {
        String name = ConfigurationParser.getRequiredAttribute(element, "name");
        ConfigurationDBRef configDBRef = new ConfigurationDBRef();
        configuration.addDatabaseReference(name, configDBRef);
        DOMElementIterator nodeIterator = new DOMElementIterator(element.getChildNodes());
        while (nodeIterator.hasNext()) {
            Enum parsed;
            String value;
            String className;
            Properties properties;
            Element subElement = nodeIterator.next();
            if (subElement.getNodeName().equals("datasource-connection")) {
                String lookup = ConfigurationParser.getRequiredAttribute(subElement, "context-lookup-name");
                properties = ConfigurationParser.handleProperties(subElement, "env-property");
                configDBRef.setDataSourceConnection(lookup, properties);
            }
            if (subElement.getNodeName().equals("datasourcefactory-connection")) {
                className = ConfigurationParser.getRequiredAttribute(subElement, "class-name");
                properties = ConfigurationParser.handleProperties(subElement, "env-property");
                configDBRef.setDataSourceFactory(properties, className);
                continue;
            }
            if (subElement.getNodeName().equals("drivermanager-connection")) {
                className = ConfigurationParser.getRequiredAttribute(subElement, "class-name");
                String url = ConfigurationParser.getRequiredAttribute(subElement, "url");
                String userName = ConfigurationParser.getRequiredAttribute(subElement, "user");
                String password = ConfigurationParser.getRequiredAttribute(subElement, "password");
                Properties properties2 = ConfigurationParser.handleProperties(subElement, "connection-arg");
                configDBRef.setDriverManagerConnection(className, url, userName, password, properties2);
                continue;
            }
            if (subElement.getNodeName().equals("connection-lifecycle")) {
                value = ConfigurationParser.getRequiredAttribute(subElement, "value");
                configDBRef.setConnectionLifecycleEnum(ConfigurationDBRef.ConnectionLifecycleEnum.valueOf(value.toUpperCase()));
                continue;
            }
            if (subElement.getNodeName().equals("connection-settings")) {
                if (subElement.getAttributes().getNamedItem("auto-commit") != null) {
                    String autoCommit = subElement.getAttributes().getNamedItem("auto-commit").getTextContent();
                    configDBRef.setConnectionAutoCommit(Boolean.parseBoolean(autoCommit));
                }
                if (subElement.getAttributes().getNamedItem("transaction-isolation") != null) {
                    String transactionIsolation = subElement.getAttributes().getNamedItem("transaction-isolation").getTextContent();
                    configDBRef.setConnectionTransactionIsolation(Integer.parseInt(transactionIsolation));
                }
                if (subElement.getAttributes().getNamedItem("catalog") != null) {
                    String catalog = subElement.getAttributes().getNamedItem("catalog").getTextContent();
                    configDBRef.setConnectionCatalog(catalog);
                }
                if (subElement.getAttributes().getNamedItem("read-only") == null) continue;
                String readOnly = subElement.getAttributes().getNamedItem("read-only").getTextContent();
                configDBRef.setConnectionReadOnly(Boolean.parseBoolean(readOnly));
                continue;
            }
            if (subElement.getNodeName().equals("column-change-case")) {
                value = ConfigurationParser.getRequiredAttribute(subElement, "value");
                parsed = ConfigurationDBRef.ColumnChangeCaseEnum.valueOf(value.toUpperCase());
                configDBRef.setColumnChangeCase((ConfigurationDBRef.ColumnChangeCaseEnum)parsed);
                continue;
            }
            if (subElement.getNodeName().equals("metadata-origin")) {
                value = ConfigurationParser.getRequiredAttribute(subElement, "value");
                parsed = ConfigurationDBRef.MetadataOriginEnum.valueOf(value.toUpperCase());
                configDBRef.setMetadataOrigin((ConfigurationDBRef.MetadataOriginEnum)parsed);
                continue;
            }
            if (subElement.getNodeName().equals("sql-types-mapping")) {
                Integer sqlTypeInt;
                String sqlType = ConfigurationParser.getRequiredAttribute(subElement, "sql-type");
                String javaType = ConfigurationParser.getRequiredAttribute(subElement, "java-type");
                try {
                    sqlTypeInt = Integer.parseInt(sqlType);
                }
                catch (NumberFormatException ex) {
                    throw new ConfigurationException("Error converting sql type '" + sqlType + "' to integer java.sql.Types constant");
                }
                configDBRef.addSqlTypesBinding((int)sqlTypeInt, javaType);
                continue;
            }
            if (subElement.getNodeName().equals("expiry-time-cache")) {
                String maxAge = ConfigurationParser.getRequiredAttribute(subElement, "max-age-seconds");
                String purgeInterval = ConfigurationParser.getRequiredAttribute(subElement, "purge-interval-seconds");
                ConfigurationCacheReferenceType refTypeEnum = ConfigurationCacheReferenceType.getDefault();
                if (subElement.getAttributes().getNamedItem("ref-type") != null) {
                    String refType = subElement.getAttributes().getNamedItem("ref-type").getTextContent();
                    refTypeEnum = ConfigurationCacheReferenceType.valueOf(refType.toUpperCase());
                }
                configDBRef.setExpiryTimeCache(Double.parseDouble(maxAge), Double.parseDouble(purgeInterval), refTypeEnum);
                continue;
            }
            if (!subElement.getNodeName().equals("lru-cache")) continue;
            String size = ConfigurationParser.getRequiredAttribute(subElement, "size");
            configDBRef.setLRUCache(Integer.parseInt(size));
        }
    }

    private static void handleMethodReference(Configuration configuration, Element element) {
        String className = ConfigurationParser.getRequiredAttribute(element, "class-name");
        ConfigurationMethodRef configMethodRef = new ConfigurationMethodRef();
        configuration.addMethodRef(className, configMethodRef);
        DOMElementIterator nodeIterator = new DOMElementIterator(element.getChildNodes());
        while (nodeIterator.hasNext()) {
            Element subElement = nodeIterator.next();
            if (subElement.getNodeName().equals("expiry-time-cache")) {
                String maxAge = ConfigurationParser.getRequiredAttribute(subElement, "max-age-seconds");
                String purgeInterval = ConfigurationParser.getRequiredAttribute(subElement, "purge-interval-seconds");
                ConfigurationCacheReferenceType refTypeEnum = ConfigurationCacheReferenceType.getDefault();
                if (subElement.getAttributes().getNamedItem("ref-type") != null) {
                    String refType = subElement.getAttributes().getNamedItem("ref-type").getTextContent();
                    refTypeEnum = ConfigurationCacheReferenceType.valueOf(refType.toUpperCase());
                }
                configMethodRef.setExpiryTimeCache(Double.parseDouble(maxAge), Double.parseDouble(purgeInterval), refTypeEnum);
                continue;
            }
            if (!subElement.getNodeName().equals("lru-cache")) continue;
            String size = ConfigurationParser.getRequiredAttribute(subElement, "size");
            configMethodRef.setLRUCache(Integer.parseInt(size));
        }
    }

    private static void handlePlugInView(Configuration configuration, Element element) {
        String namespace = ConfigurationParser.getRequiredAttribute(element, "namespace");
        String name = ConfigurationParser.getRequiredAttribute(element, "name");
        String factoryClassName = ConfigurationParser.getRequiredAttribute(element, "factory-class");
        configuration.addPlugInView(namespace, name, factoryClassName);
    }

    private static void handlePlugInVirtualDW(Configuration configuration, Element element) {
        String namespace = ConfigurationParser.getRequiredAttribute(element, "namespace");
        String name = ConfigurationParser.getRequiredAttribute(element, "name");
        String factoryClassName = ConfigurationParser.getRequiredAttribute(element, "factory-class");
        String config = ConfigurationParser.getOptionalAttribute(element, "config");
        configuration.addPlugInVirtualDataWindow(namespace, name, factoryClassName, (Serializable)((Object)config));
    }

    private static void handlePlugInAggregation(Configuration configuration, Element element) {
        String name = ConfigurationParser.getRequiredAttribute(element, "name");
        String factoryClassName = ConfigurationParser.getRequiredAttribute(element, "factory-class");
        configuration.addPlugInAggregationFunctionFactory(name, factoryClassName);
    }

    private static void handlePlugInMultiFunctionAggregation(Configuration configuration, Element element) {
        String functionNames = ConfigurationParser.getRequiredAttribute(element, "function-names");
        String factoryClassName = ConfigurationParser.getOptionalAttribute(element, "factory-class");
        DOMElementIterator nodeIterator = new DOMElementIterator(element.getChildNodes());
        HashMap<String, String> additionalProps = null;
        while (nodeIterator.hasNext()) {
            Element subElement = nodeIterator.next();
            if (!subElement.getNodeName().equals("init-arg")) continue;
            String name = ConfigurationParser.getRequiredAttribute(subElement, "name");
            String value = ConfigurationParser.getRequiredAttribute(subElement, "value");
            if (additionalProps == null) {
                additionalProps = new HashMap<String, String>();
            }
            additionalProps.put(name, value);
        }
        ConfigurationPlugInAggregationMultiFunction config = new ConfigurationPlugInAggregationMultiFunction(functionNames.split(","), factoryClassName);
        config.setAdditionalConfiguredProperties(additionalProps);
        configuration.addPlugInAggregationMultiFunction(config);
    }

    private static void handlePlugInSingleRow(Configuration configuration, Element element) {
        String filterOptimizableStr;
        String name = element.getAttributes().getNamedItem("name").getTextContent();
        String functionClassName = element.getAttributes().getNamedItem("function-class").getTextContent();
        String functionMethodName = element.getAttributes().getNamedItem("function-method").getTextContent();
        ConfigurationPlugInSingleRowFunction.ValueCache valueCache = ConfigurationPlugInSingleRowFunction.ValueCache.DISABLED;
        ConfigurationPlugInSingleRowFunction.FilterOptimizable filterOptimizable = ConfigurationPlugInSingleRowFunction.FilterOptimizable.ENABLED;
        String valueCacheStr = ConfigurationParser.getOptionalAttribute(element, "value-cache");
        if (valueCacheStr != null) {
            valueCache = ConfigurationPlugInSingleRowFunction.ValueCache.valueOf(valueCacheStr.toUpperCase());
        }
        if ((filterOptimizableStr = ConfigurationParser.getOptionalAttribute(element, "filter-optimizable")) != null) {
            filterOptimizable = ConfigurationPlugInSingleRowFunction.FilterOptimizable.valueOf(filterOptimizableStr.toUpperCase());
        }
        String rethrowExceptionsStr = ConfigurationParser.getOptionalAttribute(element, "rethrow-exceptions");
        boolean rethrowExceptions = false;
        if (rethrowExceptionsStr != null) {
            rethrowExceptions = Boolean.parseBoolean(rethrowExceptionsStr);
        }
        configuration.addPlugInSingleRowFunction(name, functionClassName, functionMethodName, valueCache, filterOptimizable, rethrowExceptions);
    }

    private static void handlePlugInPatternGuard(Configuration configuration, Element element) {
        String namespace = ConfigurationParser.getRequiredAttribute(element, "namespace");
        String name = ConfigurationParser.getRequiredAttribute(element, "name");
        String factoryClassName = ConfigurationParser.getRequiredAttribute(element, "factory-class");
        configuration.addPlugInPatternGuard(namespace, name, factoryClassName);
    }

    private static void handlePlugInPatternObserver(Configuration configuration, Element element) {
        String namespace = ConfigurationParser.getRequiredAttribute(element, "namespace");
        String name = ConfigurationParser.getRequiredAttribute(element, "name");
        String factoryClassName = ConfigurationParser.getRequiredAttribute(element, "factory-class");
        configuration.addPlugInPatternObserver(namespace, name, factoryClassName);
    }

    private static void handleVariable(Configuration configuration, Element element) {
        String variableName = ConfigurationParser.getRequiredAttribute(element, "name");
        String type = ConfigurationParser.getRequiredAttribute(element, "type");
        Class variableType = JavaClassHelper.getClassForSimpleName(type);
        if (variableType == null) {
            throw new ConfigurationException("Invalid variable type for variable '" + variableName + "', the type is not recognized");
        }
        Node initValueNode = element.getAttributes().getNamedItem("initialization-value");
        String initValue = null;
        if (initValueNode != null) {
            initValue = initValueNode.getTextContent();
        }
        boolean isConstant = false;
        if (ConfigurationParser.getOptionalAttribute(element, "constant") != null) {
            isConstant = Boolean.parseBoolean(ConfigurationParser.getOptionalAttribute(element, "constant"));
        }
        configuration.addVariable(variableName, variableType, (Object)initValue, isConstant);
    }

    private static void handlePluginLoaders(Configuration configuration, Element element) {
        String loaderName = ConfigurationParser.getRequiredAttribute(element, "name");
        String className = ConfigurationParser.getRequiredAttribute(element, "class-name");
        Properties properties = new Properties();
        String configXML = null;
        DOMElementIterator nodeIterator = new DOMElementIterator(element.getChildNodes());
        while (nodeIterator.hasNext()) {
            Element subElement = nodeIterator.next();
            if (subElement.getNodeName().equals("init-arg")) {
                String name = ConfigurationParser.getRequiredAttribute(subElement, "name");
                String value = ConfigurationParser.getRequiredAttribute(subElement, "value");
                properties.put(name, value);
            }
            if (!subElement.getNodeName().equals("config-xml")) continue;
            DOMElementIterator nodeIter = new DOMElementIterator(subElement.getChildNodes());
            if (!nodeIter.hasNext()) {
                throw new ConfigurationException("Error handling config-xml for plug-in loader '" + loaderName + "', no child node found under initializer element, expecting an element node");
            }
            StringWriter output = new StringWriter();
            try {
                TransformerFactory.newInstance().newTransformer().transform(new DOMSource(nodeIter.next()), new StreamResult(output));
            }
            catch (TransformerException e) {
                throw new ConfigurationException("Error handling config-xml for plug-in loader '" + loaderName + "' :" + e.getMessage(), e);
            }
            configXML = output.toString();
        }
        configuration.addPluginLoader(loaderName, className, properties, configXML);
    }

    private static void handlePlugInEventRepresentation(Configuration configuration, Element element) {
        URI uriParsed;
        DOMElementIterator nodeIterator = new DOMElementIterator(element.getChildNodes());
        String uri = ConfigurationParser.getRequiredAttribute(element, "uri");
        String className = ConfigurationParser.getRequiredAttribute(element, "class-name");
        String initializer = null;
        while (nodeIterator.hasNext()) {
            Element subElement = nodeIterator.next();
            if (!subElement.getNodeName().equals("initializer")) continue;
            DOMElementIterator nodeIter = new DOMElementIterator(subElement.getChildNodes());
            if (!nodeIter.hasNext()) {
                throw new ConfigurationException("Error handling initializer for plug-in event representation '" + uri + "', no child node found under initializer element, expecting an element node");
            }
            StringWriter output = new StringWriter();
            try {
                TransformerFactory.newInstance().newTransformer().transform(new DOMSource(nodeIter.next()), new StreamResult(output));
            }
            catch (TransformerException e) {
                throw new ConfigurationException("Error handling initializer for plug-in event representation '" + uri + "' :" + e.getMessage(), e);
            }
            initializer = output.toString();
        }
        try {
            uriParsed = new URI(uri);
        }
        catch (URISyntaxException ex) {
            throw new ConfigurationException("Error parsing URI '" + uri + "' as a valid java.net.URI string:" + ex.getMessage(), ex);
        }
        configuration.addPlugInEventRepresentation(uriParsed, className, (Serializable)((Object)initializer));
    }

    private static void handlePlugInEventType(Configuration configuration, Element element) {
        DOMElementIterator nodeIterator = new DOMElementIterator(element.getChildNodes());
        ArrayList<URI> uris = new ArrayList<URI>();
        String name = ConfigurationParser.getRequiredAttribute(element, "name");
        String initializer = null;
        while (nodeIterator.hasNext()) {
            Element subElement = nodeIterator.next();
            if (subElement.getNodeName().equals("resolution-uri")) {
                URI uri;
                String uriValue = ConfigurationParser.getRequiredAttribute(subElement, "value");
                try {
                    uri = new URI(uriValue);
                }
                catch (URISyntaxException ex) {
                    throw new ConfigurationException("Error parsing URI '" + uriValue + "' as a valid java.net.URI string:" + ex.getMessage(), ex);
                }
                uris.add(uri);
            }
            if (!subElement.getNodeName().equals("initializer")) continue;
            DOMElementIterator nodeIter = new DOMElementIterator(subElement.getChildNodes());
            if (!nodeIter.hasNext()) {
                throw new ConfigurationException("Error handling initializer for plug-in event type '" + name + "', no child node found under initializer element, expecting an element node");
            }
            StringWriter output = new StringWriter();
            try {
                TransformerFactory.newInstance().newTransformer().transform(new DOMSource(nodeIter.next()), new StreamResult(output));
            }
            catch (TransformerException e) {
                throw new ConfigurationException("Error handling initializer for plug-in event type '" + name + "' :" + e.getMessage(), e);
            }
            initializer = output.toString();
        }
        configuration.addPlugInEventType(name, uris.toArray(new URI[uris.size()]), (Serializable)((Object)initializer));
    }

    private static void handlePlugIneventTypeNameResolution(Configuration configuration, Element element) {
        DOMElementIterator nodeIterator = new DOMElementIterator(element.getChildNodes());
        ArrayList<URI> uris = new ArrayList<URI>();
        while (nodeIterator.hasNext()) {
            URI uri;
            Element subElement = nodeIterator.next();
            if (!subElement.getNodeName().equals("resolution-uri")) continue;
            String uriValue = ConfigurationParser.getRequiredAttribute(subElement, "value");
            try {
                uri = new URI(uriValue);
            }
            catch (URISyntaxException ex) {
                throw new ConfigurationException("Error parsing URI '" + uriValue + "' as a valid java.net.URI string:" + ex.getMessage(), ex);
            }
            uris.add(uri);
        }
        configuration.setPlugInEventTypeResolutionURIs(uris.toArray(new URI[uris.size()]));
    }

    private static void handleRevisionEventType(Configuration configuration, Element element) {
        ConfigurationRevisionEventType revEventType = new ConfigurationRevisionEventType();
        String revTypeName = ConfigurationParser.getRequiredAttribute(element, "name");
        if (element.getAttributes().getNamedItem("property-revision") != null) {
            String propertyRevision = element.getAttributes().getNamedItem("property-revision").getTextContent();
            try {
                ConfigurationRevisionEventType.PropertyRevision propertyRevisionEnum = ConfigurationRevisionEventType.PropertyRevision.valueOf(propertyRevision.trim().toUpperCase());
                revEventType.setPropertyRevision(propertyRevisionEnum);
            }
            catch (RuntimeException ex) {
                throw new ConfigurationException("Invalid enumeration value for property-revision attribute '" + propertyRevision + "'");
            }
        }
        DOMElementIterator nodeIterator = new DOMElementIterator(element.getChildNodes());
        HashSet<String> keyProperties = new HashSet<String>();
        while (nodeIterator.hasNext()) {
            String name;
            Element subElement = nodeIterator.next();
            if (subElement.getNodeName().equals("base-event-type")) {
                name = ConfigurationParser.getRequiredAttribute(subElement, "name");
                revEventType.addNameBaseEventType(name);
            }
            if (subElement.getNodeName().equals("delta-event-type")) {
                name = ConfigurationParser.getRequiredAttribute(subElement, "name");
                revEventType.addNameDeltaEventType(name);
            }
            if (!subElement.getNodeName().equals("key-property")) continue;
            name = ConfigurationParser.getRequiredAttribute(subElement, "name");
            keyProperties.add(name);
        }
        String[] keyProps = keyProperties.toArray(new String[keyProperties.size()]);
        revEventType.setKeyPropertyNames(keyProps);
        configuration.addRevisionEventType(revTypeName, revEventType);
    }

    private static void handleVariantStream(Configuration configuration, Element element) {
        ConfigurationVariantStream variantStream = new ConfigurationVariantStream();
        String varianceName = ConfigurationParser.getRequiredAttribute(element, "name");
        if (element.getAttributes().getNamedItem("type-variance") != null) {
            String typeVar = element.getAttributes().getNamedItem("type-variance").getTextContent();
            try {
                ConfigurationVariantStream.TypeVariance typeVarianceEnum = ConfigurationVariantStream.TypeVariance.valueOf(typeVar.trim().toUpperCase());
                variantStream.setTypeVariance(typeVarianceEnum);
            }
            catch (RuntimeException ex) {
                throw new ConfigurationException("Invalid enumeration value for type-variance attribute '" + typeVar + "'");
            }
        }
        DOMElementIterator nodeIterator = new DOMElementIterator(element.getChildNodes());
        while (nodeIterator.hasNext()) {
            Element subElement = nodeIterator.next();
            if (!subElement.getNodeName().equals("variant-event-type")) continue;
            String name = subElement.getAttributes().getNamedItem("name").getTextContent();
            variantStream.addEventTypeName(name);
        }
        configuration.addVariantStream(varianceName, variantStream);
    }

    private static void handleEngineSettings(Configuration configuration, Element element) {
        DOMElementIterator nodeIterator = new DOMElementIterator(element.getChildNodes());
        while (nodeIterator.hasNext()) {
            Element subElement = nodeIterator.next();
            if (!subElement.getNodeName().equals("defaults")) continue;
            ConfigurationParser.handleEngineSettingsDefaults(configuration, subElement);
        }
    }

    private static void handleEngineSettingsDefaults(Configuration configuration, Element parentElement) {
        DOMElementIterator nodeIterator = new DOMElementIterator(parentElement.getChildNodes());
        while (nodeIterator.hasNext()) {
            Element subElement = nodeIterator.next();
            if (subElement.getNodeName().equals("threading")) {
                ConfigurationParser.handleDefaultsThreading(configuration, subElement);
            }
            if (subElement.getNodeName().equals("event-meta")) {
                ConfigurationParser.handleDefaultsEventMeta(configuration, subElement);
            }
            if (subElement.getNodeName().equals("view-resources")) {
                ConfigurationParser.handleDefaultsViewResources(configuration, subElement);
            }
            if (subElement.getNodeName().equals("logging")) {
                ConfigurationParser.handleDefaultsLogging(configuration, subElement);
            }
            if (subElement.getNodeName().equals("variables")) {
                ConfigurationParser.handleDefaultsVariables(configuration, subElement);
            }
            if (subElement.getNodeName().equals("patterns")) {
                ConfigurationParser.handleDefaultsPatterns(configuration, subElement);
            }
            if (subElement.getNodeName().equals("match-recognize")) {
                ConfigurationParser.handleDefaultsMatchRecognize(configuration, subElement);
            }
            if (subElement.getNodeName().equals("stream-selection")) {
                ConfigurationParser.handleDefaultsStreamSelection(configuration, subElement);
            }
            if (subElement.getNodeName().equals("time-source")) {
                ConfigurationParser.handleDefaultsTimeSource(configuration, subElement);
            }
            if (subElement.getNodeName().equals("metrics-reporting")) {
                ConfigurationParser.handleMetricsReporting(configuration, subElement);
            }
            if (subElement.getNodeName().equals("language")) {
                ConfigurationParser.handleLanguage(configuration, subElement);
            }
            if (subElement.getNodeName().equals("expression")) {
                ConfigurationParser.handleExpression(configuration, subElement);
            }
            if (subElement.getNodeName().equals("execution")) {
                ConfigurationParser.handleExecution(configuration, subElement);
            }
            if (subElement.getNodeName().equals("exceptionHandling")) {
                configuration.getEngineDefaults().getExceptionHandling().addClasses(ConfigurationParser.getHandlerFactories(subElement));
                String enableUndeployRethrowStr = ConfigurationParser.getOptionalAttribute(subElement, "undeploy-rethrow-policy");
                if (enableUndeployRethrowStr != null) {
                    configuration.getEngineDefaults().getExceptionHandling().setUndeployRethrowPolicy(ConfigurationEngineDefaults.ExceptionHandling.UndeployRethrowPolicy.valueOf(enableUndeployRethrowStr.toUpperCase()));
                }
            }
            if (subElement.getNodeName().equals("conditionHandling")) {
                configuration.getEngineDefaults().getConditionHandling().addClasses(ConfigurationParser.getHandlerFactories(subElement));
            }
            if (!subElement.getNodeName().equals("scripts")) continue;
            ConfigurationParser.handleDefaultScriptConfig(configuration, subElement);
        }
    }

    private static void handleDefaultsThreading(Configuration configuration, Element parentElement) {
        String engineFairlockStr = ConfigurationParser.getOptionalAttribute(parentElement, "engine-fairlock");
        if (engineFairlockStr != null) {
            boolean isEngineFairlock = Boolean.parseBoolean(engineFairlockStr);
            configuration.getEngineDefaults().getThreading().setEngineFairlock(isEngineFairlock);
        }
        DOMElementIterator nodeIterator = new DOMElementIterator(parentElement.getChildNodes());
        while (nodeIterator.hasNext()) {
            ThreadPoolConfig result;
            String value;
            Long timeoutMSec;
            String timeoutMSecText;
            Boolean preserveOrder;
            String preserveOrderText;
            Element subElement = nodeIterator.next();
            if (subElement.getNodeName().equals("listener-dispatch")) {
                preserveOrderText = ConfigurationParser.getRequiredAttribute(subElement, "preserve-order");
                preserveOrder = Boolean.parseBoolean(preserveOrderText);
                configuration.getEngineDefaults().getThreading().setListenerDispatchPreserveOrder(preserveOrder);
                if (subElement.getAttributes().getNamedItem("timeout-msec") != null) {
                    timeoutMSecText = subElement.getAttributes().getNamedItem("timeout-msec").getTextContent();
                    timeoutMSec = Long.parseLong(timeoutMSecText);
                    configuration.getEngineDefaults().getThreading().setListenerDispatchTimeout(timeoutMSec);
                }
                if (subElement.getAttributes().getNamedItem("locking") != null) {
                    value = subElement.getAttributes().getNamedItem("locking").getTextContent();
                    configuration.getEngineDefaults().getThreading().setListenerDispatchLocking(ConfigurationEngineDefaults.Threading.Locking.valueOf(value.toUpperCase()));
                }
            }
            if (subElement.getNodeName().equals("insert-into-dispatch")) {
                preserveOrderText = ConfigurationParser.getRequiredAttribute(subElement, "preserve-order");
                preserveOrder = Boolean.parseBoolean(preserveOrderText);
                configuration.getEngineDefaults().getThreading().setInsertIntoDispatchPreserveOrder(preserveOrder);
                if (subElement.getAttributes().getNamedItem("timeout-msec") != null) {
                    timeoutMSecText = subElement.getAttributes().getNamedItem("timeout-msec").getTextContent();
                    timeoutMSec = Long.parseLong(timeoutMSecText);
                    configuration.getEngineDefaults().getThreading().setInsertIntoDispatchTimeout(timeoutMSec);
                }
                if (subElement.getAttributes().getNamedItem("locking") != null) {
                    value = subElement.getAttributes().getNamedItem("locking").getTextContent();
                    configuration.getEngineDefaults().getThreading().setInsertIntoDispatchLocking(ConfigurationEngineDefaults.Threading.Locking.valueOf(value.toUpperCase()));
                }
            }
            if (subElement.getNodeName().equals("named-window-consumer-dispatch")) {
                preserveOrderText = ConfigurationParser.getRequiredAttribute(subElement, "preserve-order");
                preserveOrder = Boolean.parseBoolean(preserveOrderText);
                configuration.getEngineDefaults().getThreading().setNamedWindowConsumerDispatchPreserveOrder(preserveOrder);
                if (subElement.getAttributes().getNamedItem("timeout-msec") != null) {
                    timeoutMSecText = subElement.getAttributes().getNamedItem("timeout-msec").getTextContent();
                    timeoutMSec = Long.parseLong(timeoutMSecText);
                    configuration.getEngineDefaults().getThreading().setNamedWindowConsumerDispatchTimeout(timeoutMSec);
                }
                if (subElement.getAttributes().getNamedItem("locking") != null) {
                    value = subElement.getAttributes().getNamedItem("locking").getTextContent();
                    configuration.getEngineDefaults().getThreading().setNamedWindowConsumerDispatchLocking(ConfigurationEngineDefaults.Threading.Locking.valueOf(value.toUpperCase()));
                }
            }
            if (subElement.getNodeName().equals("internal-timer")) {
                String enabledText = ConfigurationParser.getRequiredAttribute(subElement, "enabled");
                Boolean enabled = Boolean.parseBoolean(enabledText);
                String msecResolutionText = ConfigurationParser.getRequiredAttribute(subElement, "msec-resolution");
                Long msecResolution = Long.parseLong(msecResolutionText);
                configuration.getEngineDefaults().getThreading().setInternalTimerEnabled(enabled);
                configuration.getEngineDefaults().getThreading().setInternalTimerMsecResolution(msecResolution);
            }
            if (subElement.getNodeName().equals("threadpool-inbound")) {
                result = ConfigurationParser.parseThreadPoolConfig(subElement);
                configuration.getEngineDefaults().getThreading().setThreadPoolInbound(result.isEnabled());
                configuration.getEngineDefaults().getThreading().setThreadPoolInboundNumThreads(result.getNumThreads());
                configuration.getEngineDefaults().getThreading().setThreadPoolInboundCapacity(result.getCapacity());
            }
            if (subElement.getNodeName().equals("threadpool-outbound")) {
                result = ConfigurationParser.parseThreadPoolConfig(subElement);
                configuration.getEngineDefaults().getThreading().setThreadPoolOutbound(result.isEnabled());
                configuration.getEngineDefaults().getThreading().setThreadPoolOutboundNumThreads(result.getNumThreads());
                configuration.getEngineDefaults().getThreading().setThreadPoolOutboundCapacity(result.getCapacity());
            }
            if (subElement.getNodeName().equals("threadpool-timerexec")) {
                result = ConfigurationParser.parseThreadPoolConfig(subElement);
                configuration.getEngineDefaults().getThreading().setThreadPoolTimerExec(result.isEnabled());
                configuration.getEngineDefaults().getThreading().setThreadPoolTimerExecNumThreads(result.getNumThreads());
                configuration.getEngineDefaults().getThreading().setThreadPoolTimerExecCapacity(result.getCapacity());
            }
            if (!subElement.getNodeName().equals("threadpool-routeexec")) continue;
            result = ConfigurationParser.parseThreadPoolConfig(subElement);
            configuration.getEngineDefaults().getThreading().setThreadPoolRouteExec(result.isEnabled());
            configuration.getEngineDefaults().getThreading().setThreadPoolRouteExecNumThreads(result.getNumThreads());
            configuration.getEngineDefaults().getThreading().setThreadPoolRouteExecCapacity(result.getCapacity());
        }
    }

    private static ThreadPoolConfig parseThreadPoolConfig(Element parentElement) {
        String enabled = ConfigurationParser.getRequiredAttribute(parentElement, "enabled");
        boolean isEnabled = Boolean.parseBoolean(enabled);
        String numThreadsStr = ConfigurationParser.getRequiredAttribute(parentElement, "num-threads");
        int numThreads = Integer.parseInt(numThreadsStr);
        String capacityStr = ConfigurationParser.getOptionalAttribute(parentElement, "capacity");
        Integer capacity = null;
        if (capacityStr != null) {
            capacity = Integer.parseInt(capacityStr);
        }
        return new ThreadPoolConfig(isEnabled, numThreads, capacity);
    }

    private static void handleDefaultsViewResources(Configuration configuration, Element parentElement) {
        DOMElementIterator nodeIterator = new DOMElementIterator(parentElement.getChildNodes());
        while (nodeIterator.hasNext()) {
            Boolean value;
            String valueText;
            Element subElement = nodeIterator.next();
            if (subElement.getNodeName().equals("share-views")) {
                valueText = ConfigurationParser.getRequiredAttribute(subElement, "enabled");
                value = Boolean.parseBoolean(valueText);
                configuration.getEngineDefaults().getViewResources().setShareViews(value);
            }
            if (subElement.getNodeName().equals("allow-multiple-expiry-policy")) {
                valueText = ConfigurationParser.getRequiredAttribute(subElement, "enabled");
                value = Boolean.parseBoolean(valueText);
                configuration.getEngineDefaults().getViewResources().setAllowMultipleExpiryPolicies(value);
            }
            if (!subElement.getNodeName().equals("iterable-unbound")) continue;
            valueText = ConfigurationParser.getRequiredAttribute(subElement, "enabled");
            value = Boolean.parseBoolean(valueText);
            configuration.getEngineDefaults().getViewResources().setIterableUnbound(value);
        }
    }

    private static void handleDefaultsLogging(Configuration configuration, Element parentElement) {
        DOMElementIterator nodeIterator = new DOMElementIterator(parentElement.getChildNodes());
        while (nodeIterator.hasNext()) {
            Boolean value;
            String valueText;
            Element subElement = nodeIterator.next();
            if (subElement.getNodeName().equals("execution-path")) {
                valueText = ConfigurationParser.getRequiredAttribute(subElement, "enabled");
                value = Boolean.parseBoolean(valueText);
                configuration.getEngineDefaults().getLogging().setEnableExecutionDebug(value);
            }
            if (subElement.getNodeName().equals("timer-debug")) {
                valueText = ConfigurationParser.getRequiredAttribute(subElement, "enabled");
                value = Boolean.parseBoolean(valueText);
                configuration.getEngineDefaults().getLogging().setEnableTimerDebug(value);
            }
            if (subElement.getNodeName().equals("query-plan")) {
                valueText = ConfigurationParser.getRequiredAttribute(subElement, "enabled");
                value = Boolean.parseBoolean(valueText);
                configuration.getEngineDefaults().getLogging().setEnableQueryPlan(value);
            }
            if (subElement.getNodeName().equals("jdbc")) {
                valueText = ConfigurationParser.getRequiredAttribute(subElement, "enabled");
                value = Boolean.parseBoolean(valueText);
                configuration.getEngineDefaults().getLogging().setEnableJDBC(value);
            }
            if (!subElement.getNodeName().equals("audit")) continue;
            configuration.getEngineDefaults().getLogging().setAuditPattern(ConfigurationParser.getOptionalAttribute(subElement, "pattern"));
        }
    }

    private static void handleDefaultsVariables(Configuration configuration, Element parentElement) {
        DOMElementIterator nodeIterator = new DOMElementIterator(parentElement.getChildNodes());
        while (nodeIterator.hasNext()) {
            Element subElement = nodeIterator.next();
            if (!subElement.getNodeName().equals("msec-version-release")) continue;
            String valueText = ConfigurationParser.getRequiredAttribute(subElement, "value");
            Long value = Long.parseLong(valueText);
            configuration.getEngineDefaults().getVariables().setMsecVersionRelease(value);
        }
    }

    private static void handleDefaultsPatterns(Configuration configuration, Element parentElement) {
        DOMElementIterator nodeIterator = new DOMElementIterator(parentElement.getChildNodes());
        while (nodeIterator.hasNext()) {
            Element subElement = nodeIterator.next();
            if (!subElement.getNodeName().equals("max-subexpression")) continue;
            String valueText = ConfigurationParser.getRequiredAttribute(subElement, "value");
            Long value = Long.parseLong(valueText);
            configuration.getEngineDefaults().getPatterns().setMaxSubexpressions(value);
            String preventText = ConfigurationParser.getOptionalAttribute(subElement, "prevent-start");
            if (preventText == null) continue;
            configuration.getEngineDefaults().getPatterns().setMaxSubexpressionPreventStart(Boolean.parseBoolean(preventText));
        }
    }

    private static void handleDefaultsMatchRecognize(Configuration configuration, Element parentElement) {
        DOMElementIterator nodeIterator = new DOMElementIterator(parentElement.getChildNodes());
        while (nodeIterator.hasNext()) {
            Element subElement = nodeIterator.next();
            if (!subElement.getNodeName().equals("max-state")) continue;
            String valueText = ConfigurationParser.getRequiredAttribute(subElement, "value");
            Long value = Long.parseLong(valueText);
            configuration.getEngineDefaults().getMatchRecognize().setMaxStates(value);
            String preventText = ConfigurationParser.getOptionalAttribute(subElement, "prevent-start");
            if (preventText == null) continue;
            configuration.getEngineDefaults().getMatchRecognize().setMaxStatesPreventStart(Boolean.parseBoolean(preventText));
        }
    }

    private static void handleDefaultsStreamSelection(Configuration configuration, Element parentElement) {
        DOMElementIterator nodeIterator = new DOMElementIterator(parentElement.getChildNodes());
        while (nodeIterator.hasNext()) {
            StreamSelector defaultSelector;
            Element subElement = nodeIterator.next();
            if (!subElement.getNodeName().equals("stream-selector")) continue;
            String valueText = ConfigurationParser.getRequiredAttribute(subElement, "value");
            if (valueText == null) {
                throw new ConfigurationException("No value attribute supplied for stream-selector element");
            }
            if (valueText.toUpperCase().trim().equals("ISTREAM")) {
                defaultSelector = StreamSelector.ISTREAM_ONLY;
            } else if (valueText.toUpperCase().trim().equals("RSTREAM")) {
                defaultSelector = StreamSelector.RSTREAM_ONLY;
            } else if (valueText.toUpperCase().trim().equals("IRSTREAM")) {
                defaultSelector = StreamSelector.RSTREAM_ISTREAM_BOTH;
            } else {
                throw new ConfigurationException("Value attribute for stream-selector element invalid, expected one of the following keywords: istream, irstream, rstream");
            }
            configuration.getEngineDefaults().getStreamSelection().setDefaultStreamSelector(defaultSelector);
        }
    }

    private static void handleDefaultsTimeSource(Configuration configuration, Element parentElement) {
        DOMElementIterator nodeIterator = new DOMElementIterator(parentElement.getChildNodes());
        while (nodeIterator.hasNext()) {
            ConfigurationEngineDefaults.TimeSourceType timeSourceType;
            Element subElement = nodeIterator.next();
            if (!subElement.getNodeName().equals("time-source-type")) continue;
            String valueText = ConfigurationParser.getRequiredAttribute(subElement, "value");
            if (valueText == null) {
                throw new ConfigurationException("No value attribute supplied for time-source element");
            }
            if (valueText.toUpperCase().trim().equals("NANO")) {
                timeSourceType = ConfigurationEngineDefaults.TimeSourceType.NANO;
            } else if (valueText.toUpperCase().trim().equals("MILLI")) {
                timeSourceType = ConfigurationEngineDefaults.TimeSourceType.MILLI;
            } else {
                throw new ConfigurationException("Value attribute for time-source element invalid, expected one of the following keywords: nano, milli");
            }
            configuration.getEngineDefaults().getTimeSource().setTimeSourceType(timeSourceType);
        }
    }

    private static void handleMetricsReporting(Configuration configuration, Element parentElement) {
        String jmxEngineMetrics;
        String threading;
        String statementInterval;
        String enabled = ConfigurationParser.getRequiredAttribute(parentElement, "enabled");
        boolean isEnabled = Boolean.parseBoolean(enabled);
        configuration.getEngineDefaults().getMetricsReporting().setEnableMetricsReporting(isEnabled);
        String engineInterval = ConfigurationParser.getOptionalAttribute(parentElement, "engine-interval");
        if (engineInterval != null) {
            configuration.getEngineDefaults().getMetricsReporting().setEngineInterval(Long.parseLong(engineInterval));
        }
        if ((statementInterval = ConfigurationParser.getOptionalAttribute(parentElement, "statement-interval")) != null) {
            configuration.getEngineDefaults().getMetricsReporting().setStatementInterval(Long.parseLong(statementInterval));
        }
        if ((threading = ConfigurationParser.getOptionalAttribute(parentElement, "threading")) != null) {
            configuration.getEngineDefaults().getMetricsReporting().setThreading(Boolean.parseBoolean(threading));
        }
        if ((jmxEngineMetrics = ConfigurationParser.getOptionalAttribute(parentElement, "jmx-engine-metrics")) != null) {
            configuration.getEngineDefaults().getMetricsReporting().setJmxEngineMetrics(Boolean.parseBoolean(jmxEngineMetrics));
        }
        DOMElementIterator nodeIterator = new DOMElementIterator(parentElement.getChildNodes());
        while (nodeIterator.hasNext()) {
            String reportInactive;
            String numStmts;
            Element subElement = nodeIterator.next();
            if (!subElement.getNodeName().equals("stmtgroup")) continue;
            String name = ConfigurationParser.getRequiredAttribute(subElement, "name");
            long interval = Long.parseLong(ConfigurationParser.getRequiredAttribute(subElement, "interval"));
            ConfigurationMetricsReporting.StmtGroupMetrics metrics = new ConfigurationMetricsReporting.StmtGroupMetrics();
            metrics.setInterval(interval);
            configuration.getEngineDefaults().getMetricsReporting().addStmtGroup(name, metrics);
            String defaultInclude = ConfigurationParser.getOptionalAttribute(subElement, "default-include");
            if (defaultInclude != null) {
                metrics.setDefaultInclude(Boolean.parseBoolean(defaultInclude));
            }
            if ((numStmts = ConfigurationParser.getOptionalAttribute(subElement, "num-stmts")) != null) {
                metrics.setNumStatements(Integer.parseInt(numStmts));
            }
            if ((reportInactive = ConfigurationParser.getOptionalAttribute(subElement, "report-inactive")) != null) {
                metrics.setReportInactive(Boolean.parseBoolean(reportInactive));
            }
            ConfigurationParser.handleMetricsReportingPatterns(metrics, subElement);
        }
    }

    private static void handleLanguage(Configuration configuration, Element parentElement) {
        String sortUsingCollator = ConfigurationParser.getOptionalAttribute(parentElement, "sort-using-collator");
        if (sortUsingCollator != null) {
            boolean isSortUsingCollator = Boolean.parseBoolean(sortUsingCollator);
            configuration.getEngineDefaults().getLanguage().setSortUsingCollator(isSortUsingCollator);
        }
    }

    private static void handleExpression(Configuration configuration, Element parentElement) {
        String timeZoneStr;
        String mathContextStr;
        String duckTypingStr;
        String extendedAggregationStr;
        String selfSubselectPreeval;
        String udfCache;
        String divZero;
        String integerDivision = ConfigurationParser.getOptionalAttribute(parentElement, "integer-division");
        if (integerDivision != null) {
            boolean isIntegerDivision = Boolean.parseBoolean(integerDivision);
            configuration.getEngineDefaults().getExpression().setIntegerDivision(isIntegerDivision);
        }
        if ((divZero = ConfigurationParser.getOptionalAttribute(parentElement, "division-by-zero-is-null")) != null) {
            boolean isDivZero = Boolean.parseBoolean(divZero);
            configuration.getEngineDefaults().getExpression().setDivisionByZeroReturnsNull(isDivZero);
        }
        if ((udfCache = ConfigurationParser.getOptionalAttribute(parentElement, "udf-cache")) != null) {
            boolean isUdfCache = Boolean.parseBoolean(udfCache);
            configuration.getEngineDefaults().getExpression().setUdfCache(isUdfCache);
        }
        if ((selfSubselectPreeval = ConfigurationParser.getOptionalAttribute(parentElement, "self-subselect-preeval")) != null) {
            boolean isSelfSubselectPreeval = Boolean.parseBoolean(selfSubselectPreeval);
            configuration.getEngineDefaults().getExpression().setSelfSubselectPreeval(isSelfSubselectPreeval);
        }
        if ((extendedAggregationStr = ConfigurationParser.getOptionalAttribute(parentElement, "extended-agg")) != null) {
            boolean extendedAggregation = Boolean.parseBoolean(extendedAggregationStr);
            configuration.getEngineDefaults().getExpression().setExtendedAggregation(extendedAggregation);
        }
        if ((duckTypingStr = ConfigurationParser.getOptionalAttribute(parentElement, "ducktyping")) != null) {
            boolean duckTyping = Boolean.parseBoolean(duckTypingStr);
            configuration.getEngineDefaults().getExpression().setDuckTyping(duckTyping);
        }
        if ((mathContextStr = ConfigurationParser.getOptionalAttribute(parentElement, "math-context")) != null) {
            try {
                MathContext mathContext = new MathContext(mathContextStr);
                configuration.getEngineDefaults().getExpression().setMathContext(mathContext);
            }
            catch (IllegalArgumentException ex) {
                throw new ConfigurationException("Failed to parse '" + mathContextStr + "' as a MathContext");
            }
        }
        if ((timeZoneStr = ConfigurationParser.getOptionalAttribute(parentElement, "time-zone")) != null) {
            TimeZone timeZone = TimeZone.getTimeZone(timeZoneStr);
            configuration.getEngineDefaults().getExpression().setTimeZone(timeZone);
        }
    }

    private static void handleExecution(Configuration configuration, Element parentElement) {
        String allowIsolatedServiceStr;
        String filterServiceMaxFilterWidthStr;
        String filterServiceProfileStr;
        String threadingProfileStr;
        String disableLockingStr;
        String fairlockStr;
        String prioritizedStr = ConfigurationParser.getOptionalAttribute(parentElement, "prioritized");
        if (prioritizedStr != null) {
            boolean isPrioritized = Boolean.parseBoolean(prioritizedStr);
            configuration.getEngineDefaults().getExecution().setPrioritized(isPrioritized);
        }
        if ((fairlockStr = ConfigurationParser.getOptionalAttribute(parentElement, "fairlock")) != null) {
            boolean isFairlock = Boolean.parseBoolean(fairlockStr);
            configuration.getEngineDefaults().getExecution().setFairlock(isFairlock);
        }
        if ((disableLockingStr = ConfigurationParser.getOptionalAttribute(parentElement, "disable-locking")) != null) {
            boolean isDisablelock = Boolean.parseBoolean(disableLockingStr);
            configuration.getEngineDefaults().getExecution().setDisableLocking(isDisablelock);
        }
        if ((threadingProfileStr = ConfigurationParser.getOptionalAttribute(parentElement, "threading-profile")) != null) {
            ConfigurationEngineDefaults.ThreadingProfile profile = ConfigurationEngineDefaults.ThreadingProfile.valueOf(threadingProfileStr.toUpperCase());
            configuration.getEngineDefaults().getExecution().setThreadingProfile(profile);
        }
        if ((filterServiceProfileStr = ConfigurationParser.getOptionalAttribute(parentElement, "filter-service-profile")) != null) {
            ConfigurationEngineDefaults.FilterServiceProfile profile = ConfigurationEngineDefaults.FilterServiceProfile.valueOf(filterServiceProfileStr.toUpperCase());
            configuration.getEngineDefaults().getExecution().setFilterServiceProfile(profile);
        }
        if ((filterServiceMaxFilterWidthStr = ConfigurationParser.getOptionalAttribute(parentElement, "filter-service-max-filter-width")) != null) {
            configuration.getEngineDefaults().getExecution().setFilterServiceMaxFilterWidth(Integer.parseInt(filterServiceMaxFilterWidthStr));
        }
        if ((allowIsolatedServiceStr = ConfigurationParser.getOptionalAttribute(parentElement, "allow-isolated-service")) != null) {
            boolean isAllowIsolatedService = Boolean.parseBoolean(allowIsolatedServiceStr);
            configuration.getEngineDefaults().getExecution().setAllowIsolatedService(isAllowIsolatedService);
        }
    }

    private static void handleDefaultScriptConfig(Configuration configuration, Element parentElement) {
        String defaultDialect = ConfigurationParser.getOptionalAttribute(parentElement, "default-dialect");
        if (defaultDialect != null) {
            configuration.getEngineDefaults().getScripts().setDefaultDialect(defaultDialect);
        }
    }

    private static List<String> getHandlerFactories(Element parentElement) {
        ArrayList<String> list = new ArrayList<String>();
        DOMElementIterator nodeIterator = new DOMElementIterator(parentElement.getChildNodes());
        while (nodeIterator.hasNext()) {
            Element subElement = nodeIterator.next();
            if (!subElement.getNodeName().equals("handlerFactory")) continue;
            String text = ConfigurationParser.getRequiredAttribute(subElement, "class");
            list.add(text);
        }
        return list;
    }

    private static void handleMetricsReportingPatterns(ConfigurationMetricsReporting.StmtGroupMetrics groupDef, Element parentElement) {
        DOMElementIterator nodeIterator = new DOMElementIterator(parentElement.getChildNodes());
        while (nodeIterator.hasNext()) {
            String text;
            Element subElement = nodeIterator.next();
            if (subElement.getNodeName().equals("include-regex")) {
                text = subElement.getChildNodes().item(0).getTextContent();
                groupDef.getPatterns().add(new Pair<StringPatternSetRegex, Boolean>(new StringPatternSetRegex(text), true));
            }
            if (subElement.getNodeName().equals("exclude-regex")) {
                text = subElement.getChildNodes().item(0).getTextContent();
                groupDef.getPatterns().add(new Pair<StringPatternSetRegex, Boolean>(new StringPatternSetRegex(text), false));
            }
            if (subElement.getNodeName().equals("include-like")) {
                text = subElement.getChildNodes().item(0).getTextContent();
                groupDef.getPatterns().add(new Pair<StringPatternSetLike, Boolean>(new StringPatternSetLike(text), true));
            }
            if (!subElement.getNodeName().equals("exclude-like")) continue;
            text = subElement.getChildNodes().item(0).getTextContent();
            groupDef.getPatterns().add(new Pair<StringPatternSetLike, Boolean>(new StringPatternSetLike(text), false));
        }
    }

    private static void handleDefaultsEventMeta(Configuration configuration, Element parentElement) {
        DOMElementIterator nodeIterator = new DOMElementIterator(parentElement.getChildNodes());
        while (nodeIterator.hasNext()) {
            Node sizeNode;
            Node typeNode;
            Enum value;
            Element subElement = nodeIterator.next();
            if (subElement.getNodeName().equals("class-property-resolution")) {
                Node accessorStyleNode;
                Node styleNode = subElement.getAttributes().getNamedItem("style");
                if (styleNode != null) {
                    String styleText = styleNode.getTextContent();
                    value = Configuration.PropertyResolutionStyle.valueOf(styleText.toUpperCase());
                    configuration.getEngineDefaults().getEventMeta().setClassPropertyResolutionStyle((Configuration.PropertyResolutionStyle)value);
                }
                if ((accessorStyleNode = subElement.getAttributes().getNamedItem("accessor-style")) != null) {
                    String accessorStyleText = accessorStyleNode.getTextContent();
                    ConfigurationEventTypeLegacy.AccessorStyle value2 = ConfigurationEventTypeLegacy.AccessorStyle.valueOf(accessorStyleText.toUpperCase());
                    configuration.getEngineDefaults().getEventMeta().setDefaultAccessorStyle(value2);
                }
            }
            if (subElement.getNodeName().equals("event-representation") && (typeNode = subElement.getAttributes().getNamedItem("type")) != null) {
                String typeText = typeNode.getTextContent();
                value = Configuration.EventRepresentation.valueOf(typeText.toUpperCase());
                configuration.getEngineDefaults().getEventMeta().setDefaultEventRepresentation((Configuration.EventRepresentation)value);
            }
            if (!subElement.getNodeName().equals("anonymous-cache") || (sizeNode = subElement.getAttributes().getNamedItem("size")) == null) continue;
            configuration.getEngineDefaults().getEventMeta().setAnonymousCacheSize(Integer.parseInt(sizeNode.getTextContent()));
        }
    }

    private static Properties handleProperties(Element element, String propElementName) {
        Properties properties = new Properties();
        DOMElementIterator nodeIterator = new DOMElementIterator(element.getChildNodes());
        while (nodeIterator.hasNext()) {
            Element subElement = nodeIterator.next();
            if (!subElement.getNodeName().equals(propElementName)) continue;
            String name = ConfigurationParser.getRequiredAttribute(subElement, "name");
            String value = ConfigurationParser.getRequiredAttribute(subElement, "value");
            properties.put(name, value);
        }
        return properties;
    }

    protected static InputStream getResourceAsStream(String resource) {
        String stripped = resource.startsWith("/") ? resource.substring(1) : resource;
        InputStream stream = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            stream = classLoader.getResourceAsStream(stripped);
        }
        if (stream == null) {
            stream = ConfigurationParser.class.getResourceAsStream(resource);
        }
        if (stream == null) {
            stream = ConfigurationParser.class.getClassLoader().getResourceAsStream(stripped);
        }
        if (stream == null) {
            throw new EPException(resource + " not found");
        }
        return stream;
    }

    private static String getOptionalAttribute(Node node, String key) {
        Node valueNode = node.getAttributes().getNamedItem(key);
        if (valueNode != null) {
            return valueNode.getTextContent();
        }
        return null;
    }

    private static String getRequiredAttribute(Node node, String key) {
        Node valueNode = node.getAttributes().getNamedItem(key);
        if (valueNode == null) {
            String name = node.getLocalName();
            if (name == null) {
                name = node.getNodeName();
            }
            throw new ConfigurationException("Required attribute by name '" + key + "' not found for element '" + name + "'");
        }
        return valueNode.getTextContent();
    }

    private static class ThreadPoolConfig {
        private boolean enabled;
        private int numThreads;
        private Integer capacity;

        public ThreadPoolConfig(boolean enabled, int numThreads, Integer capacity) {
            this.enabled = enabled;
            this.numThreads = numThreads;
            this.capacity = capacity;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public int getNumThreads() {
            return this.numThreads;
        }

        public Integer getCapacity() {
            return this.capacity;
        }
    }
}

