/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.scopetest;

import com.espertech.esper.client.scopetest.ScopeTestHelper;
import com.espertech.esper.collection.UniformPair;
import java.util.LinkedList;
import java.util.List;

public class SupportSubscriber {
    private final List<Object[]> newDataList = new LinkedList<Object[]>();
    private final List<Object[]> oldDataList = new LinkedList<Object[]>();
    private Object[] lastNewData;
    private Object[] lastOldData;
    private boolean isInvoked;

    public synchronized void update(Object[] newData, Object[] oldData) {
        this.oldDataList.add(oldData);
        this.newDataList.add(newData);
        this.lastNewData = newData;
        this.lastOldData = oldData;
        this.isInvoked = true;
    }

    public synchronized void reset() {
        this.oldDataList.clear();
        this.newDataList.clear();
        this.lastNewData = null;
        this.lastOldData = null;
        this.isInvoked = false;
    }

    public Object[] getLastNewData() {
        return this.lastNewData;
    }

    public synchronized Object[] getAndResetLastNewData() {
        Object[] lastNew = this.lastNewData;
        this.reset();
        return lastNew;
    }

    public synchronized Object assertOneGetNewAndReset() {
        ScopeTestHelper.assertTrue("Subscriber invocation not received but expected", this.isInvoked);
        ScopeTestHelper.assertEquals("Mismatch in the number of invocations", 1, this.newDataList.size());
        ScopeTestHelper.assertEquals("Mismatch in the number of invocations", 1, this.oldDataList.size());
        if (this.lastNewData == null) {
            ScopeTestHelper.fail("No new-data events received");
        }
        ScopeTestHelper.assertEquals("Mismatch in the number of new-data events", 1, this.lastNewData.length);
        ScopeTestHelper.assertNull("No old-data events are expected but some were received", this.lastOldData);
        Object lastNew = this.lastNewData[0];
        this.reset();
        return lastNew;
    }

    public Object assertOneGetOldAndReset() {
        ScopeTestHelper.assertTrue("Listener invocation not received but expected", this.isInvoked);
        ScopeTestHelper.assertEquals("Mismatch in the number of invocations", 1, this.newDataList.size());
        ScopeTestHelper.assertEquals("Mismatch in the number of invocations", 1, this.oldDataList.size());
        if (this.lastOldData == null) {
            ScopeTestHelper.fail("No old-data events received");
        }
        ScopeTestHelper.assertEquals("Mismatch in the number of old-data events", 1, this.lastOldData.length);
        ScopeTestHelper.assertNull("Expected no new-data events", this.lastNewData);
        Object lastNew = this.lastOldData[0];
        this.reset();
        return lastNew;
    }

    public Object[] getLastOldData() {
        return this.lastOldData;
    }

    public List<Object[]> getNewDataList() {
        return this.newDataList;
    }

    public List<Object[]> getOldDataList() {
        return this.oldDataList;
    }

    public boolean isInvoked() {
        return this.isInvoked;
    }

    public synchronized boolean getAndClearIsInvoked() {
        boolean invoked = this.isInvoked;
        this.isInvoked = false;
        return invoked;
    }

    public synchronized Object[] getNewDataListFlattened() {
        return this.flatten(this.newDataList);
    }

    public synchronized Object[] getOldDataListFlattened() {
        return this.flatten(this.oldDataList);
    }

    public synchronized UniformPair<Object[]> getDataListsFlattened() {
        return new UniformPair<Object[]>(this.flatten(this.newDataList), this.flatten(this.oldDataList));
    }

    private Object[] flatten(List<Object[]> list) {
        int count = 0;
        for (Object[] events : list) {
            if (events == null) continue;
            count += events.length;
        }
        Object[] array = new Object[count];
        count = 0;
        for (Object[] events : list) {
            if (events == null) continue;
            for (int i = 0; i < events.length; ++i) {
                array[count++] = events[i];
            }
        }
        return array;
    }
}

