/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.EPStatementObjectModel;
import com.espertech.esper.client.soda.Expression;
import com.espertech.esper.client.soda.ExpressionPrecedenceEnum;
import java.io.Serializable;
import java.io.StringWriter;

public class DataFlowOperatorParameter
implements Serializable {
    private static final long serialVersionUID = 6902224639315413025L;
    private String parameterName;
    private Object parameterValue;

    public DataFlowOperatorParameter(String parameterName, Object parameterValue) {
        this.parameterName = parameterName;
        this.parameterValue = parameterValue;
    }

    public DataFlowOperatorParameter() {
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    public Object getParameterValue() {
        return this.parameterValue;
    }

    public void setParameterValue(Object parameterValue) {
        this.parameterValue = parameterValue;
    }

    public void toEpl(StringWriter writer) {
        writer.write(this.parameterName);
        writer.write(": ");
        DataFlowOperatorParameter.renderValue(writer, this.parameterValue);
    }

    public static void renderValue(StringWriter writer, Object parameterValue) {
        if (parameterValue instanceof EPStatementObjectModel) {
            writer.write("(");
            ((EPStatementObjectModel)parameterValue).toEPL(writer);
            writer.write(")");
        } else if (parameterValue instanceof Expression) {
            ((Expression)parameterValue).toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
        } else if (parameterValue == null) {
            writer.write("null");
        } else if (parameterValue instanceof String) {
            writer.write("\"");
            writer.write(parameterValue.toString());
            writer.write("\"");
        } else {
            writer.write(parameterValue.toString());
        }
    }
}

