/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.ContainedEventSelect;
import com.espertech.esper.client.soda.EPStatementFormatter;
import com.espertech.esper.client.soda.Expression;
import com.espertech.esper.client.soda.ExpressionPrecedenceEnum;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.List;

public class Filter
implements Serializable {
    private static final long serialVersionUID = 0L;
    private String eventTypeName;
    private Expression filter;
    private List<ContainedEventSelect> optionalPropertySelects;

    public Filter() {
    }

    public static Filter create(String eventTypeName) {
        return new Filter(eventTypeName);
    }

    public static Filter create(String eventTypeName, Expression filter) {
        return new Filter(eventTypeName, filter);
    }

    public Filter(String eventTypeName) {
        this.eventTypeName = eventTypeName;
    }

    public Filter(String eventTypeName, Expression filter) {
        this.eventTypeName = eventTypeName;
        this.filter = filter;
    }

    public String getEventTypeName() {
        return this.eventTypeName;
    }

    public void setEventTypeName(String eventTypeName) {
        this.eventTypeName = eventTypeName;
    }

    public Expression getFilter() {
        return this.filter;
    }

    public void setFilter(Expression filter) {
        this.filter = filter;
    }

    public List<ContainedEventSelect> getOptionalPropertySelects() {
        return this.optionalPropertySelects;
    }

    public void setOptionalPropertySelects(List<ContainedEventSelect> optionalPropertySelects) {
        this.optionalPropertySelects = optionalPropertySelects;
    }

    public void toEPL(StringWriter writer, EPStatementFormatter formatter) {
        writer.write(this.eventTypeName);
        if (this.filter != null) {
            writer.write(40);
            this.filter.toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
            writer.write(41);
        }
        if (this.optionalPropertySelects != null) {
            for (ContainedEventSelect propertySelect : this.optionalPropertySelects) {
                writer.write(91);
                propertySelect.toEPL(writer, formatter);
                writer.write(93);
            }
        }
    }
}

