/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.Expression;
import com.espertech.esper.client.soda.ExpressionBase;
import com.espertech.esper.client.soda.ExpressionPrecedenceEnum;
import com.espertech.esper.client.soda.PropertyValueExpression;
import java.io.StringWriter;
import java.util.List;

public class NewOperatorExpression
extends ExpressionBase {
    private static final long serialVersionUID = -7207726921338996912L;
    private List<String> columnNames;

    public NewOperatorExpression() {
    }

    public NewOperatorExpression(List<String> columnNames) {
        this.columnNames = columnNames;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(List<String> columnNames) {
        this.columnNames = columnNames;
    }

    @Override
    public ExpressionPrecedenceEnum getPrecedence() {
        return ExpressionPrecedenceEnum.NEGATED;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        writer.write("new{");
        String delimiter = "";
        for (int i = 0; i < this.getChildren().size(); ++i) {
            PropertyValueExpression prop;
            writer.append(delimiter);
            writer.append(this.columnNames.get(i));
            Expression expr = this.getChildren().get(i);
            boolean outputexpr = true;
            if (expr instanceof PropertyValueExpression && (prop = (PropertyValueExpression)expr).getPropertyName().equals(this.columnNames.get(i))) {
                outputexpr = false;
            }
            if (outputexpr) {
                writer.append("=");
                expr.toEPL(writer, this.getPrecedence());
            }
            delimiter = ",";
        }
        writer.write("}");
    }
}

