/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.EPStatementFormatter;
import com.espertech.esper.client.soda.Expression;
import com.espertech.esper.client.soda.ExpressionPrecedenceEnum;
import com.espertech.esper.client.soda.OnClause;
import com.espertech.esper.client.soda.OnMergeMatchedAction;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class OnMergeMatchItem
extends OnClause {
    private static final long serialVersionUID = 0L;
    private boolean matched;
    private Expression optionalCondition;
    private List<OnMergeMatchedAction> actions;

    public OnMergeMatchItem() {
        this.actions = new ArrayList<OnMergeMatchedAction>();
    }

    public OnMergeMatchItem(boolean matched, Expression optionalCondition, List<OnMergeMatchedAction> actions) {
        this.matched = matched;
        this.optionalCondition = optionalCondition;
        this.actions = actions;
    }

    public void toEPL(StringWriter writer, EPStatementFormatter formatter) {
        formatter.beginMergeWhenMatched(writer);
        if (this.matched) {
            writer.write("when matched");
        } else {
            writer.write("when not matched");
        }
        if (this.optionalCondition != null) {
            writer.write(" and ");
            this.optionalCondition.toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
        }
        for (OnMergeMatchedAction action : this.actions) {
            formatter.beginMergeAction(writer);
            action.toEPL(writer);
        }
    }

    public boolean isMatched() {
        return this.matched;
    }

    public void setMatched(boolean matched) {
        this.matched = matched;
    }

    public Expression getOptionalCondition() {
        return this.optionalCondition;
    }

    public void setOptionalCondition(Expression optionalCondition) {
        this.optionalCondition = optionalCondition;
    }

    public List<OnMergeMatchedAction> getActions() {
        return this.actions;
    }

    public void setActions(List<OnMergeMatchedAction> actions) {
        this.actions = actions;
    }
}

