/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.Expression;
import com.espertech.esper.client.soda.ExpressionPrecedenceEnum;
import com.espertech.esper.client.soda.OnMergeMatchedAction;
import com.espertech.esper.client.soda.SelectClauseElement;
import java.io.StringWriter;
import java.util.Collections;
import java.util.List;

public class OnMergeMatchedInsertAction
implements OnMergeMatchedAction {
    private static final long serialVersionUID = 0L;
    private List<String> columnNames = Collections.emptyList();
    private List<SelectClauseElement> selectList = Collections.emptyList();
    private Expression whereClause;
    private String optionalStreamName;

    public OnMergeMatchedInsertAction(List<String> columnNames, List<SelectClauseElement> selectList, Expression whereClause, String optionalStreamName) {
        this.columnNames = columnNames;
        this.selectList = selectList;
        this.whereClause = whereClause;
        this.optionalStreamName = optionalStreamName;
    }

    public OnMergeMatchedInsertAction() {
    }

    public Expression getWhereClause() {
        return this.whereClause;
    }

    public void setWhereClause(Expression whereClause) {
        this.whereClause = whereClause;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(List<String> columnNames) {
        this.columnNames = columnNames;
    }

    public List<SelectClauseElement> getSelectList() {
        return this.selectList;
    }

    public void setSelectList(List<SelectClauseElement> selectList) {
        this.selectList = selectList;
    }

    public String getOptionalStreamName() {
        return this.optionalStreamName;
    }

    public void setOptionalStreamName(String optionalStreamName) {
        this.optionalStreamName = optionalStreamName;
    }

    @Override
    public void toEPL(StringWriter writer) {
        String delimiter;
        writer.write("then insert");
        if (this.optionalStreamName != null) {
            writer.write(" into ");
            writer.write(this.optionalStreamName);
        }
        if (this.columnNames.size() > 0) {
            writer.write("(");
            delimiter = "";
            for (String name : this.columnNames) {
                writer.write(delimiter);
                writer.write(name);
                delimiter = ", ";
            }
            writer.write(")");
        }
        writer.write(" select ");
        delimiter = "";
        for (SelectClauseElement element : this.selectList) {
            writer.write(delimiter);
            element.toEPLElement(writer);
            delimiter = ", ";
        }
        if (this.whereClause != null) {
            writer.write(" where ");
            this.whereClause.toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
        }
    }
}

