/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.util;

import com.espertech.esper.client.util.CountMinSketchAgent;
import com.espertech.esper.client.util.CountMinSketchAgentContextAdd;
import com.espertech.esper.client.util.CountMinSketchAgentContextEstimate;
import com.espertech.esper.client.util.CountMinSketchAgentContextFromBytes;
import java.io.UnsupportedEncodingException;

public class CountMinSketchAgentStringUTF16
implements CountMinSketchAgent {
    @Override
    public Class[] getAcceptableValueTypes() {
        return new Class[]{String.class};
    }

    @Override
    public void add(CountMinSketchAgentContextAdd ctx) {
        String text = (String)ctx.getValue();
        if (text == null) {
            return;
        }
        byte[] bytes = this.toBytesUTF16(text);
        ctx.getState().add(bytes, 1);
    }

    @Override
    public Long estimate(CountMinSketchAgentContextEstimate ctx) {
        String text = (String)ctx.getValue();
        if (text == null) {
            return null;
        }
        byte[] bytes = this.toBytesUTF16(text);
        return ctx.getState().frequency(bytes);
    }

    @Override
    public Object fromBytes(CountMinSketchAgentContextFromBytes ctx) {
        try {
            return new String(ctx.getBytes(), "UTF-16");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] toBytesUTF16(String text) {
        try {
            return text.getBytes("UTF-16");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

