/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.collection;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ArrayEventIterator;
import com.espertech.esper.collection.SingleEventIterator;
import com.espertech.esper.event.EventBeanReader;
import com.espertech.esper.event.EventBeanReaderDefaultImpl;
import com.espertech.esper.event.EventBeanUtility;
import com.espertech.esper.event.EventTypeSPI;
import java.util.ArrayDeque;
import java.util.Iterator;

public class EventDistinctIterator
implements Iterator<EventBean> {
    private static final Iterator<EventBean> NULL_ITER = new SingleEventIterator(null);
    private final Iterator<EventBean> sourceIterator;
    private Iterator<EventBean> resultIterator;
    private EventBeanReader eventBeanReader;

    public EventDistinctIterator(Iterator<EventBean> sourceIterator, EventType eventType) {
        this.sourceIterator = sourceIterator;
        if (eventType instanceof EventTypeSPI) {
            this.eventBeanReader = ((EventTypeSPI)eventType).getReader();
        }
        if (this.eventBeanReader == null) {
            this.eventBeanReader = new EventBeanReaderDefaultImpl(eventType);
        }
    }

    @Override
    public EventBean next() {
        if (this.resultIterator == null) {
            this.initialize();
        }
        return this.resultIterator.next();
    }

    @Override
    public boolean hasNext() {
        if (this.resultIterator == null) {
            this.initialize();
        }
        return this.resultIterator.hasNext();
    }

    private void initialize() {
        if (this.sourceIterator == null || !this.sourceIterator.hasNext()) {
            this.resultIterator = NULL_ITER;
            return;
        }
        EventBean eventFirst = this.sourceIterator.next();
        if (!this.sourceIterator.hasNext()) {
            this.resultIterator = new SingleEventIterator(eventFirst);
            return;
        }
        ArrayDeque<EventBean> events = new ArrayDeque<EventBean>();
        events.add(eventFirst);
        while (this.sourceIterator.hasNext()) {
            events.add(this.sourceIterator.next());
        }
        EventBean[] unique = EventBeanUtility.getDistinctByProp(events, this.eventBeanReader);
        this.resultIterator = new ArrayEventIterator(unique);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

