/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.collection;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class NumberAscCombinationEnumeration
implements Enumeration<int[]> {
    private final int n;
    private int level;
    private int[] current;

    public NumberAscCombinationEnumeration(int n) {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        this.n = n;
        this.level = n;
        this.current = NumberAscCombinationEnumeration.levelCurrent(n);
    }

    @Override
    public boolean hasMoreElements() {
        return this.current != null;
    }

    @Override
    public int[] nextElement() {
        if (!this.hasMoreElements()) {
            throw new NoSuchElementException();
        }
        int[] item = this.copyCurrent(this.current);
        this.computeNext();
        return item;
    }

    private void computeNext() {
        int last = this.current.length - 1;
        if (this.current[last] + 1 < this.n) {
            int n = last;
            this.current[n] = this.current[n] + 1;
            return;
        }
        for (int currOverflowedLevel = last - 1; currOverflowedLevel >= 0; --currOverflowedLevel) {
            int maxAtPosition = this.n - this.level + currOverflowedLevel;
            if (this.current[currOverflowedLevel] >= maxAtPosition) continue;
            int n = currOverflowedLevel;
            this.current[n] = this.current[n] + 1;
            for (int i = currOverflowedLevel + 1; i < this.current.length; ++i) {
                this.current[i] = this.current[i - 1] + 1;
            }
            return;
        }
        --this.level;
        this.current = (int[])(this.level == 0 ? null : NumberAscCombinationEnumeration.levelCurrent(this.level));
    }

    private static int[] levelCurrent(int level) {
        int[] current = new int[level];
        for (int i = 0; i < level; ++i) {
            current[i] = i;
        }
        return current;
    }

    private int[] copyCurrent(int[] current) {
        int[] updated = new int[current.length];
        System.arraycopy(current, 0, updated, 0, updated.length);
        return updated;
    }
}

