/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.factory;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.factory.StatementAgentInstanceFactoryBase;
import com.espertech.esper.core.context.factory.StatementAgentInstanceFactoryCreateVariableResult;
import com.espertech.esper.core.context.factory.StatementAgentInstanceFactoryResult;
import com.espertech.esper.core.context.mgr.ContextPropertyRegistryImpl;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.core.start.EPStatementStartMethodHelperAssignExpr;
import com.espertech.esper.epl.core.ResultSetProcessor;
import com.espertech.esper.epl.core.ResultSetProcessorFactoryDesc;
import com.espertech.esper.epl.core.ResultSetProcessorFactoryFactory;
import com.espertech.esper.epl.core.StreamTypeServiceImpl;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.spec.CreateVariableDesc;
import com.espertech.esper.epl.spec.SelectClauseElementWildcard;
import com.espertech.esper.epl.spec.SelectClauseStreamSelectorEnum;
import com.espertech.esper.epl.spec.StatementSpecCompiled;
import com.espertech.esper.epl.variable.CreateVariableView;
import com.espertech.esper.epl.variable.VariableMetaData;
import com.espertech.esper.epl.view.OutputProcessViewBase;
import com.espertech.esper.epl.view.OutputProcessViewFactory;
import com.espertech.esper.epl.view.OutputProcessViewFactoryFactory;
import com.espertech.esper.util.StopCallback;
import com.espertech.esper.view.StatementStopCallback;

public class StatementAgentInstanceFactoryCreateVariable
extends StatementAgentInstanceFactoryBase {
    private final CreateVariableDesc createDesc;
    private final StatementSpecCompiled statementSpec;
    private final StatementContext statementContext;
    private final EPServicesContext services;
    private final VariableMetaData variableMetaData;
    private final EventType eventType;

    public StatementAgentInstanceFactoryCreateVariable(CreateVariableDesc createDesc, StatementSpecCompiled statementSpec, StatementContext statementContext, EPServicesContext services, VariableMetaData variableMetaData, EventType eventType) {
        super(statementContext.getAnnotations());
        this.createDesc = createDesc;
        this.statementSpec = statementSpec;
        this.statementContext = statementContext;
        this.services = services;
        this.variableMetaData = variableMetaData;
        this.eventType = eventType;
    }

    @Override
    public StatementAgentInstanceFactoryCreateVariableResult newContextInternal(final AgentInstanceContext agentInstanceContext, boolean isRecoveringResilient) {
        OutputProcessViewBase outputViewBase;
        StopCallback stopCallback = new StopCallback(){

            @Override
            public void stop() {
                StatementAgentInstanceFactoryCreateVariable.this.services.getVariableService().deallocateVariableState(StatementAgentInstanceFactoryCreateVariable.this.variableMetaData.getVariableName(), agentInstanceContext.getAgentInstanceId());
            }
        };
        this.services.getVariableService().allocateVariableState(this.variableMetaData.getVariableName(), agentInstanceContext.getAgentInstanceId(), this.statementContext.getStatementExtensionServicesContext(), isRecoveringResilient);
        final CreateVariableView createView = new CreateVariableView(this.statementContext.getStatementId(), this.services.getEventAdapterService(), this.services.getVariableService(), this.createDesc.getVariableName(), this.statementContext.getStatementResultService(), agentInstanceContext.getAgentInstanceId());
        this.services.getVariableService().registerCallback(this.createDesc.getVariableName(), agentInstanceContext.getAgentInstanceId(), createView);
        this.statementContext.getStatementStopService().addSubscriber(new StatementStopCallback(){

            @Override
            public void statementStopped() {
                StatementAgentInstanceFactoryCreateVariable.this.services.getVariableService().unregisterCallback(StatementAgentInstanceFactoryCreateVariable.this.createDesc.getVariableName(), 0, createView);
            }
        });
        this.statementSpec.getSelectClauseSpec().setSelectExprList(new SelectClauseElementWildcard());
        this.statementSpec.setSelectStreamDirEnum(SelectClauseStreamSelectorEnum.RSTREAM_ISTREAM_BOTH);
        StreamTypeServiceImpl typeService = new StreamTypeServiceImpl(new EventType[]{createView.getEventType()}, new String[]{"create_variable"}, new boolean[]{true}, this.services.getEngineURI(), false);
        try {
            ResultSetProcessorFactoryDesc resultSetProcessorPrototype = ResultSetProcessorFactoryFactory.getProcessorPrototype(this.statementSpec, this.statementContext, typeService, null, new boolean[0], true, ContextPropertyRegistryImpl.EMPTY_REGISTRY, null, this.services.getConfigSnapshot(), this.services.getResultSetProcessorHelperFactory(), false, false);
            ResultSetProcessor resultSetProcessor = EPStatementStartMethodHelperAssignExpr.getAssignResultSetProcessor(agentInstanceContext, resultSetProcessorPrototype, false, null, false);
            OutputProcessViewFactory outputViewFactory = OutputProcessViewFactoryFactory.make(this.statementSpec, this.services.getInternalEventRouter(), agentInstanceContext.getStatementContext(), resultSetProcessor.getResultEventType(), null, this.services.getTableService(), resultSetProcessorPrototype.getResultSetProcessorFactory().getResultSetProcessorType(), this.services.getResultSetProcessorHelperFactory(), this.services.getStatementVariableRefService());
            outputViewBase = outputViewFactory.makeView(resultSetProcessor, agentInstanceContext);
            createView.addView(outputViewBase);
        }
        catch (ExprValidationException ex) {
            throw new EPException("Unexpected exception in create-variable context allocation: " + ex.getMessage(), ex);
        }
        return new StatementAgentInstanceFactoryCreateVariableResult(outputViewBase, stopCallback, agentInstanceContext);
    }

    @Override
    public void assignExpressions(StatementAgentInstanceFactoryResult result) {
    }

    @Override
    public void unassignExpressions() {
    }
}

