/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.mgr;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.SafeIterator;
import com.espertech.esper.core.context.mgr.AgentInstance;
import com.espertech.esper.core.context.mgr.AgentInstanceArrayIterator;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.service.StatementAgentInstanceLock;

public class AgentInstanceArraySafeIterator
extends AgentInstanceArrayIterator
implements SafeIterator<EventBean> {
    public AgentInstanceArraySafeIterator(AgentInstance[] instances) {
        super(instances);
        for (AgentInstance instance : instances) {
            StatementAgentInstanceLock instanceLock = instance.getAgentInstanceContext().getEpStatementAgentInstanceHandle().getStatementAgentInstanceLock();
            instanceLock.acquireWriteLock();
        }
    }

    @Override
    public void close() {
        for (AgentInstance instance : this.instances) {
            AgentInstanceContext agentInstanceContext = instance.getAgentInstanceContext();
            StatementAgentInstanceLock instanceLock = agentInstanceContext.getEpStatementAgentInstanceHandle().getStatementAgentInstanceLock();
            if (agentInstanceContext.getStatementContext().getEpStatementHandle().isHasTableAccess()) {
                agentInstanceContext.getTableExprEvaluatorContext().releaseAcquiredLocks();
            }
            instanceLock.releaseWriteLock();
        }
    }
}

