/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.mgr;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.core.context.mgr.ContextControllerCondition;
import com.espertech.esper.core.context.mgr.ContextControllerConditionCallback;
import com.espertech.esper.core.context.mgr.ContextInternalFilterAddendum;
import com.espertech.esper.core.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.core.service.EPStatementHandleCallback;
import com.espertech.esper.core.service.EngineLevelExtensionServicesContext;
import com.espertech.esper.core.service.StatementAgentInstanceFilterVersion;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.spec.ContextDetailConditionCrontab;
import com.espertech.esper.pattern.MatchedEventMap;
import com.espertech.esper.schedule.ScheduleComputeHelper;
import com.espertech.esper.schedule.ScheduleHandleCallback;
import com.espertech.esper.schedule.ScheduleSlot;
import com.espertech.esper.schedule.SchedulingService;
import java.util.Collections;

public class ContextControllerConditionCrontab
implements ContextControllerCondition {
    private final StatementContext statementContext;
    private final ScheduleSlot scheduleSlot;
    private final ContextDetailConditionCrontab spec;
    private final ContextControllerConditionCallback callback;
    private final ContextInternalFilterAddendum filterAddendum;
    private EPStatementHandleCallback scheduleHandle;

    public ContextControllerConditionCrontab(StatementContext statementContext, ScheduleSlot scheduleSlot, ContextDetailConditionCrontab spec, ContextControllerConditionCallback callback, ContextInternalFilterAddendum filterAddendum) {
        this.statementContext = statementContext;
        this.scheduleSlot = scheduleSlot;
        this.spec = spec;
        this.callback = callback;
        this.filterAddendum = filterAddendum;
    }

    @Override
    public void activate(EventBean optionalTriggerEvent, MatchedEventMap priorMatches, long timeOffset, boolean isRecoveringResilient) {
        this.startContextCallback();
    }

    @Override
    public void deactivate() {
        this.endContextCallback();
    }

    @Override
    public boolean isRunning() {
        return this.scheduleHandle != null;
    }

    private void startContextCallback() {
        ScheduleHandleCallback scheduleCallback = new ScheduleHandleCallback(){

            @Override
            public void scheduledTrigger(EngineLevelExtensionServicesContext extensionServicesContext) {
                ContextControllerConditionCrontab.this.scheduleHandle = null;
                ContextControllerConditionCrontab.this.callback.rangeNotification(Collections.<String, Object>emptyMap(), ContextControllerConditionCrontab.this, null, null, ContextControllerConditionCrontab.this.filterAddendum);
            }
        };
        EPStatementAgentInstanceHandle agentHandle = new EPStatementAgentInstanceHandle(this.statementContext.getEpStatementHandle(), this.statementContext.getDefaultAgentInstanceLock(), -1, new StatementAgentInstanceFilterVersion(), this.statementContext.getFilterFaultHandlerFactory());
        this.scheduleHandle = new EPStatementHandleCallback(agentHandle, scheduleCallback);
        SchedulingService schedulingService = this.statementContext.getSchedulingService();
        long nextScheduledTime = ScheduleComputeHelper.computeDeltaNextOccurance(this.spec.getSchedule(), schedulingService.getTime(), this.statementContext.getMethodResolutionService().getEngineImportService().getTimeZone());
        this.statementContext.getSchedulingService().add(nextScheduledTime, this.scheduleHandle, this.scheduleSlot);
    }

    private void endContextCallback() {
        if (this.scheduleHandle != null) {
            this.statementContext.getSchedulingService().remove(this.scheduleHandle, this.scheduleSlot);
        }
        this.scheduleHandle = null;
    }

    @Override
    public Long getExpectedEndTime() {
        return ScheduleComputeHelper.computeNextOccurance(this.spec.getSchedule(), this.statementContext.getTimeProvider().getTime(), this.statementContext.getMethodResolutionService().getEngineImportService().getTimeZone());
    }

    @Override
    public boolean isImmediate() {
        return this.spec.isImmediate();
    }
}

