/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.mgr;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.util.Serializer;
import com.espertech.esper.util.SerializerFactory;
import java.io.IOException;
import java.util.List;
import java.util.zip.CRC32;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContextControllerHashedGetterCRC32Serialized
implements EventPropertyGetter {
    private static final Log log = LogFactory.getLog(ContextControllerHashedGetterCRC32Serialized.class);
    private final String statementName;
    private final ExprEvaluator[] evaluators;
    private final Serializer[] serializers;
    private final int granularity;

    public ContextControllerHashedGetterCRC32Serialized(String statementName, List<ExprNode> nodes, int granularity) {
        this.statementName = statementName;
        this.evaluators = new ExprEvaluator[nodes.size()];
        Class[] returnTypes = new Class[nodes.size()];
        for (int i = 0; i < nodes.size(); ++i) {
            this.evaluators[i] = nodes.get(i).getExprEvaluator();
            returnTypes[i] = this.evaluators[i].getType();
        }
        this.serializers = SerializerFactory.getSerializers(returnTypes);
        this.granularity = granularity;
    }

    @Override
    public Object get(EventBean eventBean) throws PropertyAccessException {
        byte[] bytes;
        EventBean[] events = new EventBean[]{eventBean};
        Object[] parameters = new Object[this.evaluators.length];
        for (int i = 0; i < this.serializers.length; ++i) {
            parameters[i] = this.evaluators[i].evaluate(events, true, null);
        }
        try {
            bytes = SerializerFactory.serialize(this.serializers, parameters);
        }
        catch (IOException e) {
            log.error((Object)("Exception serializing parameters for computing consistent hash for statement '" + this.statementName + "': " + e.getMessage()), (Throwable)e);
            bytes = new byte[]{};
        }
        CRC32 crc = new CRC32();
        crc.update(bytes);
        long value = crc.getValue() % (long)this.granularity;
        int result = (int)value;
        if (result >= 0) {
            return result;
        }
        return -result;
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        return false;
    }

    @Override
    public Object getFragment(EventBean eventBean) throws PropertyAccessException {
        return null;
    }
}

